/*
 * Decompiled with CFR 0.152.
 */
package net.nextpulse.postmarkapp.models.server;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class TemplateValidationRequest {
    @JsonProperty(value="Subject")
    private String subject = null;
    @JsonProperty(value="HtmlBody")
    private String htmlBody = null;
    @JsonProperty(value="TextBody")
    private String textBody = null;
    @JsonProperty(value="TextRenderModel")
    private Object textRenderModel = null;
    @JsonProperty(value="InlineCssForHtmlTestRender")
    private Boolean inlineCssForHtmlTestRender = true;

    public TemplateValidationRequest subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(example="null", value="The subject content to validate. Must be specified if HtmlBody or TextBody are not. See our template language documentation for more information on the syntax for this field. ")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public TemplateValidationRequest htmlBody(String htmlBody) {
        this.htmlBody = htmlBody;
        return this;
    }

    @ApiModelProperty(example="null", value="The html body content to validate. Must be specified if Subject or TextBody are not. See our template language documentation for more information on the syntax for this field. ")
    public String getHtmlBody() {
        return this.htmlBody;
    }

    public void setHtmlBody(String htmlBody) {
        this.htmlBody = htmlBody;
    }

    public TemplateValidationRequest textBody(String textBody) {
        this.textBody = textBody;
        return this;
    }

    @ApiModelProperty(example="null", value="The text body content to validate. Must be specified if HtmlBody or Subject are not. See our template language documentation for more information on the syntax for this field. ")
    public String getTextBody() {
        return this.textBody;
    }

    public void setTextBody(String textBody) {
        this.textBody = textBody;
    }

    public TemplateValidationRequest textRenderModel(Object textRenderModel) {
        this.textRenderModel = textRenderModel;
        return this;
    }

    @ApiModelProperty(example="null", value="The model to be used when rendering test content.")
    public Object getTextRenderModel() {
        return this.textRenderModel;
    }

    public void setTextRenderModel(Object textRenderModel) {
        this.textRenderModel = textRenderModel;
    }

    public TemplateValidationRequest inlineCssForHtmlTestRender(Boolean inlineCssForHtmlTestRender) {
        this.inlineCssForHtmlTestRender = inlineCssForHtmlTestRender;
        return this;
    }

    @ApiModelProperty(example="null", value="When HtmlBody is specified, the test render will have style blocks inlined as style attributes on matching html elements. You may disable the css inlining behavior by passing false for this parameter. ")
    public Boolean getInlineCssForHtmlTestRender() {
        return this.inlineCssForHtmlTestRender;
    }

    public void setInlineCssForHtmlTestRender(Boolean inlineCssForHtmlTestRender) {
        this.inlineCssForHtmlTestRender = inlineCssForHtmlTestRender;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateValidationRequest templateValidationRequest = (TemplateValidationRequest)o;
        return Objects.equals(this.subject, templateValidationRequest.subject) && Objects.equals(this.htmlBody, templateValidationRequest.htmlBody) && Objects.equals(this.textBody, templateValidationRequest.textBody) && Objects.equals(this.textRenderModel, templateValidationRequest.textRenderModel) && Objects.equals(this.inlineCssForHtmlTestRender, templateValidationRequest.inlineCssForHtmlTestRender);
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.htmlBody, this.textBody, this.textRenderModel, this.inlineCssForHtmlTestRender);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TemplateValidationRequest {\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    htmlBody: ").append(this.toIndentedString(this.htmlBody)).append("\n");
        sb.append("    textBody: ").append(this.toIndentedString(this.textBody)).append("\n");
        sb.append("    textRenderModel: ").append(this.toIndentedString(this.textRenderModel)).append("\n");
        sb.append("    inlineCssForHtmlTestRender: ").append(this.toIndentedString(this.inlineCssForHtmlTestRender)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

