/*
 * Decompiled with CFR 0.152.
 */
package net.nextpulse.postmarkapp.models.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import net.nextpulse.postmarkapp.models.server.AttachmentCollection;
import net.nextpulse.postmarkapp.models.server.HeaderCollection;

public class SendEmailRequest {
    @JsonProperty(value="From")
    private String from = null;
    @JsonProperty(value="To")
    private String to = null;
    @JsonProperty(value="Cc")
    private String cc = null;
    @JsonProperty(value="Bcc")
    private String bcc = null;
    @JsonProperty(value="Subject")
    private String subject = null;
    @JsonProperty(value="Tag")
    private String tag = null;
    @JsonProperty(value="HtmlBody")
    private String htmlBody = null;
    @JsonProperty(value="TextBody")
    private String textBody = null;
    @JsonProperty(value="ReplyTo")
    private String replyTo = null;
    @JsonProperty(value="TrackOpens")
    private Boolean trackOpens = null;
    @JsonProperty(value="TrackLinks")
    private TrackLinksEnum trackLinks = null;
    @JsonProperty(value="Headers")
    private HeaderCollection headers = null;
    @JsonProperty(value="Attachments")
    private AttachmentCollection attachments = null;

    public SendEmailRequest from(String from) {
        this.from = from;
        return this;
    }

    @ApiModelProperty(example="null", value="The sender email address. Must have a registered and confirmed Sender Signature.")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public SendEmailRequest to(String to) {
        this.to = to;
        return this;
    }

    @ApiModelProperty(example="null", value="Recipient email address. Multiple addresses are comma seperated. Max 50.")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public SendEmailRequest cc(String cc) {
        this.cc = cc;
        return this;
    }

    @ApiModelProperty(example="null", value="Recipient email address. Multiple addresses are comma seperated. Max 50.")
    public String getCc() {
        return this.cc;
    }

    public void setCc(String cc) {
        this.cc = cc;
    }

    public SendEmailRequest bcc(String bcc) {
        this.bcc = bcc;
        return this;
    }

    @ApiModelProperty(example="null", value="Bcc recipient email address. Multiple addresses are comma seperated. Max 50.")
    public String getBcc() {
        return this.bcc;
    }

    public void setBcc(String bcc) {
        this.bcc = bcc;
    }

    public SendEmailRequest subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(example="null", value="Email Subject")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public SendEmailRequest tag(String tag) {
        this.tag = tag;
        return this;
    }

    @ApiModelProperty(example="null", value="Email tag that allows you to categorize outgoing emails and get detailed statistics.")
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public SendEmailRequest htmlBody(String htmlBody) {
        this.htmlBody = htmlBody;
        return this;
    }

    @ApiModelProperty(example="null", value="If no TextBody specified HTML email message")
    public String getHtmlBody() {
        return this.htmlBody;
    }

    public void setHtmlBody(String htmlBody) {
        this.htmlBody = htmlBody;
    }

    public SendEmailRequest textBody(String textBody) {
        this.textBody = textBody;
        return this;
    }

    @ApiModelProperty(example="null", value="If no HtmlBody specified Plain text email message")
    public String getTextBody() {
        return this.textBody;
    }

    public void setTextBody(String textBody) {
        this.textBody = textBody;
    }

    public SendEmailRequest replyTo(String replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    @ApiModelProperty(example="null", value="Reply To override email address. Defaults to the Reply To set in the sender signature.")
    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public SendEmailRequest trackOpens(Boolean trackOpens) {
        this.trackOpens = trackOpens;
        return this;
    }

    @ApiModelProperty(example="null", value="Activate open tracking for this email.")
    public Boolean getTrackOpens() {
        return this.trackOpens;
    }

    public void setTrackOpens(Boolean trackOpens) {
        this.trackOpens = trackOpens;
    }

    public SendEmailRequest trackLinks(TrackLinksEnum trackLinks) {
        this.trackLinks = trackLinks;
        return this;
    }

    @ApiModelProperty(example="null", value="Replace links in content to enable \"click tracking\" stats. Default is 'null', which uses the server's LinkTracking setting'.")
    public TrackLinksEnum getTrackLinks() {
        return this.trackLinks;
    }

    public void setTrackLinks(TrackLinksEnum trackLinks) {
        this.trackLinks = trackLinks;
    }

    public SendEmailRequest headers(HeaderCollection headers) {
        this.headers = headers;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public HeaderCollection getHeaders() {
        return this.headers;
    }

    public void setHeaders(HeaderCollection headers) {
        this.headers = headers;
    }

    public SendEmailRequest attachments(AttachmentCollection attachments) {
        this.attachments = attachments;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public AttachmentCollection getAttachments() {
        return this.attachments;
    }

    public void setAttachments(AttachmentCollection attachments) {
        this.attachments = attachments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SendEmailRequest sendEmailRequest = (SendEmailRequest)o;
        return Objects.equals(this.from, sendEmailRequest.from) && Objects.equals(this.to, sendEmailRequest.to) && Objects.equals(this.cc, sendEmailRequest.cc) && Objects.equals(this.bcc, sendEmailRequest.bcc) && Objects.equals(this.subject, sendEmailRequest.subject) && Objects.equals(this.tag, sendEmailRequest.tag) && Objects.equals(this.htmlBody, sendEmailRequest.htmlBody) && Objects.equals(this.textBody, sendEmailRequest.textBody) && Objects.equals(this.replyTo, sendEmailRequest.replyTo) && Objects.equals(this.trackOpens, sendEmailRequest.trackOpens) && Objects.equals((Object)this.trackLinks, (Object)sendEmailRequest.trackLinks) && Objects.equals(this.headers, sendEmailRequest.headers) && Objects.equals(this.attachments, sendEmailRequest.attachments);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.from, this.to, this.cc, this.bcc, this.subject, this.tag, this.htmlBody, this.textBody, this.replyTo, this.trackOpens, this.trackLinks, this.headers, this.attachments});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SendEmailRequest {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    cc: ").append(this.toIndentedString(this.cc)).append("\n");
        sb.append("    bcc: ").append(this.toIndentedString(this.bcc)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("    htmlBody: ").append(this.toIndentedString(this.htmlBody)).append("\n");
        sb.append("    textBody: ").append(this.toIndentedString(this.textBody)).append("\n");
        sb.append("    replyTo: ").append(this.toIndentedString(this.replyTo)).append("\n");
        sb.append("    trackOpens: ").append(this.toIndentedString(this.trackOpens)).append("\n");
        sb.append("    trackLinks: ").append(this.toIndentedString((Object)this.trackLinks)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TrackLinksEnum {
        NONE("None"),
        HTMLANDTEXT("HtmlAndText"),
        HTMLONLY("HtmlOnly"),
        TEXTONLY("TextOnly");

        private String value;

        private TrackLinksEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TrackLinksEnum fromValue(String text) {
            for (TrackLinksEnum b : TrackLinksEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

