/*
 * Decompiled with CFR 0.152.
 */
package net.nextpulse.postmarkapp.api.server;

import com.sun.jersey.api.client.GenericType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import net.nextpulse.postmarkapp.api.ApiClient;
import net.nextpulse.postmarkapp.api.ApiException;
import net.nextpulse.postmarkapp.api.Configuration;
import net.nextpulse.postmarkapp.api.Pair;
import net.nextpulse.postmarkapp.models.server.CreateTemplateRequest;
import net.nextpulse.postmarkapp.models.server.EditTemplateRequest;
import net.nextpulse.postmarkapp.models.server.EmailWithTemplateRequest;
import net.nextpulse.postmarkapp.models.server.SendEmailResponse;
import net.nextpulse.postmarkapp.models.server.TemplateDetailResponse;
import net.nextpulse.postmarkapp.models.server.TemplateListingResponse;
import net.nextpulse.postmarkapp.models.server.TemplateRecordResponse;
import net.nextpulse.postmarkapp.models.server.TemplateValidationRequest;
import net.nextpulse.postmarkapp.models.server.TemplateValidationResponse;

public class TemplatesAPIApi {
    private ApiClient apiClient;

    public TemplatesAPIApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TemplatesAPIApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public TemplateDetailResponse deleteTemplate(String xPostmarkServerToken, Integer templateid) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkServerToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling deleteTemplate");
        }
        if (templateid == null) {
            throw new ApiException(400, "Missing the required parameter 'templateid' when calling deleteTemplate");
        }
        String localVarPath = "/templates/{templateid}".replaceAll("\\{format\\}", "json").replaceAll("\\{templateid\\}", this.apiClient.escapeString(templateid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkServerToken != null) {
            localVarHeaderParams.put("X-Postmark-Server-Token", this.apiClient.parameterToString(xPostmarkServerToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<TemplateDetailResponse> localVarReturnType = new GenericType<TemplateDetailResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TemplateDetailResponse getSingleTemplate(String xPostmarkServerToken, Integer templateid) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkServerToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling getSingleTemplate");
        }
        if (templateid == null) {
            throw new ApiException(400, "Missing the required parameter 'templateid' when calling getSingleTemplate");
        }
        String localVarPath = "/templates/{templateid}".replaceAll("\\{format\\}", "json").replaceAll("\\{templateid\\}", this.apiClient.escapeString(templateid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkServerToken != null) {
            localVarHeaderParams.put("X-Postmark-Server-Token", this.apiClient.parameterToString(xPostmarkServerToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<TemplateDetailResponse> localVarReturnType = new GenericType<TemplateDetailResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TemplateListingResponse listTemplates(String xPostmarkServerToken, BigDecimal count, BigDecimal offset) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkServerToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling listTemplates");
        }
        if (count == null) {
            throw new ApiException(400, "Missing the required parameter 'count' when calling listTemplates");
        }
        if (offset == null) {
            throw new ApiException(400, "Missing the required parameter 'offset' when calling listTemplates");
        }
        String localVarPath = "/templates".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "Count", count));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "Offset", offset));
        if (xPostmarkServerToken != null) {
            localVarHeaderParams.put("X-Postmark-Server-Token", this.apiClient.parameterToString(xPostmarkServerToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<TemplateListingResponse> localVarReturnType = new GenericType<TemplateListingResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SendEmailResponse sendEmailWithTemplate(String xPostmarkServerToken, EmailWithTemplateRequest body) throws ApiException {
        EmailWithTemplateRequest localVarPostBody = body;
        if (xPostmarkServerToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling sendEmailWithTemplate");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling sendEmailWithTemplate");
        }
        String localVarPath = "/email/withTemplate".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkServerToken != null) {
            localVarHeaderParams.put("X-Postmark-Server-Token", this.apiClient.parameterToString(xPostmarkServerToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<SendEmailResponse> localVarReturnType = new GenericType<SendEmailResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TemplateRecordResponse templatesPost(String xPostmarkServerToken, CreateTemplateRequest body) throws ApiException {
        CreateTemplateRequest localVarPostBody = body;
        if (xPostmarkServerToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling templatesPost");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling templatesPost");
        }
        String localVarPath = "/templates".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkServerToken != null) {
            localVarHeaderParams.put("X-Postmark-Server-Token", this.apiClient.parameterToString(xPostmarkServerToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<TemplateRecordResponse> localVarReturnType = new GenericType<TemplateRecordResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TemplateValidationResponse testTemplateContent(String xPostmarkServerToken, TemplateValidationRequest body) throws ApiException {
        TemplateValidationRequest localVarPostBody = body;
        if (xPostmarkServerToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling testTemplateContent");
        }
        String localVarPath = "/templates/validate".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkServerToken != null) {
            localVarHeaderParams.put("X-Postmark-Server-Token", this.apiClient.parameterToString(xPostmarkServerToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<TemplateValidationResponse> localVarReturnType = new GenericType<TemplateValidationResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TemplateRecordResponse updateTemplate(String xPostmarkServerToken, Integer templateid, EditTemplateRequest body) throws ApiException {
        EditTemplateRequest localVarPostBody = body;
        if (xPostmarkServerToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling updateTemplate");
        }
        if (templateid == null) {
            throw new ApiException(400, "Missing the required parameter 'templateid' when calling updateTemplate");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateTemplate");
        }
        String localVarPath = "/templates/{templateid}".replaceAll("\\{format\\}", "json").replaceAll("\\{templateid\\}", this.apiClient.escapeString(templateid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkServerToken != null) {
            localVarHeaderParams.put("X-Postmark-Server-Token", this.apiClient.parameterToString(xPostmarkServerToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<TemplateRecordResponse> localVarReturnType = new GenericType<TemplateRecordResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

