/*
 * Decompiled with CFR 0.152.
 */
package net.nextpulse.postmarkapp.api.server;

import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import net.nextpulse.postmarkapp.api.ApiClient;
import net.nextpulse.postmarkapp.api.ApiException;
import net.nextpulse.postmarkapp.api.Configuration;
import net.nextpulse.postmarkapp.api.Pair;
import net.nextpulse.postmarkapp.models.server.InboundMessageFullDetailsResponse;
import net.nextpulse.postmarkapp.models.server.InboundSearchResponse;
import net.nextpulse.postmarkapp.models.server.MessageOpenSearchResponse;
import net.nextpulse.postmarkapp.models.server.OutboundMessageDetailsResponse;
import net.nextpulse.postmarkapp.models.server.OutboundMessageDumpResponse;
import net.nextpulse.postmarkapp.models.server.OutboundSearchResponse;
import net.nextpulse.postmarkapp.models.server.StandardPostmarkResponse;

public class MessagesAPIApi {
    private ApiClient apiClient;

    public MessagesAPIApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MessagesAPIApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public StandardPostmarkResponse bypassRulesForInboundMessage(String xPostmarkServerToken, String messageid) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkServerToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling bypassRulesForInboundMessage");
        }
        if (messageid == null) {
            throw new ApiException(400, "Missing the required parameter 'messageid' when calling bypassRulesForInboundMessage");
        }
        String localVarPath = "/messages/inbound/{messageid}/bypass".replaceAll("\\{format\\}", "json").replaceAll("\\{messageid\\}", this.apiClient.escapeString(messageid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkServerToken != null) {
            localVarHeaderParams.put("X-Postmark-Server-Token", this.apiClient.parameterToString(xPostmarkServerToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<StandardPostmarkResponse> localVarReturnType = new GenericType<StandardPostmarkResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public InboundMessageFullDetailsResponse getInboundMessageDetails(String xPostmarkServerToken, String messageid) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkServerToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling getInboundMessageDetails");
        }
        if (messageid == null) {
            throw new ApiException(400, "Missing the required parameter 'messageid' when calling getInboundMessageDetails");
        }
        String localVarPath = "/messages/inbound/{messageid}/details".replaceAll("\\{format\\}", "json").replaceAll("\\{messageid\\}", this.apiClient.escapeString(messageid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkServerToken != null) {
            localVarHeaderParams.put("X-Postmark-Server-Token", this.apiClient.parameterToString(xPostmarkServerToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<InboundMessageFullDetailsResponse> localVarReturnType = new GenericType<InboundMessageFullDetailsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MessageOpenSearchResponse getOpensForSingleOutboundMessage(String xPostmarkServerToken, String messageid, Integer count, Integer offset) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkServerToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling getOpensForSingleOutboundMessage");
        }
        if (messageid == null) {
            throw new ApiException(400, "Missing the required parameter 'messageid' when calling getOpensForSingleOutboundMessage");
        }
        if (count == null) {
            throw new ApiException(400, "Missing the required parameter 'count' when calling getOpensForSingleOutboundMessage");
        }
        if (offset == null) {
            throw new ApiException(400, "Missing the required parameter 'offset' when calling getOpensForSingleOutboundMessage");
        }
        String localVarPath = "/messages/outbound/opens/{messageid}".replaceAll("\\{format\\}", "json").replaceAll("\\{messageid\\}", this.apiClient.escapeString(messageid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        if (xPostmarkServerToken != null) {
            localVarHeaderParams.put("X-Postmark-Server-Token", this.apiClient.parameterToString(xPostmarkServerToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MessageOpenSearchResponse> localVarReturnType = new GenericType<MessageOpenSearchResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OutboundMessageDetailsResponse getOutboundMessageDetails(String xPostmarkServerToken, String messageid) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkServerToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling getOutboundMessageDetails");
        }
        if (messageid == null) {
            throw new ApiException(400, "Missing the required parameter 'messageid' when calling getOutboundMessageDetails");
        }
        String localVarPath = "/messages/outbound/{messageid}/details".replaceAll("\\{format\\}", "json").replaceAll("\\{messageid\\}", this.apiClient.escapeString(messageid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkServerToken != null) {
            localVarHeaderParams.put("X-Postmark-Server-Token", this.apiClient.parameterToString(xPostmarkServerToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<OutboundMessageDetailsResponse> localVarReturnType = new GenericType<OutboundMessageDetailsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OutboundMessageDumpResponse getOutboundMessageDump(String xPostmarkServerToken, String messageid) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkServerToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling getOutboundMessageDump");
        }
        if (messageid == null) {
            throw new ApiException(400, "Missing the required parameter 'messageid' when calling getOutboundMessageDump");
        }
        String localVarPath = "/messages/outbound/{messageid}/dump".replaceAll("\\{format\\}", "json").replaceAll("\\{messageid\\}", this.apiClient.escapeString(messageid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkServerToken != null) {
            localVarHeaderParams.put("X-Postmark-Server-Token", this.apiClient.parameterToString(xPostmarkServerToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<OutboundMessageDumpResponse> localVarReturnType = new GenericType<OutboundMessageDumpResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public StandardPostmarkResponse retryInboundMessageProcessing(String xPostmarkServerToken, String messageid) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkServerToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling retryInboundMessageProcessing");
        }
        if (messageid == null) {
            throw new ApiException(400, "Missing the required parameter 'messageid' when calling retryInboundMessageProcessing");
        }
        String localVarPath = "/messages/inbound/{messageid}/retry".replaceAll("\\{format\\}", "json").replaceAll("\\{messageid\\}", this.apiClient.escapeString(messageid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkServerToken != null) {
            localVarHeaderParams.put("X-Postmark-Server-Token", this.apiClient.parameterToString(xPostmarkServerToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<StandardPostmarkResponse> localVarReturnType = new GenericType<StandardPostmarkResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public InboundSearchResponse searchInboundMessages(String xPostmarkServerToken, Integer count, Integer offset, String recipient, String fromemail, String subject, String mailboxhash, String tag, String status, Date todate, Date fromdate) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkServerToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling searchInboundMessages");
        }
        if (count == null) {
            throw new ApiException(400, "Missing the required parameter 'count' when calling searchInboundMessages");
        }
        if (offset == null) {
            throw new ApiException(400, "Missing the required parameter 'offset' when calling searchInboundMessages");
        }
        String localVarPath = "/messages/inbound".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "recipient", recipient));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fromemail", fromemail));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "subject", subject));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "mailboxhash", mailboxhash));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tag", tag));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "status", status));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "todate", todate));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fromdate", fromdate));
        if (xPostmarkServerToken != null) {
            localVarHeaderParams.put("X-Postmark-Server-Token", this.apiClient.parameterToString(xPostmarkServerToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<InboundSearchResponse> localVarReturnType = new GenericType<InboundSearchResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MessageOpenSearchResponse searchOpensForOutboundMessages(String xPostmarkServerToken, Integer count, Integer offset, String recipient, String tag, String clientName, String clientCompany, String clientFamily, String osName, String osFamily, String osCompany, String platform, String country, String region, String city) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkServerToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling searchOpensForOutboundMessages");
        }
        if (count == null) {
            throw new ApiException(400, "Missing the required parameter 'count' when calling searchOpensForOutboundMessages");
        }
        if (offset == null) {
            throw new ApiException(400, "Missing the required parameter 'offset' when calling searchOpensForOutboundMessages");
        }
        String localVarPath = "/messages/outbound/opens".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "recipient", recipient));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tag", tag));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "client_name", clientName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "client_company", clientCompany));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "client_family", clientFamily));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "os_name", osName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "os_family", osFamily));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "os_company", osCompany));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "platform", platform));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "country", country));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "region", region));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "city", city));
        if (xPostmarkServerToken != null) {
            localVarHeaderParams.put("X-Postmark-Server-Token", this.apiClient.parameterToString(xPostmarkServerToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MessageOpenSearchResponse> localVarReturnType = new GenericType<MessageOpenSearchResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OutboundSearchResponse searchOutboundMessages(String xPostmarkServerToken, Integer count, Integer offset, String recipient, String fromemail, String tag, String status, Date todate, Date fromdate) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkServerToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling searchOutboundMessages");
        }
        if (count == null) {
            throw new ApiException(400, "Missing the required parameter 'count' when calling searchOutboundMessages");
        }
        if (offset == null) {
            throw new ApiException(400, "Missing the required parameter 'offset' when calling searchOutboundMessages");
        }
        String localVarPath = "/messages/outbound".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "recipient", recipient));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fromemail", fromemail));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tag", tag));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "status", status));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "todate", todate));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fromdate", fromdate));
        if (xPostmarkServerToken != null) {
            localVarHeaderParams.put("X-Postmark-Server-Token", this.apiClient.parameterToString(xPostmarkServerToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<OutboundSearchResponse> localVarReturnType = new GenericType<OutboundSearchResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

