/*
 * Decompiled with CFR 0.152.
 */
package net.nextpulse.postmarkapp.api.server;

import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import net.nextpulse.postmarkapp.api.ApiClient;
import net.nextpulse.postmarkapp.api.ApiException;
import net.nextpulse.postmarkapp.api.Configuration;
import net.nextpulse.postmarkapp.api.Pair;
import net.nextpulse.postmarkapp.models.server.BounceActivationResponse;
import net.nextpulse.postmarkapp.models.server.BounceDumpResponse;
import net.nextpulse.postmarkapp.models.server.BounceInfoResponse;
import net.nextpulse.postmarkapp.models.server.BounceSearchResponse;
import net.nextpulse.postmarkapp.models.server.DeliveryStatsResponse;

public class BouncesAPIApi {
    private ApiClient apiClient;

    public BouncesAPIApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BouncesAPIApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public BounceActivationResponse activateBounce(String xPostmarkServerToken, Long bounceid) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkServerToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling activateBounce");
        }
        if (bounceid == null) {
            throw new ApiException(400, "Missing the required parameter 'bounceid' when calling activateBounce");
        }
        String localVarPath = "/bounces/{bounceid}/activate".replaceAll("\\{format\\}", "json").replaceAll("\\{bounceid\\}", this.apiClient.escapeString(bounceid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkServerToken != null) {
            localVarHeaderParams.put("X-Postmark-Server-Token", this.apiClient.parameterToString(xPostmarkServerToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<BounceActivationResponse> localVarReturnType = new GenericType<BounceActivationResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BounceDumpResponse bouncesBounceidDumpGet(String xPostmarkServerToken, Long bounceid) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkServerToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling bouncesBounceidDumpGet");
        }
        if (bounceid == null) {
            throw new ApiException(400, "Missing the required parameter 'bounceid' when calling bouncesBounceidDumpGet");
        }
        String localVarPath = "/bounces/{bounceid}/dump".replaceAll("\\{format\\}", "json").replaceAll("\\{bounceid\\}", this.apiClient.escapeString(bounceid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkServerToken != null) {
            localVarHeaderParams.put("X-Postmark-Server-Token", this.apiClient.parameterToString(xPostmarkServerToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<BounceDumpResponse> localVarReturnType = new GenericType<BounceDumpResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<String> getBouncedTags(String xPostmarkServerToken) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkServerToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling getBouncedTags");
        }
        String localVarPath = "/bounces/tags".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkServerToken != null) {
            localVarHeaderParams.put("X-Postmark-Server-Token", this.apiClient.parameterToString(xPostmarkServerToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<String>> localVarReturnType = new GenericType<List<String>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BounceSearchResponse getBounces(String xPostmarkServerToken, Integer count, Integer offset, String type, Boolean inactive, String emailFilter, String messageID, String tag, Date todate, Date fromdate) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkServerToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling getBounces");
        }
        if (count == null) {
            throw new ApiException(400, "Missing the required parameter 'count' when calling getBounces");
        }
        if (offset == null) {
            throw new ApiException(400, "Missing the required parameter 'offset' when calling getBounces");
        }
        String localVarPath = "/bounces".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "type", type));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "inactive", inactive));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "emailFilter", emailFilter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "messageID", messageID));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tag", tag));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "todate", todate));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fromdate", fromdate));
        if (xPostmarkServerToken != null) {
            localVarHeaderParams.put("X-Postmark-Server-Token", this.apiClient.parameterToString(xPostmarkServerToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<BounceSearchResponse> localVarReturnType = new GenericType<BounceSearchResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DeliveryStatsResponse getDeliveryStats(String xPostmarkServerToken) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkServerToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling getDeliveryStats");
        }
        String localVarPath = "/deliverystats".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkServerToken != null) {
            localVarHeaderParams.put("X-Postmark-Server-Token", this.apiClient.parameterToString(xPostmarkServerToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<DeliveryStatsResponse> localVarReturnType = new GenericType<DeliveryStatsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BounceInfoResponse getSingleBounce(String xPostmarkServerToken, Long bounceid) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkServerToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling getSingleBounce");
        }
        if (bounceid == null) {
            throw new ApiException(400, "Missing the required parameter 'bounceid' when calling getSingleBounce");
        }
        String localVarPath = "/bounces/{bounceid}".replaceAll("\\{format\\}", "json").replaceAll("\\{bounceid\\}", this.apiClient.escapeString(bounceid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkServerToken != null) {
            localVarHeaderParams.put("X-Postmark-Server-Token", this.apiClient.parameterToString(xPostmarkServerToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<BounceInfoResponse> localVarReturnType = new GenericType<BounceInfoResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

