/*
 * Decompiled with CFR 0.152.
 */
package net.nextpulse.postmarkapp.api.account;

import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import net.nextpulse.postmarkapp.api.ApiClient;
import net.nextpulse.postmarkapp.api.ApiException;
import net.nextpulse.postmarkapp.api.Configuration;
import net.nextpulse.postmarkapp.api.Pair;
import net.nextpulse.postmarkapp.models.account.CreateServerPayload;
import net.nextpulse.postmarkapp.models.account.EditServerPayload;
import net.nextpulse.postmarkapp.models.account.ExtendedServerInfo;
import net.nextpulse.postmarkapp.models.account.ServerListingResponse;

public class ServerManagementAPIApi {
    private ApiClient apiClient;

    public ServerManagementAPIApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ServerManagementAPIApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ExtendedServerInfo createServer(String xPostmarkAccountToken, CreateServerPayload body) throws ApiException {
        CreateServerPayload localVarPostBody = body;
        if (xPostmarkAccountToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkAccountToken' when calling createServer");
        }
        String localVarPath = "/servers".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkAccountToken != null) {
            localVarHeaderParams.put("X-Postmark-Account-Token", this.apiClient.parameterToString(xPostmarkAccountToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<ExtendedServerInfo> localVarReturnType = new GenericType<ExtendedServerInfo>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteServer(String xPostmarkAccountToken, Integer serverid) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkAccountToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkAccountToken' when calling deleteServer");
        }
        if (serverid == null) {
            throw new ApiException(400, "Missing the required parameter 'serverid' when calling deleteServer");
        }
        String localVarPath = "/servers/{serverid}".replaceAll("\\{format\\}", "json").replaceAll("\\{serverid\\}", this.apiClient.escapeString(serverid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkAccountToken != null) {
            localVarHeaderParams.put("X-Postmark-Account-Token", this.apiClient.parameterToString(xPostmarkAccountToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public ExtendedServerInfo editServerInformation(String xPostmarkAccountToken, Integer serverid, EditServerPayload body) throws ApiException {
        EditServerPayload localVarPostBody = body;
        if (xPostmarkAccountToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkAccountToken' when calling editServerInformation");
        }
        if (serverid == null) {
            throw new ApiException(400, "Missing the required parameter 'serverid' when calling editServerInformation");
        }
        String localVarPath = "/servers/{serverid}".replaceAll("\\{format\\}", "json").replaceAll("\\{serverid\\}", this.apiClient.escapeString(serverid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkAccountToken != null) {
            localVarHeaderParams.put("X-Postmark-Account-Token", this.apiClient.parameterToString(xPostmarkAccountToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<ExtendedServerInfo> localVarReturnType = new GenericType<ExtendedServerInfo>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ExtendedServerInfo getServerInformation(String xPostmarkAccountToken, Integer serverid) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkAccountToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkAccountToken' when calling getServerInformation");
        }
        if (serverid == null) {
            throw new ApiException(400, "Missing the required parameter 'serverid' when calling getServerInformation");
        }
        String localVarPath = "/servers/{serverid}".replaceAll("\\{format\\}", "json").replaceAll("\\{serverid\\}", this.apiClient.escapeString(serverid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkAccountToken != null) {
            localVarHeaderParams.put("X-Postmark-Account-Token", this.apiClient.parameterToString(xPostmarkAccountToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<ExtendedServerInfo> localVarReturnType = new GenericType<ExtendedServerInfo>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ServerListingResponse listServers(String xPostmarkAccountToken, Integer count, Integer offset, String name) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkAccountToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkAccountToken' when calling listServers");
        }
        if (count == null) {
            throw new ApiException(400, "Missing the required parameter 'count' when calling listServers");
        }
        if (offset == null) {
            throw new ApiException(400, "Missing the required parameter 'offset' when calling listServers");
        }
        String localVarPath = "/servers".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "name", name));
        if (xPostmarkAccountToken != null) {
            localVarHeaderParams.put("X-Postmark-Account-Token", this.apiClient.parameterToString(xPostmarkAccountToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<ServerListingResponse> localVarReturnType = new GenericType<ServerListingResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

