/*
 * Decompiled with CFR 0.152.
 */
package net.nextpulse.postmarkapp.api.account;

import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import net.nextpulse.postmarkapp.api.ApiClient;
import net.nextpulse.postmarkapp.api.ApiException;
import net.nextpulse.postmarkapp.api.Configuration;
import net.nextpulse.postmarkapp.api.Pair;
import net.nextpulse.postmarkapp.models.account.SenderListingResults;
import net.nextpulse.postmarkapp.models.account.SenderSignatureCreationModel;
import net.nextpulse.postmarkapp.models.account.SenderSignatureEditingModel;
import net.nextpulse.postmarkapp.models.account.SenderSignatureExtendedInformation;
import net.nextpulse.postmarkapp.models.account.StandardPostmarkResponse;

public class SenderSignaturesAPIApi {
    private ApiClient apiClient;

    public SenderSignaturesAPIApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SenderSignaturesAPIApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public SenderSignatureExtendedInformation createSenderSignature(String xPostmarkAccountToken, SenderSignatureCreationModel body) throws ApiException {
        SenderSignatureCreationModel localVarPostBody = body;
        if (xPostmarkAccountToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkAccountToken' when calling createSenderSignature");
        }
        String localVarPath = "/senders".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkAccountToken != null) {
            localVarHeaderParams.put("X-Postmark-Account-Token", this.apiClient.parameterToString(xPostmarkAccountToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<SenderSignatureExtendedInformation> localVarReturnType = new GenericType<SenderSignatureExtendedInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public StandardPostmarkResponse deleteSenderSignature(String xPostmarkAccountToken, Integer signatureid) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkAccountToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkAccountToken' when calling deleteSenderSignature");
        }
        if (signatureid == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureid' when calling deleteSenderSignature");
        }
        String localVarPath = "/senders/{signatureid}".replaceAll("\\{format\\}", "json").replaceAll("\\{signatureid\\}", this.apiClient.escapeString(signatureid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkAccountToken != null) {
            localVarHeaderParams.put("X-Postmark-Account-Token", this.apiClient.parameterToString(xPostmarkAccountToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<StandardPostmarkResponse> localVarReturnType = new GenericType<StandardPostmarkResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SenderSignatureExtendedInformation editSenderSignature(String xPostmarkAccountToken, Integer signatureid, SenderSignatureEditingModel body) throws ApiException {
        SenderSignatureEditingModel localVarPostBody = body;
        if (xPostmarkAccountToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkAccountToken' when calling editSenderSignature");
        }
        if (signatureid == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureid' when calling editSenderSignature");
        }
        String localVarPath = "/senders/{signatureid}".replaceAll("\\{format\\}", "json").replaceAll("\\{signatureid\\}", this.apiClient.escapeString(signatureid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkAccountToken != null) {
            localVarHeaderParams.put("X-Postmark-Account-Token", this.apiClient.parameterToString(xPostmarkAccountToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<SenderSignatureExtendedInformation> localVarReturnType = new GenericType<SenderSignatureExtendedInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SenderSignatureExtendedInformation getSenderSignature(String xPostmarkAccountToken, Integer signatureid) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkAccountToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkAccountToken' when calling getSenderSignature");
        }
        if (signatureid == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureid' when calling getSenderSignature");
        }
        String localVarPath = "/senders/{signatureid}".replaceAll("\\{format\\}", "json").replaceAll("\\{signatureid\\}", this.apiClient.escapeString(signatureid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkAccountToken != null) {
            localVarHeaderParams.put("X-Postmark-Account-Token", this.apiClient.parameterToString(xPostmarkAccountToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<SenderSignatureExtendedInformation> localVarReturnType = new GenericType<SenderSignatureExtendedInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SenderListingResults listSenderSignatures(String xPostmarkAccountToken, Integer count, Integer offset) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkAccountToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkAccountToken' when calling listSenderSignatures");
        }
        if (count == null) {
            throw new ApiException(400, "Missing the required parameter 'count' when calling listSenderSignatures");
        }
        if (offset == null) {
            throw new ApiException(400, "Missing the required parameter 'offset' when calling listSenderSignatures");
        }
        String localVarPath = "/senders".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        if (xPostmarkAccountToken != null) {
            localVarHeaderParams.put("X-Postmark-Account-Token", this.apiClient.parameterToString(xPostmarkAccountToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<SenderListingResults> localVarReturnType = new GenericType<SenderListingResults>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public StandardPostmarkResponse requestNewDKIMKeyForSenderSignature(String xPostmarkAccountToken, Integer signatureid) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkAccountToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkAccountToken' when calling requestNewDKIMKeyForSenderSignature");
        }
        if (signatureid == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureid' when calling requestNewDKIMKeyForSenderSignature");
        }
        String localVarPath = "/senders/{signatureid}/requestnewdkim".replaceAll("\\{format\\}", "json").replaceAll("\\{signatureid\\}", this.apiClient.escapeString(signatureid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkAccountToken != null) {
            localVarHeaderParams.put("X-Postmark-Account-Token", this.apiClient.parameterToString(xPostmarkAccountToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<StandardPostmarkResponse> localVarReturnType = new GenericType<StandardPostmarkResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SenderSignatureExtendedInformation requestSPFVerificationForSenderSignature(String xPostmarkAccountToken, Integer signatureid) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkAccountToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkAccountToken' when calling requestSPFVerificationForSenderSignature");
        }
        if (signatureid == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureid' when calling requestSPFVerificationForSenderSignature");
        }
        String localVarPath = "/senders/{signatureid}/verifyspf".replaceAll("\\{format\\}", "json").replaceAll("\\{signatureid\\}", this.apiClient.escapeString(signatureid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkAccountToken != null) {
            localVarHeaderParams.put("X-Postmark-Account-Token", this.apiClient.parameterToString(xPostmarkAccountToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<SenderSignatureExtendedInformation> localVarReturnType = new GenericType<SenderSignatureExtendedInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public StandardPostmarkResponse resendSenderSignatureConfirmationEmail(String xPostmarkAccountToken, Integer signatureid) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkAccountToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkAccountToken' when calling resendSenderSignatureConfirmationEmail");
        }
        if (signatureid == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureid' when calling resendSenderSignatureConfirmationEmail");
        }
        String localVarPath = "/senders/{signatureid}/resend".replaceAll("\\{format\\}", "json").replaceAll("\\{signatureid\\}", this.apiClient.escapeString(signatureid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkAccountToken != null) {
            localVarHeaderParams.put("X-Postmark-Account-Token", this.apiClient.parameterToString(xPostmarkAccountToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<StandardPostmarkResponse> localVarReturnType = new GenericType<StandardPostmarkResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

