/*
 * Decompiled with CFR 0.152.
 */
package net.nextpulse.postmarkapp.api.account;

import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import net.nextpulse.postmarkapp.api.ApiClient;
import net.nextpulse.postmarkapp.api.ApiException;
import net.nextpulse.postmarkapp.api.Configuration;
import net.nextpulse.postmarkapp.api.Pair;
import net.nextpulse.postmarkapp.models.account.DKIMRotationResponse;
import net.nextpulse.postmarkapp.models.account.DomainCreationModel;
import net.nextpulse.postmarkapp.models.account.DomainEditingModel;
import net.nextpulse.postmarkapp.models.account.DomainExtendedInformation;
import net.nextpulse.postmarkapp.models.account.DomainListingResults;
import net.nextpulse.postmarkapp.models.account.DomainSPFResult;
import net.nextpulse.postmarkapp.models.account.StandardPostmarkResponse;

public class DomainsAPIApi {
    private ApiClient apiClient;

    public DomainsAPIApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DomainsAPIApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public DomainExtendedInformation createDomain(String xPostmarkAccountToken, DomainCreationModel body) throws ApiException {
        DomainCreationModel localVarPostBody = body;
        if (xPostmarkAccountToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkAccountToken' when calling createDomain");
        }
        String localVarPath = "/domains".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkAccountToken != null) {
            localVarHeaderParams.put("X-Postmark-Account-Token", this.apiClient.parameterToString(xPostmarkAccountToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<DomainExtendedInformation> localVarReturnType = new GenericType<DomainExtendedInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public StandardPostmarkResponse deleteDomain(String xPostmarkAccountToken, Integer domainid) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkAccountToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkAccountToken' when calling deleteDomain");
        }
        if (domainid == null) {
            throw new ApiException(400, "Missing the required parameter 'domainid' when calling deleteDomain");
        }
        String localVarPath = "/domains/{domainid}".replaceAll("\\{format\\}", "json").replaceAll("\\{domainid\\}", this.apiClient.escapeString(domainid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkAccountToken != null) {
            localVarHeaderParams.put("X-Postmark-Account-Token", this.apiClient.parameterToString(xPostmarkAccountToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<StandardPostmarkResponse> localVarReturnType = new GenericType<StandardPostmarkResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DomainExtendedInformation editDomain(String xPostmarkAccountToken, Integer domainid, DomainEditingModel body) throws ApiException {
        DomainEditingModel localVarPostBody = body;
        if (xPostmarkAccountToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkAccountToken' when calling editDomain");
        }
        if (domainid == null) {
            throw new ApiException(400, "Missing the required parameter 'domainid' when calling editDomain");
        }
        String localVarPath = "/domains/{domainid}".replaceAll("\\{format\\}", "json").replaceAll("\\{domainid\\}", this.apiClient.escapeString(domainid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkAccountToken != null) {
            localVarHeaderParams.put("X-Postmark-Account-Token", this.apiClient.parameterToString(xPostmarkAccountToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<DomainExtendedInformation> localVarReturnType = new GenericType<DomainExtendedInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DomainExtendedInformation getDomain(String xPostmarkAccountToken, Integer domainid) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkAccountToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkAccountToken' when calling getDomain");
        }
        if (domainid == null) {
            throw new ApiException(400, "Missing the required parameter 'domainid' when calling getDomain");
        }
        String localVarPath = "/domains/{domainid}".replaceAll("\\{format\\}", "json").replaceAll("\\{domainid\\}", this.apiClient.escapeString(domainid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkAccountToken != null) {
            localVarHeaderParams.put("X-Postmark-Account-Token", this.apiClient.parameterToString(xPostmarkAccountToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<DomainExtendedInformation> localVarReturnType = new GenericType<DomainExtendedInformation>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DomainListingResults listDomains(String xPostmarkAccountToken, Integer count, Integer offset) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkAccountToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkAccountToken' when calling listDomains");
        }
        if (count == null) {
            throw new ApiException(400, "Missing the required parameter 'count' when calling listDomains");
        }
        if (offset == null) {
            throw new ApiException(400, "Missing the required parameter 'offset' when calling listDomains");
        }
        String localVarPath = "/domains".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        if (xPostmarkAccountToken != null) {
            localVarHeaderParams.put("X-Postmark-Account-Token", this.apiClient.parameterToString(xPostmarkAccountToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<DomainListingResults> localVarReturnType = new GenericType<DomainListingResults>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DomainSPFResult requestSPFVerificationForDomain(String xPostmarkAccountToken, Integer domainid) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkAccountToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkAccountToken' when calling requestSPFVerificationForDomain");
        }
        if (domainid == null) {
            throw new ApiException(400, "Missing the required parameter 'domainid' when calling requestSPFVerificationForDomain");
        }
        String localVarPath = "/domains/{domainid}/verifyspf".replaceAll("\\{format\\}", "json").replaceAll("\\{domainid\\}", this.apiClient.escapeString(domainid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkAccountToken != null) {
            localVarHeaderParams.put("X-Postmark-Account-Token", this.apiClient.parameterToString(xPostmarkAccountToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<DomainSPFResult> localVarReturnType = new GenericType<DomainSPFResult>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DKIMRotationResponse rotateDKIMKeyForDomain(String xPostmarkAccountToken, Integer domainid) throws ApiException {
        Object localVarPostBody = null;
        if (xPostmarkAccountToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xPostmarkAccountToken' when calling rotateDKIMKeyForDomain");
        }
        if (domainid == null) {
            throw new ApiException(400, "Missing the required parameter 'domainid' when calling rotateDKIMKeyForDomain");
        }
        String localVarPath = "/domains/{domainid}/rotatedkim".replaceAll("\\{format\\}", "json").replaceAll("\\{domainid\\}", this.apiClient.escapeString(domainid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xPostmarkAccountToken != null) {
            localVarHeaderParams.put("X-Postmark-Account-Token", this.apiClient.parameterToString(xPostmarkAccountToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<DKIMRotationResponse> localVarReturnType = new GenericType<DKIMRotationResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

