/*
 * Postmark API
 * Postmark makes sending and receiving email incredibly easy. 
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package net.nextpulse.postmarkapp.models.server;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import net.nextpulse.postmarkapp.models.server.AttachmentCollection;
import net.nextpulse.postmarkapp.models.server.HeaderCollection;

/**
 * SendEmailRequest
 */
@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2017-02-24T16:43:29.220+01:00")
public class SendEmailRequest {
  @JsonProperty("From")
  private String from = null;

  @JsonProperty("To")
  private String to = null;

  @JsonProperty("Cc")
  private String cc = null;

  @JsonProperty("Bcc")
  private String bcc = null;

  @JsonProperty("Subject")
  private String subject = null;

  @JsonProperty("Tag")
  private String tag = null;

  @JsonProperty("HtmlBody")
  private String htmlBody = null;

  @JsonProperty("TextBody")
  private String textBody = null;

  @JsonProperty("ReplyTo")
  private String replyTo = null;

  @JsonProperty("TrackOpens")
  private Boolean trackOpens = null;

  /**
   * Replace links in content to enable \"click tracking\" stats. Default is 'null', which uses the server's LinkTracking setting'.
   */
  public enum TrackLinksEnum {
    NONE("None"),
    
    HTMLANDTEXT("HtmlAndText"),
    
    HTMLONLY("HtmlOnly"),
    
    TEXTONLY("TextOnly");

    private String value;

    TrackLinksEnum(String value) {
      this.value = value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TrackLinksEnum fromValue(String text) {
      for (TrackLinksEnum b : TrackLinksEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("TrackLinks")
  private TrackLinksEnum trackLinks = null;

  @JsonProperty("Headers")
  private HeaderCollection headers = null;

  @JsonProperty("Attachments")
  private AttachmentCollection attachments = null;

  public SendEmailRequest from(String from) {
    this.from = from;
    return this;
  }

   /**
   * The sender email address. Must have a registered and confirmed Sender Signature.
   * @return from
  **/
  @ApiModelProperty(example = "null", value = "The sender email address. Must have a registered and confirmed Sender Signature.")
  public String getFrom() {
    return from;
  }

  public void setFrom(String from) {
    this.from = from;
  }

  public SendEmailRequest to(String to) {
    this.to = to;
    return this;
  }

   /**
   * Recipient email address. Multiple addresses are comma seperated. Max 50.
   * @return to
  **/
  @ApiModelProperty(example = "null", value = "Recipient email address. Multiple addresses are comma seperated. Max 50.")
  public String getTo() {
    return to;
  }

  public void setTo(String to) {
    this.to = to;
  }

  public SendEmailRequest cc(String cc) {
    this.cc = cc;
    return this;
  }

   /**
   * Recipient email address. Multiple addresses are comma seperated. Max 50.
   * @return cc
  **/
  @ApiModelProperty(example = "null", value = "Recipient email address. Multiple addresses are comma seperated. Max 50.")
  public String getCc() {
    return cc;
  }

  public void setCc(String cc) {
    this.cc = cc;
  }

  public SendEmailRequest bcc(String bcc) {
    this.bcc = bcc;
    return this;
  }

   /**
   * Bcc recipient email address. Multiple addresses are comma seperated. Max 50.
   * @return bcc
  **/
  @ApiModelProperty(example = "null", value = "Bcc recipient email address. Multiple addresses are comma seperated. Max 50.")
  public String getBcc() {
    return bcc;
  }

  public void setBcc(String bcc) {
    this.bcc = bcc;
  }

  public SendEmailRequest subject(String subject) {
    this.subject = subject;
    return this;
  }

   /**
   * Email Subject
   * @return subject
  **/
  @ApiModelProperty(example = "null", value = "Email Subject")
  public String getSubject() {
    return subject;
  }

  public void setSubject(String subject) {
    this.subject = subject;
  }

  public SendEmailRequest tag(String tag) {
    this.tag = tag;
    return this;
  }

   /**
   * Email tag that allows you to categorize outgoing emails and get detailed statistics.
   * @return tag
  **/
  @ApiModelProperty(example = "null", value = "Email tag that allows you to categorize outgoing emails and get detailed statistics.")
  public String getTag() {
    return tag;
  }

  public void setTag(String tag) {
    this.tag = tag;
  }

  public SendEmailRequest htmlBody(String htmlBody) {
    this.htmlBody = htmlBody;
    return this;
  }

   /**
   * If no TextBody specified HTML email message
   * @return htmlBody
  **/
  @ApiModelProperty(example = "null", value = "If no TextBody specified HTML email message")
  public String getHtmlBody() {
    return htmlBody;
  }

  public void setHtmlBody(String htmlBody) {
    this.htmlBody = htmlBody;
  }

  public SendEmailRequest textBody(String textBody) {
    this.textBody = textBody;
    return this;
  }

   /**
   * If no HtmlBody specified Plain text email message
   * @return textBody
  **/
  @ApiModelProperty(example = "null", value = "If no HtmlBody specified Plain text email message")
  public String getTextBody() {
    return textBody;
  }

  public void setTextBody(String textBody) {
    this.textBody = textBody;
  }

  public SendEmailRequest replyTo(String replyTo) {
    this.replyTo = replyTo;
    return this;
  }

   /**
   * Reply To override email address. Defaults to the Reply To set in the sender signature.
   * @return replyTo
  **/
  @ApiModelProperty(example = "null", value = "Reply To override email address. Defaults to the Reply To set in the sender signature.")
  public String getReplyTo() {
    return replyTo;
  }

  public void setReplyTo(String replyTo) {
    this.replyTo = replyTo;
  }

  public SendEmailRequest trackOpens(Boolean trackOpens) {
    this.trackOpens = trackOpens;
    return this;
  }

   /**
   * Activate open tracking for this email.
   * @return trackOpens
  **/
  @ApiModelProperty(example = "null", value = "Activate open tracking for this email.")
  public Boolean getTrackOpens() {
    return trackOpens;
  }

  public void setTrackOpens(Boolean trackOpens) {
    this.trackOpens = trackOpens;
  }

  public SendEmailRequest trackLinks(TrackLinksEnum trackLinks) {
    this.trackLinks = trackLinks;
    return this;
  }

   /**
   * Replace links in content to enable \"click tracking\" stats. Default is 'null', which uses the server's LinkTracking setting'.
   * @return trackLinks
  **/
  @ApiModelProperty(example = "null", value = "Replace links in content to enable \"click tracking\" stats. Default is 'null', which uses the server's LinkTracking setting'.")
  public TrackLinksEnum getTrackLinks() {
    return trackLinks;
  }

  public void setTrackLinks(TrackLinksEnum trackLinks) {
    this.trackLinks = trackLinks;
  }

  public SendEmailRequest headers(HeaderCollection headers) {
    this.headers = headers;
    return this;
  }

   /**
   * Get headers
   * @return headers
  **/
  @ApiModelProperty(example = "null", value = "")
  public HeaderCollection getHeaders() {
    return headers;
  }

  public void setHeaders(HeaderCollection headers) {
    this.headers = headers;
  }

  public SendEmailRequest attachments(AttachmentCollection attachments) {
    this.attachments = attachments;
    return this;
  }

   /**
   * Get attachments
   * @return attachments
  **/
  @ApiModelProperty(example = "null", value = "")
  public AttachmentCollection getAttachments() {
    return attachments;
  }

  public void setAttachments(AttachmentCollection attachments) {
    this.attachments = attachments;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SendEmailRequest sendEmailRequest = (SendEmailRequest) o;
    return Objects.equals(this.from, sendEmailRequest.from) &&
        Objects.equals(this.to, sendEmailRequest.to) &&
        Objects.equals(this.cc, sendEmailRequest.cc) &&
        Objects.equals(this.bcc, sendEmailRequest.bcc) &&
        Objects.equals(this.subject, sendEmailRequest.subject) &&
        Objects.equals(this.tag, sendEmailRequest.tag) &&
        Objects.equals(this.htmlBody, sendEmailRequest.htmlBody) &&
        Objects.equals(this.textBody, sendEmailRequest.textBody) &&
        Objects.equals(this.replyTo, sendEmailRequest.replyTo) &&
        Objects.equals(this.trackOpens, sendEmailRequest.trackOpens) &&
        Objects.equals(this.trackLinks, sendEmailRequest.trackLinks) &&
        Objects.equals(this.headers, sendEmailRequest.headers) &&
        Objects.equals(this.attachments, sendEmailRequest.attachments);
  }

  @Override
  public int hashCode() {
    return Objects.hash(from, to, cc, bcc, subject, tag, htmlBody, textBody, replyTo, trackOpens, trackLinks, headers, attachments);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SendEmailRequest {\n");
    
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("    cc: ").append(toIndentedString(cc)).append("\n");
    sb.append("    bcc: ").append(toIndentedString(bcc)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    tag: ").append(toIndentedString(tag)).append("\n");
    sb.append("    htmlBody: ").append(toIndentedString(htmlBody)).append("\n");
    sb.append("    textBody: ").append(toIndentedString(textBody)).append("\n");
    sb.append("    replyTo: ").append(toIndentedString(replyTo)).append("\n");
    sb.append("    trackOpens: ").append(toIndentedString(trackOpens)).append("\n");
    sb.append("    trackLinks: ").append(toIndentedString(trackLinks)).append("\n");
    sb.append("    headers: ").append(toIndentedString(headers)).append("\n");
    sb.append("    attachments: ").append(toIndentedString(attachments)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

