/*
 * Postmark API
 * Postmark makes sending and receiving email incredibly easy. 
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package net.nextpulse.postmarkapp.api.server;

import com.sun.jersey.api.client.GenericType;

import net.nextpulse.postmarkapp.api.ApiException;
import net.nextpulse.postmarkapp.api.ApiClient;
import net.nextpulse.postmarkapp.api.Configuration;
import net.nextpulse.postmarkapp.models.server.*;
import net.nextpulse.postmarkapp.api.Pair;

import net.nextpulse.postmarkapp.models.server.StandardPostmarkResponse;
import net.nextpulse.postmarkapp.models.server.TemplateDetailResponse;
import net.nextpulse.postmarkapp.models.server.TemplateListingResponse;
import java.math.BigDecimal;
import net.nextpulse.postmarkapp.models.server.SendEmailResponse;
import net.nextpulse.postmarkapp.models.server.EmailWithTemplateRequest;
import net.nextpulse.postmarkapp.models.server.TemplateRecordResponse;
import net.nextpulse.postmarkapp.models.server.CreateTemplateRequest;
import net.nextpulse.postmarkapp.models.server.TemplateValidationResponse;
import net.nextpulse.postmarkapp.models.server.TemplateValidationRequest;
import net.nextpulse.postmarkapp.models.server.EditTemplateRequest;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2017-02-24T16:43:29.220+01:00")
public class TemplatesAPIApi {
  private ApiClient apiClient;

  public TemplatesAPIApi() {
    this(Configuration.getDefaultApiClient());
  }

  public TemplatesAPIApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Delete a Template
   * 
   * @param xPostmarkServerToken The token associated with the Server on which this request will operate. (required)
   * @param templateid The ID for the Template you wish to delete. (required)
   * @return TemplateDetailResponse
   * @throws ApiException if fails to make API call
   */
  public TemplateDetailResponse deleteTemplate(String xPostmarkServerToken, Integer templateid) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'xPostmarkServerToken' is set
    if (xPostmarkServerToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling deleteTemplate");
    }
    
    // verify the required parameter 'templateid' is set
    if (templateid == null) {
      throw new ApiException(400, "Missing the required parameter 'templateid' when calling deleteTemplate");
    }
    
    // create path and map variables
    String localVarPath = "/templates/{templateid}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "templateid" + "\\}", apiClient.escapeString(templateid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (xPostmarkServerToken != null)
      localVarHeaderParams.put("X-Postmark-Server-Token", apiClient.parameterToString(xPostmarkServerToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<TemplateDetailResponse> localVarReturnType = new GenericType<TemplateDetailResponse>() {};
    return apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a Template
   * 
   * @param xPostmarkServerToken The token associated with the Server on which this request will operate. (required)
   * @param templateid The ID for the Template you wish to retrieve. (required)
   * @return TemplateDetailResponse
   * @throws ApiException if fails to make API call
   */
  public TemplateDetailResponse getSingleTemplate(String xPostmarkServerToken, Integer templateid) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'xPostmarkServerToken' is set
    if (xPostmarkServerToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling getSingleTemplate");
    }
    
    // verify the required parameter 'templateid' is set
    if (templateid == null) {
      throw new ApiException(400, "Missing the required parameter 'templateid' when calling getSingleTemplate");
    }
    
    // create path and map variables
    String localVarPath = "/templates/{templateid}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "templateid" + "\\}", apiClient.escapeString(templateid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (xPostmarkServerToken != null)
      localVarHeaderParams.put("X-Postmark-Server-Token", apiClient.parameterToString(xPostmarkServerToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<TemplateDetailResponse> localVarReturnType = new GenericType<TemplateDetailResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get the Templates associated with this Server
   * 
   * @param xPostmarkServerToken The token associated with the Server on which this request will operate. (required)
   * @param count The number of Templates to return (required)
   * @param offset The number of Templates to \&quot;skip\&quot; before returning results. (required)
   * @return TemplateListingResponse
   * @throws ApiException if fails to make API call
   */
  public TemplateListingResponse listTemplates(String xPostmarkServerToken, BigDecimal count, BigDecimal offset) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'xPostmarkServerToken' is set
    if (xPostmarkServerToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling listTemplates");
    }
    
    // verify the required parameter 'count' is set
    if (count == null) {
      throw new ApiException(400, "Missing the required parameter 'count' when calling listTemplates");
    }
    
    // verify the required parameter 'offset' is set
    if (offset == null) {
      throw new ApiException(400, "Missing the required parameter 'offset' when calling listTemplates");
    }
    
    // create path and map variables
    String localVarPath = "/templates".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "Count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "Offset", offset));

    if (xPostmarkServerToken != null)
      localVarHeaderParams.put("X-Postmark-Server-Token", apiClient.parameterToString(xPostmarkServerToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<TemplateListingResponse> localVarReturnType = new GenericType<TemplateListingResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Send an email using a Template
   * 
   * @param xPostmarkServerToken The token associated with the Server on which this request will operate. (required)
   * @param body  (required)
   * @return SendEmailResponse
   * @throws ApiException if fails to make API call
   */
  public SendEmailResponse sendEmailWithTemplate(String xPostmarkServerToken, EmailWithTemplateRequest body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'xPostmarkServerToken' is set
    if (xPostmarkServerToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling sendEmailWithTemplate");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling sendEmailWithTemplate");
    }
    
    // create path and map variables
    String localVarPath = "/email/withTemplate".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (xPostmarkServerToken != null)
      localVarHeaderParams.put("X-Postmark-Server-Token", apiClient.parameterToString(xPostmarkServerToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<SendEmailResponse> localVarReturnType = new GenericType<SendEmailResponse>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Create a Template
   * 
   * @param xPostmarkServerToken The token associated with the Server on which this request will operate. (required)
   * @param body  (required)
   * @return TemplateRecordResponse
   * @throws ApiException if fails to make API call
   */
  public TemplateRecordResponse templatesPost(String xPostmarkServerToken, CreateTemplateRequest body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'xPostmarkServerToken' is set
    if (xPostmarkServerToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling templatesPost");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling templatesPost");
    }
    
    // create path and map variables
    String localVarPath = "/templates".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (xPostmarkServerToken != null)
      localVarHeaderParams.put("X-Postmark-Server-Token", apiClient.parameterToString(xPostmarkServerToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<TemplateRecordResponse> localVarReturnType = new GenericType<TemplateRecordResponse>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Test Template Content
   * 
   * @param xPostmarkServerToken The token associated with the Server on which this request will operate. (required)
   * @param body  (optional)
   * @return TemplateValidationResponse
   * @throws ApiException if fails to make API call
   */
  public TemplateValidationResponse testTemplateContent(String xPostmarkServerToken, TemplateValidationRequest body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'xPostmarkServerToken' is set
    if (xPostmarkServerToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling testTemplateContent");
    }
    
    // create path and map variables
    String localVarPath = "/templates/validate".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (xPostmarkServerToken != null)
      localVarHeaderParams.put("X-Postmark-Server-Token", apiClient.parameterToString(xPostmarkServerToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<TemplateValidationResponse> localVarReturnType = new GenericType<TemplateValidationResponse>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Update a Template
   * 
   * @param xPostmarkServerToken The token associated with the Server on which this request will operate. (required)
   * @param templateid The ID for the Template you wish to update. (required)
   * @param body  (required)
   * @return TemplateRecordResponse
   * @throws ApiException if fails to make API call
   */
  public TemplateRecordResponse updateTemplate(String xPostmarkServerToken, Integer templateid, EditTemplateRequest body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'xPostmarkServerToken' is set
    if (xPostmarkServerToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling updateTemplate");
    }
    
    // verify the required parameter 'templateid' is set
    if (templateid == null) {
      throw new ApiException(400, "Missing the required parameter 'templateid' when calling updateTemplate");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling updateTemplate");
    }
    
    // create path and map variables
    String localVarPath = "/templates/{templateid}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "templateid" + "\\}", apiClient.escapeString(templateid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (xPostmarkServerToken != null)
      localVarHeaderParams.put("X-Postmark-Server-Token", apiClient.parameterToString(xPostmarkServerToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<TemplateRecordResponse> localVarReturnType = new GenericType<TemplateRecordResponse>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
