/*
 * Postmark API
 * Postmark makes sending and receiving email incredibly easy. 
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package net.nextpulse.postmarkapp.api.server;

import com.sun.jersey.api.client.GenericType;

import net.nextpulse.postmarkapp.api.ApiException;
import net.nextpulse.postmarkapp.api.ApiClient;
import net.nextpulse.postmarkapp.api.Configuration;
import net.nextpulse.postmarkapp.models.server.*;
import net.nextpulse.postmarkapp.api.Pair;

import net.nextpulse.postmarkapp.models.server.InlineResponse2008Tags;
import net.nextpulse.postmarkapp.models.server.EditTagTriggerRequest;
import net.nextpulse.postmarkapp.models.server.StandardPostmarkResponse;
import net.nextpulse.postmarkapp.models.server.InlineResponse2008;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2017-02-24T16:43:29.220+01:00")
public class TagTriggersAPIApi {
  private ApiClient apiClient;

  public TagTriggersAPIApi() {
    this(Configuration.getDefaultApiClient());
  }

  public TagTriggersAPIApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Create a trigger for a tag
   * 
   * @param xPostmarkServerToken The token associated with the Server on which this request will operate. (required)
   * @param body  (optional)
   * @return InlineResponse2008Tags
   * @throws ApiException if fails to make API call
   */
  public InlineResponse2008Tags createTagTrigger(String xPostmarkServerToken, EditTagTriggerRequest body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'xPostmarkServerToken' is set
    if (xPostmarkServerToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling createTagTrigger");
    }
    
    // create path and map variables
    String localVarPath = "/triggers/tags".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (xPostmarkServerToken != null)
      localVarHeaderParams.put("X-Postmark-Server-Token", apiClient.parameterToString(xPostmarkServerToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<InlineResponse2008Tags> localVarReturnType = new GenericType<InlineResponse2008Tags>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Delete a single trigger
   * 
   * @param xPostmarkServerToken The token associated with the Server on which this request will operate. (required)
   * @param triggerid The ID for the Tag Trigger that should be deleted. (required)
   * @return StandardPostmarkResponse
   * @throws ApiException if fails to make API call
   */
  public StandardPostmarkResponse deleteTagTrigger(String xPostmarkServerToken, Integer triggerid) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'xPostmarkServerToken' is set
    if (xPostmarkServerToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling deleteTagTrigger");
    }
    
    // verify the required parameter 'triggerid' is set
    if (triggerid == null) {
      throw new ApiException(400, "Missing the required parameter 'triggerid' when calling deleteTagTrigger");
    }
    
    // create path and map variables
    String localVarPath = "/triggers/tags/{triggerid}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "triggerid" + "\\}", apiClient.escapeString(triggerid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (xPostmarkServerToken != null)
      localVarHeaderParams.put("X-Postmark-Server-Token", apiClient.parameterToString(xPostmarkServerToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<StandardPostmarkResponse> localVarReturnType = new GenericType<StandardPostmarkResponse>() {};
    return apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Edit a single trigger
   * 
   * @param xPostmarkServerToken The token associated with the Server on which this request will operate. (required)
   * @param triggerid The ID of the Tag Trigger that should be modified by this request. (required)
   * @param body  (optional)
   * @return InlineResponse2008Tags
   * @throws ApiException if fails to make API call
   */
  public InlineResponse2008Tags editTagTrigger(String xPostmarkServerToken, Integer triggerid, EditTagTriggerRequest body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'xPostmarkServerToken' is set
    if (xPostmarkServerToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling editTagTrigger");
    }
    
    // verify the required parameter 'triggerid' is set
    if (triggerid == null) {
      throw new ApiException(400, "Missing the required parameter 'triggerid' when calling editTagTrigger");
    }
    
    // create path and map variables
    String localVarPath = "/triggers/tags/{triggerid}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "triggerid" + "\\}", apiClient.escapeString(triggerid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (xPostmarkServerToken != null)
      localVarHeaderParams.put("X-Postmark-Server-Token", apiClient.parameterToString(xPostmarkServerToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<InlineResponse2008Tags> localVarReturnType = new GenericType<InlineResponse2008Tags>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a single trigger
   * 
   * @param xPostmarkServerToken The token associated with the Server on which this request will operate. (required)
   * @param triggerid The ID for the Tag Trigger for which data should be retrieved. (required)
   * @return InlineResponse2008Tags
   * @throws ApiException if fails to make API call
   */
  public InlineResponse2008Tags getSingleTagTrigger(String xPostmarkServerToken, Integer triggerid) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'xPostmarkServerToken' is set
    if (xPostmarkServerToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling getSingleTagTrigger");
    }
    
    // verify the required parameter 'triggerid' is set
    if (triggerid == null) {
      throw new ApiException(400, "Missing the required parameter 'triggerid' when calling getSingleTagTrigger");
    }
    
    // create path and map variables
    String localVarPath = "/triggers/tags/{triggerid}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "triggerid" + "\\}", apiClient.escapeString(triggerid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (xPostmarkServerToken != null)
      localVarHeaderParams.put("X-Postmark-Server-Token", apiClient.parameterToString(xPostmarkServerToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<InlineResponse2008Tags> localVarReturnType = new GenericType<InlineResponse2008Tags>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Search triggers
   * 
   * @param xPostmarkServerToken The token associated with the Server on which this request will operate. (required)
   * @param count Number of records to return per request. (required)
   * @param offset Number of records to skip. (required)
   * @param matchName Filter by delivery tag (optional)
   * @return InlineResponse2008
   * @throws ApiException if fails to make API call
   */
  public InlineResponse2008 searcgTagTriggers(String xPostmarkServerToken, Integer count, Integer offset, String matchName) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'xPostmarkServerToken' is set
    if (xPostmarkServerToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling searcgTagTriggers");
    }
    
    // verify the required parameter 'count' is set
    if (count == null) {
      throw new ApiException(400, "Missing the required parameter 'count' when calling searcgTagTriggers");
    }
    
    // verify the required parameter 'offset' is set
    if (offset == null) {
      throw new ApiException(400, "Missing the required parameter 'offset' when calling searcgTagTriggers");
    }
    
    // create path and map variables
    String localVarPath = "/triggers/tags".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "match_name", matchName));

    if (xPostmarkServerToken != null)
      localVarHeaderParams.put("X-Postmark-Server-Token", apiClient.parameterToString(xPostmarkServerToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<InlineResponse2008> localVarReturnType = new GenericType<InlineResponse2008>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
