/*
 * Postmark API
 * Postmark makes sending and receiving email incredibly easy. 
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package net.nextpulse.postmarkapp.api.server;

import com.sun.jersey.api.client.GenericType;

import net.nextpulse.postmarkapp.api.ApiException;
import net.nextpulse.postmarkapp.api.ApiClient;
import net.nextpulse.postmarkapp.api.Configuration;
import net.nextpulse.postmarkapp.models.server.*;
import net.nextpulse.postmarkapp.api.Pair;

import net.nextpulse.postmarkapp.models.server.StandardPostmarkResponse;
import net.nextpulse.postmarkapp.models.server.InlineResponse200;
import java.util.Date;
import net.nextpulse.postmarkapp.models.server.DynamicResponse;
import net.nextpulse.postmarkapp.models.server.InlineResponse2001;
import net.nextpulse.postmarkapp.models.server.InlineResponse2002;
import net.nextpulse.postmarkapp.models.server.InlineResponse2003;
import net.nextpulse.postmarkapp.models.server.OutboundOverviewStatsResponse;
import net.nextpulse.postmarkapp.models.server.SentCountsResponse;
import net.nextpulse.postmarkapp.models.server.InlineResponse2004;
import net.nextpulse.postmarkapp.models.server.InlineResponse2005;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2017-02-24T16:43:29.220+01:00")
public class StatsAPIApi {
  private ApiClient apiClient;

  public StatsAPIApi() {
    this(Configuration.getDefaultApiClient());
  }

  public StatsAPIApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get bounce counts
   * 
   * @param xPostmarkServerToken The token associated with the Server on which this request will operate. (required)
   * @param tag Filter by tag (optional)
   * @param fromdate Filter stats starting from the date specified. e.g. &#x60;2014-01-01&#x60; (optional)
   * @param todate Filter stats up to the date specified. e.g. &#x60;2014-02-01&#x60; (optional)
   * @return InlineResponse200
   * @throws ApiException if fails to make API call
   */
  public InlineResponse200 getBounceCounts(String xPostmarkServerToken, String tag, Date fromdate, Date todate) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'xPostmarkServerToken' is set
    if (xPostmarkServerToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling getBounceCounts");
    }
    
    // create path and map variables
    String localVarPath = "/stats/outbound/bounces".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "tag", tag));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "fromdate", fromdate));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "todate", todate));

    if (xPostmarkServerToken != null)
      localVarHeaderParams.put("X-Postmark-Server-Token", apiClient.parameterToString(xPostmarkServerToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<InlineResponse200> localVarReturnType = new GenericType<InlineResponse200>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get click counts
   * 
   * @param xPostmarkServerToken The token associated with the Server on which this request will operate. (required)
   * @param tag Filter by tag (optional)
   * @param fromdate Filter stats starting from the date specified. e.g. &#x60;2014-01-01&#x60; (optional)
   * @param todate Filter stats up to the date specified. e.g. &#x60;2014-02-01&#x60; (optional)
   * @return DynamicResponse
   * @throws ApiException if fails to make API call
   */
  public DynamicResponse getOutboundClickCounts(String xPostmarkServerToken, String tag, Date fromdate, Date todate) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'xPostmarkServerToken' is set
    if (xPostmarkServerToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling getOutboundClickCounts");
    }
    
    // create path and map variables
    String localVarPath = "/stats/outbound/clicks".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "tag", tag));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "fromdate", fromdate));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "todate", todate));

    if (xPostmarkServerToken != null)
      localVarHeaderParams.put("X-Postmark-Server-Token", apiClient.parameterToString(xPostmarkServerToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<DynamicResponse> localVarReturnType = new GenericType<DynamicResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get browser usage by family
   * 
   * @param xPostmarkServerToken The token associated with the Server on which this request will operate. (required)
   * @param tag Filter by tag (optional)
   * @param fromdate Filter stats starting from the date specified. e.g. &#x60;2014-01-01&#x60; (optional)
   * @param todate Filter stats up to the date specified. e.g. &#x60;2014-02-01&#x60; (optional)
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object getOutboundClickCountsByBrowserFamily(String xPostmarkServerToken, String tag, Date fromdate, Date todate) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'xPostmarkServerToken' is set
    if (xPostmarkServerToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling getOutboundClickCountsByBrowserFamily");
    }
    
    // create path and map variables
    String localVarPath = "/stats/outbound/clicks/browserfamilies".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "tag", tag));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "fromdate", fromdate));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "todate", todate));

    if (xPostmarkServerToken != null)
      localVarHeaderParams.put("X-Postmark-Server-Token", apiClient.parameterToString(xPostmarkServerToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<Object> localVarReturnType = new GenericType<Object>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get clicks by body location
   * 
   * @param xPostmarkServerToken The token associated with the Server on which this request will operate. (required)
   * @param tag Filter by tag (optional)
   * @param fromdate Filter stats starting from the date specified. e.g. &#x60;2014-01-01&#x60; (optional)
   * @param todate Filter stats up to the date specified. e.g. &#x60;2014-02-01&#x60; (optional)
   * @return DynamicResponse
   * @throws ApiException if fails to make API call
   */
  public DynamicResponse getOutboundClickCountsByLocation(String xPostmarkServerToken, String tag, Date fromdate, Date todate) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'xPostmarkServerToken' is set
    if (xPostmarkServerToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling getOutboundClickCountsByLocation");
    }
    
    // create path and map variables
    String localVarPath = "/stats/outbound/clicks/location".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "tag", tag));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "fromdate", fromdate));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "todate", todate));

    if (xPostmarkServerToken != null)
      localVarHeaderParams.put("X-Postmark-Server-Token", apiClient.parameterToString(xPostmarkServerToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<DynamicResponse> localVarReturnType = new GenericType<DynamicResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get browser plaform usage
   * 
   * @param xPostmarkServerToken The token associated with the Server on which this request will operate. (required)
   * @param tag Filter by tag (optional)
   * @param fromdate Filter stats starting from the date specified. e.g. &#x60;2014-01-01&#x60; (optional)
   * @param todate Filter stats up to the date specified. e.g. &#x60;2014-02-01&#x60; (optional)
   * @return DynamicResponse
   * @throws ApiException if fails to make API call
   */
  public DynamicResponse getOutboundClickCountsByPlatform(String xPostmarkServerToken, String tag, Date fromdate, Date todate) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'xPostmarkServerToken' is set
    if (xPostmarkServerToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling getOutboundClickCountsByPlatform");
    }
    
    // create path and map variables
    String localVarPath = "/stats/outbound/clicks/platforms".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "tag", tag));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "fromdate", fromdate));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "todate", todate));

    if (xPostmarkServerToken != null)
      localVarHeaderParams.put("X-Postmark-Server-Token", apiClient.parameterToString(xPostmarkServerToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<DynamicResponse> localVarReturnType = new GenericType<DynamicResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get email open counts
   * 
   * @param xPostmarkServerToken The token associated with the Server on which this request will operate. (required)
   * @param tag Filter by tag (optional)
   * @param fromdate Filter stats starting from the date specified. e.g. &#x60;2014-01-01&#x60; (optional)
   * @param todate Filter stats up to the date specified. e.g. &#x60;2014-02-01&#x60; (optional)
   * @return InlineResponse2001
   * @throws ApiException if fails to make API call
   */
  public InlineResponse2001 getOutboundOpenCounts(String xPostmarkServerToken, String tag, Date fromdate, Date todate) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'xPostmarkServerToken' is set
    if (xPostmarkServerToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling getOutboundOpenCounts");
    }
    
    // create path and map variables
    String localVarPath = "/stats/outbound/opens".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "tag", tag));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "fromdate", fromdate));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "todate", todate));

    if (xPostmarkServerToken != null)
      localVarHeaderParams.put("X-Postmark-Server-Token", apiClient.parameterToString(xPostmarkServerToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<InlineResponse2001> localVarReturnType = new GenericType<InlineResponse2001>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get email client usage
   * 
   * @param xPostmarkServerToken The token associated with the Server on which this request will operate. (required)
   * @param tag Filter by tag (optional)
   * @param fromdate Filter stats starting from the date specified. e.g. &#x60;2014-01-01&#x60; (optional)
   * @param todate Filter stats up to the date specified. e.g. &#x60;2014-02-01&#x60; (optional)
   * @return InlineResponse2002
   * @throws ApiException if fails to make API call
   */
  public InlineResponse2002 getOutboundOpenCountsByEmailClient(String xPostmarkServerToken, String tag, Date fromdate, Date todate) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'xPostmarkServerToken' is set
    if (xPostmarkServerToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling getOutboundOpenCountsByEmailClient");
    }
    
    // create path and map variables
    String localVarPath = "/stats/outbound/opens/emailclients".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "tag", tag));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "fromdate", fromdate));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "todate", todate));

    if (xPostmarkServerToken != null)
      localVarHeaderParams.put("X-Postmark-Server-Token", apiClient.parameterToString(xPostmarkServerToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<InlineResponse2002> localVarReturnType = new GenericType<InlineResponse2002>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get email platform usage
   * 
   * @param xPostmarkServerToken The token associated with the Server on which this request will operate. (required)
   * @param tag Filter by tag (optional)
   * @param fromdate Filter stats starting from the date specified. e.g. &#x60;2014-01-01&#x60; (optional)
   * @param todate Filter stats up to the date specified. e.g. &#x60;2014-02-01&#x60; (optional)
   * @return InlineResponse2003
   * @throws ApiException if fails to make API call
   */
  public InlineResponse2003 getOutboundOpenCountsByPlatform(String xPostmarkServerToken, String tag, Date fromdate, Date todate) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'xPostmarkServerToken' is set
    if (xPostmarkServerToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling getOutboundOpenCountsByPlatform");
    }
    
    // create path and map variables
    String localVarPath = "/stats/outbound/opens/platforms".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "tag", tag));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "fromdate", fromdate));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "todate", todate));

    if (xPostmarkServerToken != null)
      localVarHeaderParams.put("X-Postmark-Server-Token", apiClient.parameterToString(xPostmarkServerToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<InlineResponse2003> localVarReturnType = new GenericType<InlineResponse2003>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get email read times
   * 
   * @param xPostmarkServerToken The token associated with the Server on which this request will operate. (required)
   * @param tag Filter by tag (optional)
   * @param fromdate Filter stats starting from the date specified. e.g. &#x60;2014-01-01&#x60; (optional)
   * @param todate Filter stats up to the date specified. e.g. &#x60;2014-02-01&#x60; (optional)
   * @return DynamicResponse
   * @throws ApiException if fails to make API call
   */
  public DynamicResponse getOutboundOpenCountsByReadingTime(String xPostmarkServerToken, String tag, Date fromdate, Date todate) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'xPostmarkServerToken' is set
    if (xPostmarkServerToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling getOutboundOpenCountsByReadingTime");
    }
    
    // create path and map variables
    String localVarPath = "/stats/outbound/opens/readtimes".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "tag", tag));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "fromdate", fromdate));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "todate", todate));

    if (xPostmarkServerToken != null)
      localVarHeaderParams.put("X-Postmark-Server-Token", apiClient.parameterToString(xPostmarkServerToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<DynamicResponse> localVarReturnType = new GenericType<DynamicResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get outbound overview
   * 
   * @param xPostmarkServerToken The token associated with the Server on which this request will operate. (required)
   * @param tag Filter by tag (optional)
   * @param fromdate Filter stats starting from the date specified. e.g. &#x60;2014-01-01&#x60; (optional)
   * @param todate Filter stats up to the date specified. e.g. &#x60;2014-02-01&#x60; (optional)
   * @return OutboundOverviewStatsResponse
   * @throws ApiException if fails to make API call
   */
  public OutboundOverviewStatsResponse getOutboundOverviewStatistics(String xPostmarkServerToken, String tag, Date fromdate, Date todate) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'xPostmarkServerToken' is set
    if (xPostmarkServerToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling getOutboundOverviewStatistics");
    }
    
    // create path and map variables
    String localVarPath = "/stats/outbound".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "tag", tag));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "fromdate", fromdate));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "todate", todate));

    if (xPostmarkServerToken != null)
      localVarHeaderParams.put("X-Postmark-Server-Token", apiClient.parameterToString(xPostmarkServerToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<OutboundOverviewStatsResponse> localVarReturnType = new GenericType<OutboundOverviewStatsResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get sent counts
   * 
   * @param xPostmarkServerToken The token associated with the Server on which this request will operate. (required)
   * @param tag Filter by tag (optional)
   * @param fromdate Filter stats starting from the date specified. e.g. &#x60;2014-01-01&#x60; (optional)
   * @param todate Filter stats up to the date specified. e.g. &#x60;2014-02-01&#x60; (optional)
   * @return SentCountsResponse
   * @throws ApiException if fails to make API call
   */
  public SentCountsResponse getSentCounts(String xPostmarkServerToken, String tag, Date fromdate, Date todate) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'xPostmarkServerToken' is set
    if (xPostmarkServerToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling getSentCounts");
    }
    
    // create path and map variables
    String localVarPath = "/stats/outbound/sends".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "tag", tag));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "fromdate", fromdate));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "todate", todate));

    if (xPostmarkServerToken != null)
      localVarHeaderParams.put("X-Postmark-Server-Token", apiClient.parameterToString(xPostmarkServerToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<SentCountsResponse> localVarReturnType = new GenericType<SentCountsResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get spam complaints
   * 
   * @param xPostmarkServerToken The token associated with the Server on which this request will operate. (required)
   * @param tag Filter by tag (optional)
   * @param fromdate Filter stats starting from the date specified. e.g. &#x60;2014-01-01&#x60; (optional)
   * @param todate Filter stats up to the date specified. e.g. &#x60;2014-02-01&#x60; (optional)
   * @return InlineResponse2004
   * @throws ApiException if fails to make API call
   */
  public InlineResponse2004 getSpamComplaints(String xPostmarkServerToken, String tag, Date fromdate, Date todate) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'xPostmarkServerToken' is set
    if (xPostmarkServerToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling getSpamComplaints");
    }
    
    // create path and map variables
    String localVarPath = "/stats/outbound/spam".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "tag", tag));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "fromdate", fromdate));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "todate", todate));

    if (xPostmarkServerToken != null)
      localVarHeaderParams.put("X-Postmark-Server-Token", apiClient.parameterToString(xPostmarkServerToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<InlineResponse2004> localVarReturnType = new GenericType<InlineResponse2004>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get tracked email counts
   * 
   * @param xPostmarkServerToken The token associated with the Server on which this request will operate. (required)
   * @param tag Filter by tag (optional)
   * @param fromdate Filter stats starting from the date specified. e.g. &#x60;2014-01-01&#x60; (optional)
   * @param todate Filter stats starting from the date specified. e.g. &#x60;2014-01-01&#x60; (optional)
   * @return InlineResponse2005
   * @throws ApiException if fails to make API call
   */
  public InlineResponse2005 getTrackedEmailCounts(String xPostmarkServerToken, String tag, Date fromdate, Date todate) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'xPostmarkServerToken' is set
    if (xPostmarkServerToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkServerToken' when calling getTrackedEmailCounts");
    }
    
    // create path and map variables
    String localVarPath = "/stats/outbound/tracked".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "tag", tag));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "fromdate", fromdate));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "todate", todate));

    if (xPostmarkServerToken != null)
      localVarHeaderParams.put("X-Postmark-Server-Token", apiClient.parameterToString(xPostmarkServerToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<InlineResponse2005> localVarReturnType = new GenericType<InlineResponse2005>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
