/*
 * Postmark Account-level API
 * Postmark makes sending and receiving email  incredibly easy. The Account-level API allows users to configure all Servers, Domains, and Sender Signatures associated  with an Account. 
 *
 * OpenAPI spec version: 0.9.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package net.nextpulse.postmarkapp.api.account;

import com.sun.jersey.api.client.GenericType;

import net.nextpulse.postmarkapp.api.ApiException;
import net.nextpulse.postmarkapp.api.ApiClient;
import net.nextpulse.postmarkapp.api.Configuration;
import net.nextpulse.postmarkapp.models.account.*;
import net.nextpulse.postmarkapp.api.Pair;

import net.nextpulse.postmarkapp.models.account.ExtendedServerInfo;
import net.nextpulse.postmarkapp.models.account.StandardPostmarkResponse;
import net.nextpulse.postmarkapp.models.account.CreateServerPayload;
import net.nextpulse.postmarkapp.models.account.EditServerPayload;
import net.nextpulse.postmarkapp.models.account.ServerListingResponse;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "class io.swagger.codegen.languages.JavaClientCodegen", date = "2017-02-24T16:43:30.269+01:00")
public class ServerManagementAPIApi {
  private ApiClient apiClient;

  public ServerManagementAPIApi() {
    this(Configuration.getDefaultApiClient());
  }

  public ServerManagementAPIApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Create a Server
   * 
   * @param xPostmarkAccountToken The token associated with the Account on which this request will operate. (required)
   * @param body  (optional)
   * @return ExtendedServerInfo
   * @throws ApiException if fails to make API call
   */
  public ExtendedServerInfo createServer(String xPostmarkAccountToken, CreateServerPayload body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'xPostmarkAccountToken' is set
    if (xPostmarkAccountToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkAccountToken' when calling createServer");
    }
    
    // create path and map variables
    String localVarPath = "/servers".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (xPostmarkAccountToken != null)
      localVarHeaderParams.put("X-Postmark-Account-Token", apiClient.parameterToString(xPostmarkAccountToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<ExtendedServerInfo> localVarReturnType = new GenericType<ExtendedServerInfo>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Delete a Server
   * 
   * @param xPostmarkAccountToken The token associated with the Account on which this request will operate. (required)
   * @param serverid The ID of the Server that should be deleted. (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteServer(String xPostmarkAccountToken, Integer serverid) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'xPostmarkAccountToken' is set
    if (xPostmarkAccountToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkAccountToken' when calling deleteServer");
    }
    
    // verify the required parameter 'serverid' is set
    if (serverid == null) {
      throw new ApiException(400, "Missing the required parameter 'serverid' when calling deleteServer");
    }
    
    // create path and map variables
    String localVarPath = "/servers/{serverid}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "serverid" + "\\}", apiClient.escapeString(serverid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (xPostmarkAccountToken != null)
      localVarHeaderParams.put("X-Postmark-Account-Token", apiClient.parameterToString(xPostmarkAccountToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };


    apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
  }
  /**
   * Edit a Server
   * 
   * @param xPostmarkAccountToken The token associated with the Account on which this request will operate. (required)
   * @param serverid The ID of the Server to update. (required)
   * @param body  (optional)
   * @return ExtendedServerInfo
   * @throws ApiException if fails to make API call
   */
  public ExtendedServerInfo editServerInformation(String xPostmarkAccountToken, Integer serverid, EditServerPayload body) throws ApiException {
    Object localVarPostBody = body;
    
    // verify the required parameter 'xPostmarkAccountToken' is set
    if (xPostmarkAccountToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkAccountToken' when calling editServerInformation");
    }
    
    // verify the required parameter 'serverid' is set
    if (serverid == null) {
      throw new ApiException(400, "Missing the required parameter 'serverid' when calling editServerInformation");
    }
    
    // create path and map variables
    String localVarPath = "/servers/{serverid}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "serverid" + "\\}", apiClient.escapeString(serverid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (xPostmarkAccountToken != null)
      localVarHeaderParams.put("X-Postmark-Account-Token", apiClient.parameterToString(xPostmarkAccountToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<ExtendedServerInfo> localVarReturnType = new GenericType<ExtendedServerInfo>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get a Server
   * 
   * @param xPostmarkAccountToken The token associated with the Account on which this request will operate. (required)
   * @param serverid The ID of the Server to get. (required)
   * @return ExtendedServerInfo
   * @throws ApiException if fails to make API call
   */
  public ExtendedServerInfo getServerInformation(String xPostmarkAccountToken, Integer serverid) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'xPostmarkAccountToken' is set
    if (xPostmarkAccountToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkAccountToken' when calling getServerInformation");
    }
    
    // verify the required parameter 'serverid' is set
    if (serverid == null) {
      throw new ApiException(400, "Missing the required parameter 'serverid' when calling getServerInformation");
    }
    
    // create path and map variables
    String localVarPath = "/servers/{serverid}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "serverid" + "\\}", apiClient.escapeString(serverid.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (xPostmarkAccountToken != null)
      localVarHeaderParams.put("X-Postmark-Account-Token", apiClient.parameterToString(xPostmarkAccountToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<ExtendedServerInfo> localVarReturnType = new GenericType<ExtendedServerInfo>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * List servers
   * 
   * @param xPostmarkAccountToken The token associated with the Account on which this request will operate. (required)
   * @param count Number of servers to return per request. (required)
   * @param offset Number of servers to skip. (required)
   * @param name Filter by a specific server name (optional)
   * @return ServerListingResponse
   * @throws ApiException if fails to make API call
   */
  public ServerListingResponse listServers(String xPostmarkAccountToken, Integer count, Integer offset, String name) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'xPostmarkAccountToken' is set
    if (xPostmarkAccountToken == null) {
      throw new ApiException(400, "Missing the required parameter 'xPostmarkAccountToken' when calling listServers");
    }
    
    // verify the required parameter 'count' is set
    if (count == null) {
      throw new ApiException(400, "Missing the required parameter 'count' when calling listServers");
    }
    
    // verify the required parameter 'offset' is set
    if (offset == null) {
      throw new ApiException(400, "Missing the required parameter 'offset' when calling listServers");
    }
    
    // create path and map variables
    String localVarPath = "/servers".replaceAll("\\{format\\}","json");

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "count", count));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "name", name));

    if (xPostmarkAccountToken != null)
      localVarHeaderParams.put("X-Postmark-Account-Token", apiClient.parameterToString(xPostmarkAccountToken));

    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<ServerListingResponse> localVarReturnType = new GenericType<ServerListingResponse>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
