/*
 * Decompiled with CFR 0.152.
 */
package net.nextpulse.jfactuursturen.util;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\b"}, d2={"Lnet/nextpulse/jfactuursturen/util/LoggingInterceptor;", "Lokhttp3/Interceptor;", "()V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "Companion", "jfactuursturen"})
public final class LoggingInterceptor
implements Interceptor {
    private static final Logger logger;
    public static final Companion Companion;

    @NotNull
    public Response intercept(@Nullable Interceptor.Chain chain) {
        if (chain == null) {
            throw (Throwable)new IllegalArgumentException("Received null chain parameter");
        }
        Request request = chain.request();
        long t1 = System.nanoTime();
        logger.debug("Sending {} request to {}", (Object)request.method(), (Object)request.url());
        Response response = chain.proceed(request);
        long t2 = System.nanoTime();
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "Received response for %s in %.1fms%n";
        Object[] objectArray = new Object[]{response.request().url(), (double)(t2 - t1) / 1000000.0};
        Logger logger = LoggingInterceptor.logger;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        String string3 = string2;
        logger.debug(string3);
        Response response2 = response;
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        return response2;
    }

    static {
        Companion = new Companion(null);
        Logger logger = LogManager.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger()");
        LoggingInterceptor.logger = logger;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/nextpulse/jfactuursturen/util/LoggingInterceptor$Companion;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "jfactuursturen"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

