/*
 * Decompiled with CFR 0.152.
 */
package net.nextpulse.jfactuursturen.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.io.Closeable;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.nextpulse.jfactuursturen.FactuurSturenClient;
import net.nextpulse.jfactuursturen.exceptions.ApiException;
import net.nextpulse.jfactuursturen.exceptions.ExceptionUtils;
import net.nextpulse.jfactuursturen.util.LoggingInterceptor;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\b\u0016\u0018\u0000 +2\u00020\u0001:\u0001+B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0001H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001eJ\u001a\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0003J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001eJ\"\u0010!\u001a\u0002H\"\"\n\b\u0000\u0010\"\u0018\u0001*\u00020\u00012\u0006\u0010#\u001a\u00020\u0003H\u0086\b\u00a2\u0006\u0002\u0010$J\u0016\u0010%\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010%\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020\u0012H\u0002J\u0010\u0010(\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0012H\u0002J\u0016\u0010)\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0001J\u0016\u0010*\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0001R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006,"}, d2={"Lnet/nextpulse/jfactuursturen/util/BasicAuthApiClient;", "", "username", "", "apiKey", "apiHost", "apiPath", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "JSON", "Lokhttp3/MediaType;", "getJSON", "()Lokhttp3/MediaType;", "getApiHost", "()Ljava/lang/String;", "getApiKey", "getApiPath", "getUsername", "buildDeleteRequest", "Lokhttp3/Request;", "url", "Lokhttp3/HttpUrl;", "buildGetRequest", "buildPostRequest", "body", "createRequestBuilder", "Lokhttp3/Request$Builder;", "createUrlBuilder", "Lokhttp3/HttpUrl$Builder;", "path", "id", "", "deleteRequest", "", "deserialize", "T", "responseBody", "(Ljava/lang/String;)Ljava/lang/Object;", "getRequest", "performEmptyResponseRequest", "request", "performJsonResponseRequest", "postRequest", "putRequest", "Companion", "jfactuursturen"})
public class BasicAuthApiClient {
    @Nullable
    private final MediaType JSON;
    @NotNull
    private final String username;
    @NotNull
    private final String apiKey;
    @NotNull
    private final String apiHost;
    @NotNull
    private final String apiPath;
    @NotNull
    private static final ObjectMapper mapper;
    @JvmField
    @NotNull
    public static OkHttpClient httpClient;
    public static final Companion Companion;

    @Nullable
    public final MediaType getJSON() {
        return this.JSON;
    }

    private final <T> T deserialize(String responseBody) {
        try {
            ObjectMapper $receiver$iv = Companion.getMapper();
            String string = responseBody;
            ObjectMapper objectMapper = $receiver$iv;
            Intrinsics.needClassReification();
            TypeReference typeReference = new TypeReference<T>(){};
            return (T)objectMapper.readValue(string, typeReference);
        }
        catch (JsonProcessingException e) {
            FactuurSturenClient.Companion.getLogger().error("Could not process the API response: {}", (Object)responseBody, (Object)e);
            throw (Throwable)new ApiException("Could not process the API response", (IOException)((Object)e));
        }
    }

    @NotNull
    public final HttpUrl.Builder createUrlBuilder(@NotNull String path, long id) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return this.createUrlBuilder(path, String.valueOf(id));
    }

    @NotNull
    public final HttpUrl.Builder createUrlBuilder(@NotNull String path, @Nullable String id) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        HttpUrl.Builder builder = new HttpUrl.Builder().scheme("https").host(this.apiHost).addPathSegments(this.apiPath).addPathSegments(path);
        if (id != null) {
            builder.addPathSegment(id);
        }
        HttpUrl.Builder builder2 = builder;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"builder");
        return builder2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ HttpUrl.Builder createUrlBuilder$default(BasicAuthApiClient basicAuthApiClient, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createUrlBuilder");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return basicAuthApiClient.createUrlBuilder(string, string2);
    }

    @NotNull
    public final String getRequest(@NotNull String path, long id) {
        HttpUrl url;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        HttpUrl httpUrl = url = this.createUrlBuilder(path, id).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"url");
        return this.getRequest(httpUrl);
    }

    @NotNull
    public final String getRequest(@NotNull HttpUrl url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Request request = this.buildGetRequest(url);
        return this.performJsonResponseRequest(request);
    }

    @NotNull
    public final String postRequest(@NotNull String path, @NotNull Object body) {
        HttpUrl url;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        HttpUrl httpUrl = url = BasicAuthApiClient.createUrlBuilder$default(this, path, null, 2, null).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"url");
        Request request = this.buildPostRequest(httpUrl, body);
        return this.performJsonResponseRequest(request);
    }

    public final void putRequest(@NotNull HttpUrl url, @NotNull Object body) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Request request = this.buildPostRequest(url, body);
        this.performEmptyResponseRequest(request);
    }

    public final void deleteRequest(@NotNull String path, long id) {
        HttpUrl url;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        HttpUrl httpUrl = url = this.createUrlBuilder(path, id).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"url");
        Request request = this.buildDeleteRequest(httpUrl);
        this.performEmptyResponseRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String performJsonResponseRequest(Request request) {
        try {
            Closeable closeable = (Closeable)httpClient.newCall(request).execute();
            Throwable throwable = null;
            try {
                Response it = (Response)closeable;
                ResponseBody responseBody = it.body();
                Response response = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"it");
                if (response.isSuccessful() && responseBody != null) {
                    String string = responseBody.string();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"responseBody.string()");
                    String string2 = string;
                    return string2;
                }
                try {
                    throw (Throwable)ExceptionUtils.responseCodeToException(it.code());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw (Throwable)new ApiException("Received IO exception while trying to reach the FactuurSturen API", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void performEmptyResponseRequest(Request request) {
        try {
            Closeable closeable = (Closeable)httpClient.newCall(request).execute();
            Throwable throwable = null;
            try {
                Response it;
                Response response = it = (Response)closeable;
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"it");
                if (response.isSuccessful()) {
                    return;
                }
                try {
                    throw (Throwable)ExceptionUtils.responseCodeToException(it.code());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw (Throwable)new ApiException("Received IO exception while trying to reach the FactuurSturen API", e);
        }
    }

    private final Request buildGetRequest(HttpUrl url) {
        Request request = this.createRequestBuilder(url).get().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"createRequestBuilder(url).get().build()");
        return request;
    }

    private final Request buildPostRequest(HttpUrl url, Object body) {
        RequestBody requestBody = RequestBody.create((MediaType)this.JSON, (String)mapper.writeValueAsString(body));
        Request request = this.createRequestBuilder(url).header("Content-Type", "application/json").post(requestBody).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"createRequestBuilder(url\u2026\n                .build()");
        return request;
    }

    private final Request buildDeleteRequest(HttpUrl url) {
        Request request = this.createRequestBuilder(url).delete().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"createRequestBuilder(url).delete().build()");
        return request;
    }

    private final Request.Builder createRequestBuilder(HttpUrl url) {
        Request.Builder builder = new Request.Builder().url(url).header("Authorization", Credentials.basic((String)this.username, (String)this.apiKey)).header("Accept", "application/json");
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"Request.Builder().url(ur\u2026ept\", \"application/json\")");
        return builder;
    }

    @NotNull
    public final String getUsername() {
        return this.username;
    }

    @NotNull
    public final String getApiKey() {
        return this.apiKey;
    }

    @NotNull
    public final String getApiHost() {
        return this.apiHost;
    }

    @NotNull
    public final String getApiPath() {
        return this.apiPath;
    }

    public BasicAuthApiClient(@NotNull String username, @NotNull String apiKey, @NotNull String apiHost, @NotNull String apiPath) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
        Intrinsics.checkParameterIsNotNull((Object)apiHost, (String)"apiHost");
        Intrinsics.checkParameterIsNotNull((Object)apiPath, (String)"apiPath");
        this.username = username;
        this.apiKey = apiKey;
        this.apiHost = apiHost;
        this.apiPath = apiPath;
        this.JSON = MediaType.parse((String)"application/json; charset=utf-8");
    }

    static {
        Companion = new Companion(null);
        ObjectMapper objectMapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper()).registerModule((Module)new JodaModule()).setPropertyNamingStrategy(PropertyNamingStrategy.LOWER_CASE).configure(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectMapper, (String)"ObjectMapper().registerK\u2026RAY_AS_NULL_OBJECT, true)");
        mapper = objectMapper;
        OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new LoggingInterceptor()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient, (String)"OkHttpClient.Builder()\n \u2026\n                .build()");
        httpClient = okHttpClient;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lnet/nextpulse/jfactuursturen/util/BasicAuthApiClient$Companion;", "", "()V", "httpClient", "Lokhttp3/OkHttpClient;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "jfactuursturen"})
    public static final class Companion {
        @NotNull
        public final ObjectMapper getMapper() {
            return mapper;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

