/*
 * Decompiled with CFR 0.152.
 */
package net.nextpulse.jfactuursturen.exceptions;

import kotlin.Metadata;
import kotlin.jvm.JvmName;
import net.nextpulse.jfactuursturen.exceptions.ApiException;
import net.nextpulse.jfactuursturen.exceptions.AuthenticationFailedException;
import net.nextpulse.jfactuursturen.exceptions.NotFoundException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"responseCodeToException", "Lnet/nextpulse/jfactuursturen/exceptions/ApiException;", "responseCode", "", "jfactuursturen"})
@JvmName(name="ExceptionUtils")
public final class ExceptionUtils {
    @NotNull
    public static final ApiException responseCodeToException(int responseCode) {
        ApiException apiException;
        switch (responseCode) {
            case 404: {
                apiException = new NotFoundException("Requested object could not be found");
                break;
            }
            case 401: {
                apiException = new AuthenticationFailedException("Authentication failed");
                break;
            }
            default: {
                apiException = new ApiException("Received failure response from the API, HTTP code " + responseCode, null, 2, null);
            }
        }
        return apiException;
    }
}

