/*
 * Decompiled with CFR 0.152.
 */
package net.nextpulse.jfactuursturen;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.nextpulse.jfactuursturen.exceptions.ApiException;
import net.nextpulse.jfactuursturen.models.Invoice;
import net.nextpulse.jfactuursturen.models.InvoiceFilter;
import net.nextpulse.jfactuursturen.models.NewInvoice;
import net.nextpulse.jfactuursturen.util.BasicAuthApiClient;
import okhttp3.HttpUrl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0003H\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rJ,\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00072\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0007H\u0007\u00a8\u0006\u001a"}, d2={"Lnet/nextpulse/jfactuursturen/FactuurSturenClient;", "Lnet/nextpulse/jfactuursturen/util/BasicAuthApiClient;", "username", "", "apiKey", "(Ljava/lang/String;Ljava/lang/String;)V", "createInvoice", "", "invoice", "Lnet/nextpulse/jfactuursturen/models/NewInvoice;", "deleteInvoice", "", "invoiceId", "", "getCountryList", "", "language", "getInvoice", "Lnet/nextpulse/jfactuursturen/models/Invoice;", "getInvoices", "", "count", "filter", "Lnet/nextpulse/jfactuursturen/models/InvoiceFilter;", "offset", "Companion", "jfactuursturen"})
public class FactuurSturenClient
extends BasicAuthApiClient {
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String API_HOST = "www.factuursturen.nl";
    @NotNull
    private static final String API_PATH = "api/v1";
    @NotNull
    private static final DateTimeFormatter FILTER_TIME_FORMAT;
    public static final Companion Companion;

    @JvmOverloads
    @NotNull
    public final List<Invoice> getInvoices(int count, @NotNull InvoiceFilter filter, int offset) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
        HttpUrl.Builder urlBuilder = BasicAuthApiClient.createUrlBuilder$default(this, "invoices", null, 2, null);
        if (filter.getFilter() != null) {
            urlBuilder.addQueryParameter("filter", String.valueOf((Object)filter.getFilter()));
        }
        if (filter.getSince() != null) {
            urlBuilder.addQueryParameter("since", FILTER_TIME_FORMAT.print((ReadableInstant)filter.getSince()));
        }
        if (filter.getUntil() != null) {
            urlBuilder.addQueryParameter("until", FILTER_TIME_FORMAT.print((ReadableInstant)filter.getUntil()));
        }
        urlBuilder.addQueryParameter("count", String.valueOf(count));
        urlBuilder.addQueryParameter("offset", String.valueOf(offset));
        FactuurSturenClient factuurSturenClient = this;
        HttpUrl httpUrl = urlBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"urlBuilder.build()");
        String responseBody$iv = this.getRequest(httpUrl);
        try {
            ObjectMapper $receiver$iv$iv = BasicAuthApiClient.Companion.getMapper();
            String string = responseBody$iv;
            ObjectMapper objectMapper = $receiver$iv$iv;
            TypeReference typeReference = (TypeReference)new TypeReference<List<? extends Invoice>>(){};
            object = objectMapper.readValue(string, typeReference);
        }
        catch (JsonProcessingException e$iv) {
            Companion.getLogger().error("Could not process the API response: {}", (Object)responseBody$iv, (Object)e$iv);
            throw (Throwable)new ApiException("Could not process the API response", (IOException)((Object)e$iv));
        }
        return (List)object;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ List getInvoices$default(FactuurSturenClient factuurSturenClient, int n, InvoiceFilter invoiceFilter, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getInvoices");
        }
        if ((n3 & 1) != 0) {
            n = 20;
        }
        if ((n3 & 2) != 0) {
            invoiceFilter = new InvoiceFilter(null, null, null, 7, null);
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        return factuurSturenClient.getInvoices(n, invoiceFilter, n2);
    }

    @JvmOverloads
    @NotNull
    public final List<Invoice> getInvoices(int count, @NotNull InvoiceFilter filter) {
        return FactuurSturenClient.getInvoices$default(this, count, filter, 0, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final List<Invoice> getInvoices(int count) {
        return FactuurSturenClient.getInvoices$default(this, count, null, 0, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final List<Invoice> getInvoices() {
        return FactuurSturenClient.getInvoices$default(this, 0, null, 0, 7, null);
    }

    @NotNull
    public final Invoice getInvoice(long invoiceId) {
        Object object;
        FactuurSturenClient factuurSturenClient = this;
        String responseBody$iv = this.getRequest("invoices", invoiceId);
        try {
            ObjectMapper $receiver$iv$iv = BasicAuthApiClient.Companion.getMapper();
            String string = responseBody$iv;
            ObjectMapper objectMapper = $receiver$iv$iv;
            TypeReference typeReference = (TypeReference)new TypeReference<Invoice>(){};
            object = objectMapper.readValue(string, typeReference);
        }
        catch (JsonProcessingException e$iv) {
            Companion.getLogger().error("Could not process the API response: {}", (Object)responseBody$iv, (Object)e$iv);
            throw (Throwable)new ApiException("Could not process the API response", (IOException)((Object)e$iv));
        }
        return (Invoice)object;
    }

    public final int createInvoice(@NotNull NewInvoice invoice) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)invoice, (String)"invoice");
        FactuurSturenClient factuurSturenClient = this;
        String responseBody$iv = this.postRequest("invoices", invoice);
        try {
            ObjectMapper $receiver$iv$iv = BasicAuthApiClient.Companion.getMapper();
            String string = responseBody$iv;
            ObjectMapper objectMapper = $receiver$iv$iv;
            TypeReference typeReference = (TypeReference)new TypeReference<Integer>(){};
            object = objectMapper.readValue(string, typeReference);
        }
        catch (JsonProcessingException e$iv) {
            Companion.getLogger().error("Could not process the API response: {}", (Object)responseBody$iv, (Object)e$iv);
            throw (Throwable)new ApiException("Could not process the API response", (IOException)((Object)e$iv));
        }
        return ((Number)object).intValue();
    }

    public final void deleteInvoice(long invoiceId) {
        this.deleteRequest("invoices", invoiceId);
    }

    @JvmOverloads
    @NotNull
    public final Map<String, String> getCountryList(@NotNull String language) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        if (Intrinsics.areEqual((Object)language, (Object)"nl")) {
            HashMap<String, String> countries = new HashMap<String, String>();
            countries.put("146", "Nederland");
            countries.put("226", "Verenigde Staten");
            return countries;
        }
        throw (Throwable)new IllegalArgumentException("Not yet implemented");
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ Map getCountryList$default(FactuurSturenClient factuurSturenClient, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getCountryList");
        }
        if ((n & 1) != 0) {
            string = "nl";
        }
        return factuurSturenClient.getCountryList(string);
    }

    @JvmOverloads
    @NotNull
    public final Map<String, String> getCountryList() {
        return FactuurSturenClient.getCountryList$default(this, null, 1, null);
    }

    public FactuurSturenClient(@NotNull String username, @NotNull String apiKey) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
        super(username, apiKey, API_HOST, API_PATH);
    }

    static {
        Companion = new Companion(null);
        Logger logger = LogManager.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger()");
        FactuurSturenClient.logger = logger;
        API_HOST = API_HOST;
        API_PATH = API_PATH;
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTimeFormatter, (String)"DateTimeFormat.forPattern(\"yyyy-MM-dd\")");
        FILTER_TIME_FORMAT = dateTimeFormatter;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lnet/nextpulse/jfactuursturen/FactuurSturenClient$Companion;", "", "()V", "API_HOST", "", "getAPI_HOST", "()Ljava/lang/String;", "API_PATH", "getAPI_PATH", "FILTER_TIME_FORMAT", "Lorg/joda/time/format/DateTimeFormatter;", "getFILTER_TIME_FORMAT", "()Lorg/joda/time/format/DateTimeFormatter;", "logger", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "jfactuursturen"})
    public static final class Companion {
        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final String getAPI_HOST() {
            return API_HOST;
        }

        @NotNull
        public final String getAPI_PATH() {
            return API_PATH;
        }

        @NotNull
        public final DateTimeFormatter getFILTER_TIME_FORMAT() {
            return FILTER_TIME_FORMAT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

