/*
 * Decompiled with CFR 0.152.
 */
package net.nextpulse.jacumulus.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.nextpulse.jacumulus.requests.AcumulusRequest;
import net.nextpulse.jacumulus.responses.AcumulusResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SerializationHelper {
    private static final Logger logger = LogManager.getLogger();

    public static String formatXml(String requestBody) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(requestBody)));
            return SerializationHelper.pretty(document);
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            logger.error("Could not format the XML due to {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private static String pretty(Document document) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(2));
        StringWriter output = new StringWriter();
        StreamResult result = new StreamResult(output);
        DOMSource source = new DOMSource(document);
        transformer.transform(source, result);
        return output.toString();
    }

    public static String serializeToXml(Object object) throws JAXBException {
        StringWriter writer = new StringWriter();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AcumulusRequest.class, AcumulusResponse.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.marshal(object, (Writer)writer);
        return writer.toString();
    }

    public static <T> T deserializeXml(String requestString, Class<T> clazz) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller m = context.createUnmarshaller();
        Object response = m.unmarshal((Reader)new StringReader(requestString));
        return (T)response;
    }
}

