/*
 * Decompiled with CFR 0.152.
 */
package net.nextpulse.jacumulus.util;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoggingInterceptor
implements Interceptor {
    private static final Logger logger = LogManager.getLogger();

    public Response intercept(Interceptor.Chain chain) throws IOException {
        if (chain == null) {
            throw new IllegalArgumentException("Received null chain parameter");
        }
        Request request = chain.request();
        long t1 = System.nanoTime();
        logger.debug("Sending {} request to {}", (Object)request.method(), (Object)request.url());
        Response response = chain.proceed(request);
        long t2 = System.nanoTime();
        logger.debug(String.format("Received response for %s in %.1fms%n", response.request().url(), (double)(t2 - t1) / 1000000.0));
        return response;
    }
}

