/*
 * Decompiled with CFR 0.152.
 */
package net.nextpulse.jacumulus;

import java.io.IOException;
import javax.xml.bind.JAXBException;
import net.nextpulse.jacumulus.requests.AcumulusRequest;
import net.nextpulse.jacumulus.requests.AddExpenseRequest;
import net.nextpulse.jacumulus.requests.AddInvoiceRequest;
import net.nextpulse.jacumulus.requests.ListContactsRequest;
import net.nextpulse.jacumulus.requests.ListInvoicesRequest;
import net.nextpulse.jacumulus.requests.models.ContactStatus;
import net.nextpulse.jacumulus.requests.models.ContactType;
import net.nextpulse.jacumulus.requests.models.Contract;
import net.nextpulse.jacumulus.requests.models.Customer;
import net.nextpulse.jacumulus.requests.models.Supplier;
import net.nextpulse.jacumulus.responses.AddExpenseResponse;
import net.nextpulse.jacumulus.responses.InvoiceResponse;
import net.nextpulse.jacumulus.responses.ListContactsResponse;
import net.nextpulse.jacumulus.responses.ListInvoicesResponse;
import net.nextpulse.jacumulus.util.LoggingInterceptor;
import net.nextpulse.jacumulus.util.SerializationHelper;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AcumulusClient {
    private static final Logger logger = LogManager.getLogger();
    private static final OkHttpClient httpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new LoggingInterceptor()).build();
    private String apiUrl = "https://api.sielsystems.nl/acumulus/stable/";
    private boolean testMode = true;
    private Contract contract;

    public AcumulusClient(Contract contract) {
        this.contract = contract;
    }

    public InvoiceResponse addInvoice(Customer customer) throws JAXBException, IOException {
        AddInvoiceRequest request = new AddInvoiceRequest(customer);
        return this.performAndDeserialize("invoices/invoice_add.php", request, InvoiceResponse.class);
    }

    public AddExpenseResponse addExpense(Supplier supplier) throws JAXBException, IOException {
        AddExpenseRequest request = new AddExpenseRequest(supplier);
        return this.performAndDeserialize("expenses/expense_add.php", request, AddExpenseResponse.class);
    }

    public ListInvoicesResponse listIncomingInvoices(String contactId) throws JAXBException, IOException {
        ListInvoicesRequest request = new ListInvoicesRequest(contactId);
        return this.performAndDeserialize("contacts/contact_invoices_incoming.php", request, ListInvoicesResponse.class);
    }

    public ListInvoicesResponse listOutgoingInvoices(String contactId) throws JAXBException, IOException {
        ListInvoicesRequest request = new ListInvoicesRequest(contactId);
        return this.performAndDeserialize("contacts/contact_invoices_outgoing.php", request, ListInvoicesResponse.class);
    }

    public ListContactsResponse listContacts() throws JAXBException, IOException {
        return this.listContacts(0, 0, null, ContactStatus.All, null);
    }

    public ListContactsResponse listContacts(Integer count, Integer offset, String filter, ContactStatus status, ContactType contactType) throws JAXBException, IOException {
        ListContactsRequest request = new ListContactsRequest();
        request.setRowCount(count);
        request.setOffset(offset);
        request.setFilter(filter);
        request.setContactStatus(status);
        request.setContactType(contactType);
        return this.performAndDeserialize("contacts/contacts_list.php", request, ListContactsResponse.class);
    }

    private <T> T performAndDeserialize(String path, AcumulusRequest request, Class<T> responseClass) throws JAXBException, IOException {
        String requestBody = this.serializeRequest(request);
        String responseString = this.performRequest(path, requestBody);
        logger.trace("Response body: {}", (Object)responseString);
        return SerializationHelper.deserializeXml(responseString, responseClass);
    }

    private String performRequest(String path, String requestBody) throws JAXBException, IOException {
        logger.trace("Body: {}", new org.apache.logging.log4j.util.Supplier[]{() -> SerializationHelper.formatXml(requestBody)});
        FormBody body = new FormBody.Builder().add("xmlstring", requestBody).build();
        Request request = new Request.Builder().url(this.apiUrl + path).post((RequestBody)body).build();
        Response response = httpClient.newCall(request).execute();
        ResponseBody responseBody = response.body();
        if (responseBody != null) {
            return responseBody.string();
        }
        throw new IOException("Received null body from server");
    }

    protected String serializeRequest(AcumulusRequest xmlRequest) throws JAXBException {
        xmlRequest.setContract(this.contract);
        xmlRequest.setTestMode(this.testMode ? 1 : 0);
        return SerializationHelper.serializeToXml(xmlRequest);
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }
}

