/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.utils;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import net.netheos.pcsapi.utils.PcsUtils;

public class URIUtil {
    private static final BitSet safeCharacters;
    private static final char[] hexadecimal;

    private URIUtil() {
    }

    public static String encodePath(String path) {
        StringBuilder sb = new StringBuilder(2 * path.length());
        for (int i = 0; i < path.length(); ++i) {
            byte[] bytes;
            char c = path.charAt(i);
            if (safeCharacters.get(c)) {
                sb.append(c);
                continue;
            }
            for (byte b : bytes = String.valueOf(c).getBytes(PcsUtils.UTF8)) {
                sb.append('%').append(hexadecimal[b >> 4 & 0xF]).append(hexadecimal[b & 0xF]);
            }
        }
        return sb.toString();
    }

    public static String getQueryParameter(URI uri, String name) {
        Map<String, String> params = URIUtil.parseQueryParameters(uri.getRawQuery());
        return params.get(name);
    }

    public static Map<String, String> parseQueryParameters(String rawQuery) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        if (rawQuery == null || rawQuery.length() == 0) {
            return ret;
        }
        try {
            String[] pairs;
            for (String pair : pairs = rawQuery.split("&")) {
                String value;
                String name;
                int idx = pair.indexOf("=");
                if (idx > 0) {
                    name = pair.substring(0, idx);
                    value = URLDecoder.decode(pair.substring(idx + 1), PcsUtils.UTF8.name());
                } else if (idx < 0) {
                    name = pair;
                    value = null;
                } else {
                    name = null;
                    value = null;
                }
                if (name == null) continue;
                ret.put(name, value);
            }
            return ret;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        int i;
        hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        safeCharacters = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            safeCharacters.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            safeCharacters.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            safeCharacters.set(i);
        }
        safeCharacters.set(36);
        safeCharacters.set(45);
        safeCharacters.set(95);
        safeCharacters.set(46);
        safeCharacters.set(33);
        safeCharacters.set(42);
        safeCharacters.set(39);
        safeCharacters.set(40);
        safeCharacters.set(41);
        safeCharacters.set(44);
        safeCharacters.set(47);
        safeCharacters.set(64);
    }
}

