/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.netheos.pcsapi.providers.cloudme.CloudMe;
import net.netheos.pcsapi.providers.dropbox.Dropbox;
import net.netheos.pcsapi.providers.googledrive.GoogleDrive;
import net.netheos.pcsapi.providers.hubic.Hubic;
import net.netheos.pcsapi.storage.StorageBuilder;
import net.netheos.pcsapi.storage.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StorageFacade {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageFacade.class);
    private static final Map<String, Class> PROVIDERS = new HashMap<String, Class>();

    public static Set<String> getRegisteredProviders() {
        return PROVIDERS.keySet();
    }

    public static void registerProvider(String providerName, Class<? extends StorageProvider> providerClass) {
        if (PROVIDERS.containsKey(providerName)) {
            throw new IllegalArgumentException("A provider already exists with the name " + providerName);
        }
        PROVIDERS.put(providerName, providerClass);
        LOGGER.debug("Registering new provider: {}", (Object)providerClass.getSimpleName());
    }

    public static StorageBuilder forProvider(String providerName) {
        Class providerClass = PROVIDERS.get(providerName);
        if (providerClass == null) {
            throw new IllegalArgumentException("No provider implementation registered for name: " + providerName);
        }
        return new StorageBuilder(providerName, providerClass);
    }

    private StorageFacade() {
    }

    static {
        StorageFacade.registerProvider("dropbox", Dropbox.class);
        StorageFacade.registerProvider("hubic", Hubic.class);
        StorageFacade.registerProvider("googledrive", GoogleDrive.class);
        StorageFacade.registerProvider("cloudme", CloudMe.class);
    }
}

