/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.providers.dropbox;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.netheos.pcsapi.bytesio.ByteSource;
import net.netheos.pcsapi.credentials.OAuth2AppInfo;
import net.netheos.pcsapi.exceptions.CFileNotFoundException;
import net.netheos.pcsapi.exceptions.CHttpException;
import net.netheos.pcsapi.exceptions.CInvalidFileTypeException;
import net.netheos.pcsapi.exceptions.CRetriableException;
import net.netheos.pcsapi.exceptions.CStorageException;
import net.netheos.pcsapi.models.CBlob;
import net.netheos.pcsapi.models.CDownloadRequest;
import net.netheos.pcsapi.models.CFile;
import net.netheos.pcsapi.models.CFolder;
import net.netheos.pcsapi.models.CFolderContent;
import net.netheos.pcsapi.models.CPath;
import net.netheos.pcsapi.models.CQuota;
import net.netheos.pcsapi.models.CUploadRequest;
import net.netheos.pcsapi.oauth.OAuth2SessionManager;
import net.netheos.pcsapi.request.ByteSourceEntity;
import net.netheos.pcsapi.request.CResponse;
import net.netheos.pcsapi.request.HttpRequestor;
import net.netheos.pcsapi.request.RequestInvoker;
import net.netheos.pcsapi.request.ResponseValidator;
import net.netheos.pcsapi.storage.StorageBuilder;
import net.netheos.pcsapi.storage.StorageProvider;
import net.netheos.pcsapi.utils.PcsUtils;
import net.netheos.pcsapi.utils.URIBuilder;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dropbox
extends StorageProvider<OAuth2SessionManager> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Dropbox.class);
    public static final String PROVIDER_NAME = "dropbox";
    private static final String END_POINT = "https://api.dropbox.com/1";
    private static final URI URI_END_POINT = URI.create("https://api.dropbox.com/1");
    private static final String CONTENT_END_POINT = "https://api-content.dropbox.com/1";
    private static final String METADATA = "metadata";
    private static final ResponseValidator<CResponse> BASIC_RESPONSE_VALIDATOR = new BasicResponseValidator();
    private static final ResponseValidator<CResponse> API_RESPONSE_VALIDATOR = new ApiResponseValidator(BASIC_RESPONSE_VALIDATOR);
    private final String scope;

    public Dropbox(StorageBuilder builder) {
        super(PROVIDER_NAME, new OAuth2SessionManager("https://api.dropbox.com/1/oauth2/authorize", "https://api.dropbox.com/1/oauth2/token", null, false, null, builder), builder.getRetryStrategy(), builder.getHttpClient());
        List<String> perms = ((OAuth2AppInfo)builder.getAppInfo()).getScope();
        if (perms == null || perms.isEmpty()) {
            throw new IllegalStateException("Missing scope for Dropbox provider");
        }
        this.scope = perms.get(0);
    }

    private RequestInvoker<CResponse> getApiRequestInvoker(HttpRequestBase request, CPath path) {
        return new RequestInvoker<CResponse>(new HttpRequestor((HttpUriRequest)request, path, this.sessionManager), API_RESPONSE_VALIDATOR);
    }

    private RequestInvoker<CResponse> getBasicRequestInvoker(HttpRequestBase request, CPath path) {
        return new RequestInvoker<CResponse>(new HttpRequestor((HttpUriRequest)request, path, this.sessionManager), BASIC_RESPONSE_VALIDATOR);
    }

    @Override
    public String getUserId() throws CStorageException {
        JSONObject jsonAccount = this.getAccount();
        return jsonAccount.getString("email");
    }

    private JSONObject getAccount() throws CStorageException {
        URIBuilder builder = new URIBuilder(URI_END_POINT);
        builder.encodedPath("/account/info");
        HttpGet request = new HttpGet(builder.build());
        CResponse response = this.retryStrategy.invokeRetry(this.getApiRequestInvoker((HttpRequestBase)request, null));
        return response.asJSONObject();
    }

    @Override
    public CQuota getQuota() throws CStorageException {
        JSONObject jsonQuota = this.getAccount().getJSONObject("quota_info");
        long bytesUsed = jsonQuota.getLong("shared") + jsonQuota.getLong("normal");
        long bytesAllowed = jsonQuota.getLong("quota");
        return new CQuota(bytesUsed, bytesAllowed);
    }

    @Override
    public CFolderContent listRootFolder() throws CInvalidFileTypeException {
        return this.listFolder(CPath.ROOT);
    }

    @Override
    public CFolderContent listFolder(CPath cpath) throws CStorageException {
        JSONObject jObj;
        CResponse response;
        String url = this.buildUrl(METADATA, cpath);
        HttpGet request = new HttpGet(url);
        RequestInvoker<CResponse> invoker = this.getApiRequestInvoker((HttpRequestBase)request, cpath);
        try {
            response = this.retryStrategy.invokeRetry(invoker);
            jObj = response.asJSONObject();
        }
        catch (CFileNotFoundException ex) {
            return null;
        }
        LOGGER.debug("listFolder - json: {}", (Object)jObj);
        if (jObj.optBoolean("is_deleted", false)) {
            return null;
        }
        if (!jObj.has("is_dir")) {
            throw PcsUtils.buildCStorageException(response, "No 'is_dir' key in JSON metadata", cpath);
        }
        if (!jObj.getBoolean("is_dir")) {
            throw new CInvalidFileTypeException(cpath, false);
        }
        JSONArray jContents = jObj.getJSONArray("contents");
        HashMap<CPath, CFile> map = new HashMap<CPath, CFile>(jContents.length());
        for (int i = 0; i < jContents.length(); ++i) {
            CFile cfile = this.parseCFile(jContents.getJSONObject(i));
            map.put(cfile.getPath(), cfile);
        }
        return new CFolderContent(map);
    }

    private String buildUrl(String methodPath, CPath path) {
        StringBuilder sb = new StringBuilder();
        sb.append(END_POINT).append('/').append(methodPath);
        if (path != null) {
            sb.append('/').append(this.scope).append(path.getUrlEncoded());
        }
        return sb.toString();
    }

    @Override
    public CFolderContent listFolder(CFolder folder) throws CStorageException {
        return this.listFolder(folder.getPath());
    }

    @Override
    public boolean createFolder(CPath cpath) throws CStorageException {
        boolean bl;
        String url = this.buildUrl("fileops/create_folder");
        HttpPost request = new HttpPost(url);
        try {
            ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
            parameters.add(new BasicNameValuePair("root", this.scope));
            parameters.add(new BasicNameValuePair("path", cpath.getPathName()));
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters, PcsUtils.UTF8.name()));
        }
        catch (UnsupportedEncodingException ex) {
            throw new CStorageException(ex.getMessage(), ex);
        }
        RequestInvoker<CResponse> invoker = this.getApiRequestInvoker((HttpRequestBase)request, cpath);
        CResponse response = null;
        try {
            response = this.retryStrategy.invokeRetry(invoker);
            bl = true;
        }
        catch (CHttpException e) {
            block8: {
                boolean bl2;
                try {
                    if (e.getStatus() != 403) break block8;
                    CFile cfile = this.getFile(cpath);
                    if (!cfile.isFolder()) {
                        throw new CInvalidFileTypeException(cpath, false);
                    }
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    PcsUtils.closeQuietly(response);
                    throw throwable;
                }
                PcsUtils.closeQuietly(response);
                return bl2;
            }
            throw e;
        }
        PcsUtils.closeQuietly(response);
        return bl;
    }

    private String buildUrl(String methodPath) {
        return this.buildUrl(methodPath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(CPath cpath) throws CStorageException {
        boolean bl;
        String url = this.buildUrl("fileops/delete");
        HttpPost request = new HttpPost(url);
        try {
            ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
            parameters.add(new BasicNameValuePair("root", this.scope));
            parameters.add(new BasicNameValuePair("path", cpath.getPathName()));
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters, PcsUtils.UTF8.name()));
        }
        catch (UnsupportedEncodingException ex) {
            throw new CStorageException(ex.getMessage(), ex);
        }
        RequestInvoker<CResponse> invoker = this.getApiRequestInvoker((HttpRequestBase)request, cpath);
        CResponse response = null;
        try {
            response = this.retryStrategy.invokeRetry(invoker);
            bl = true;
        }
        catch (CFileNotFoundException e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                PcsUtils.closeQuietly(response);
                throw throwable;
            }
            PcsUtils.closeQuietly(response);
            return bl2;
        }
        PcsUtils.closeQuietly(response);
        return bl;
    }

    @Override
    public CFile getFile(CPath cpath) throws CStorageException {
        JSONObject jObj;
        String url = this.buildUrl(METADATA, cpath);
        URI uri = new URIBuilder(URI.create(url)).addParameter("list", "false").build();
        HttpGet request = new HttpGet(uri);
        RequestInvoker<CResponse> invoker = this.getApiRequestInvoker((HttpRequestBase)request, cpath);
        try {
            CResponse response = this.retryStrategy.invokeRetry(invoker);
            jObj = response.asJSONObject();
        }
        catch (CFileNotFoundException ex) {
            return null;
        }
        if (jObj.optBoolean("is_deleted", false)) {
            LOGGER.debug("CFile {} is deleted", (Object)cpath);
            return null;
        }
        return this.parseCFile(jObj);
    }

    @Override
    public void download(CDownloadRequest downloadRequest) throws CStorageException {
        String url = this.buildContentUrl("files", downloadRequest.getPath());
        URI uri = new URIBuilder(URI.create(url)).build();
        HttpGet request = new HttpGet(uri);
        for (Header header : downloadRequest.getHttpHeaders()) {
            request.addHeader(header);
        }
        RequestInvoker<CResponse> invoker = this.getBasicRequestInvoker((HttpRequestBase)request, downloadRequest.getPath());
        try {
            CResponse response = this.retryStrategy.invokeRetry(invoker);
            PcsUtils.downloadDataToSink(response, downloadRequest.getByteSink());
        }
        catch (CFileNotFoundException e) {
            CFile cfile = this.getFile(downloadRequest.getPath());
            if (cfile == null) {
                throw e;
            }
            if (cfile.isFolder()) {
                throw new CInvalidFileTypeException(cfile.getPath(), true);
            }
            throw new CStorageException("Not downloadable file : " + cfile, e);
        }
    }

    private String buildContentUrl(String methodPath, CPath path) {
        return "https://api-content.dropbox.com/1/" + methodPath + '/' + this.scope + path.getUrlEncoded();
    }

    @Override
    public void upload(CUploadRequest uploadRequest) throws CStorageException {
        CFile cfile = this.getFile(uploadRequest.getPath());
        if (cfile != null && cfile.isFolder()) {
            throw new CInvalidFileTypeException(cfile.getPath(), true);
        }
        String url = this.buildContentUrl("files_put", uploadRequest.getPath());
        URI uri = URI.create(url);
        HttpPut request = new HttpPut(uri);
        try {
            ByteSource bs = uploadRequest.getByteSource();
            request.setEntity((HttpEntity)new ByteSourceEntity(bs));
            RequestInvoker<CResponse> invoker = this.getBasicRequestInvoker((HttpRequestBase)request, uploadRequest.getPath());
            this.retryStrategy.invokeRetry(invoker).close();
        }
        catch (IOException ex) {
            throw new CStorageException(ex.getMessage(), ex);
        }
    }

    private CFile parseCFile(JSONObject jObj) {
        CFile cfile;
        if (jObj.optBoolean("is_dir", false)) {
            cfile = new CFolder(new CPath(jObj.getString("path")));
        } else {
            cfile = new CBlob(new CPath(jObj.getString("path")), jObj.getLong("bytes"), jObj.getString("mime_type"));
            String stringDate = jObj.getString("modified");
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
                Date modified = sdf.parse(stringDate);
                cfile.setModificationDate(modified);
            }
            catch (ParseException ex) {
                throw new CStorageException("Can't parse date modified: " + stringDate + " (" + ex.getMessage() + ")", ex);
            }
        }
        return cfile;
    }

    private static class BasicResponseValidator
    implements ResponseValidator<CResponse> {
        private BasicResponseValidator() {
        }

        @Override
        public void validateResponse(CResponse response, CPath path) throws CStorageException {
            int status = response.getStatus();
            if (status == 507) {
                throw this.buildCHttpException(response, "Quota exceeded", path);
            }
            if (status >= 500) {
                throw new CRetriableException(this.buildCHttpException(response, null, path));
            }
            if (status >= 300) {
                throw this.buildCHttpException(response, null, path);
            }
        }

        private CStorageException buildCHttpException(CResponse response, String errorMessage, CPath path) {
            String ct = response.getContentType();
            if (ct != null && (ct.contains("text/javascript") || ct.contains("application/json"))) {
                JSONObject json = response.asJSONObject();
                errorMessage = json.getString("error");
            }
            return PcsUtils.buildCStorageException(response, errorMessage, path);
        }
    }

    private static class ApiResponseValidator
    implements ResponseValidator<CResponse> {
        private final ResponseValidator<CResponse> parent;

        public ApiResponseValidator(ResponseValidator<CResponse> parent) {
            this.parent = parent;
        }

        @Override
        public void validateResponse(CResponse response, CPath path) throws CStorageException {
            this.parent.validateResponse(response, path);
            LOGGER.debug("ValidateResponse - server response OK");
            PcsUtils.ensureContentTypeIsJson(response, true);
            LOGGER.debug("ValidateResponse - all is OK");
        }
    }
}

