/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.providers.cloudme;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import net.netheos.pcsapi.models.CBlob;
import net.netheos.pcsapi.models.CPath;
import net.netheos.pcsapi.providers.cloudme.CMFolder;
import org.w3c.dom.Element;

public class CMBlob {
    private final String id;
    private final CMFolder folder;
    private final String name;
    private final long length;
    private final Date updated;
    private final String contentType;

    public CMBlob(CMFolder folder, String id, String name, long length, Date updated, String contentType) {
        this.folder = folder;
        this.id = id;
        this.name = name;
        this.length = length;
        this.updated = updated;
        this.contentType = contentType;
    }

    public CBlob toCBlob() {
        CBlob cBlob = new CBlob(this.getPath(), this.length, this.contentType);
        cBlob.setModificationDate(this.updated);
        return cBlob;
    }

    public CPath getPath() {
        return this.folder.getCPath().add(this.name);
    }

    public static CMBlob buildCMFile(CMFolder folder, Element xmlEntry) throws ParseException {
        String name = xmlEntry.getElementsByTagNameNS("*", "title").item(0).getTextContent();
        String id = xmlEntry.getElementsByTagNameNS("*", "document").item(0).getTextContent();
        String updateDate = xmlEntry.getElementsByTagNameNS("*", "updated").item(0).getTextContent();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setLenient(false);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date updated = sdf.parse(updateDate);
        Element elementLink = (Element)xmlEntry.getElementsByTagNameNS("*", "link").item(0);
        long length = Long.parseLong(elementLink.getAttribute("length"));
        String contentType = elementLink.getAttribute("type");
        return new CMBlob(folder, id, name, length, updated, contentType);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }
}

