/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.oauth;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import net.netheos.pcsapi.credentials.Credentials;
import net.netheos.pcsapi.credentials.OAuth2AppInfo;
import net.netheos.pcsapi.credentials.OAuth2Credentials;
import net.netheos.pcsapi.credentials.UserCredentials;
import net.netheos.pcsapi.credentials.UserCredentialsRepository;
import net.netheos.pcsapi.exceptions.CRetriableException;
import net.netheos.pcsapi.exceptions.CStorageException;
import net.netheos.pcsapi.oauth.SessionManager;
import net.netheos.pcsapi.request.CResponse;
import net.netheos.pcsapi.storage.StorageBuilder;
import net.netheos.pcsapi.utils.PcsUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2SessionManager
extends SessionManager<OAuth2Credentials> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth2SessionManager.class);
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private final Object refreshLock = new Object();
    private final String authorizeUrl;
    private final String accessTokenUrl;
    private final String refreshTokenUrl;
    private final boolean scopeInAuthorization;
    private final Character scopePermsSeparator;
    private final OAuth2AppInfo appInfo;
    private final UserCredentialsRepository userCredentialsRepo;
    private final HttpClient httpClient;

    public OAuth2SessionManager(String authorizeUrl, String accessTokenUrl, String refreshTokenUrl, boolean scopeInAuthorization, Character scopePermsSeparator, StorageBuilder builder) {
        super(builder.getUserCredentials());
        OAuth2Credentials credentials;
        this.httpClient = builder.getHttpClient();
        this.authorizeUrl = authorizeUrl;
        this.accessTokenUrl = accessTokenUrl;
        this.refreshTokenUrl = refreshTokenUrl;
        this.scopeInAuthorization = scopeInAuthorization;
        this.scopePermsSeparator = scopePermsSeparator;
        this.appInfo = (OAuth2AppInfo)builder.getAppInfo();
        this.userCredentialsRepo = builder.getUserCredentialsRepo();
        if (this.userCredentials != null && (credentials = (OAuth2Credentials)this.userCredentials.getCredentials()).getAccessToken() == null) {
            throw new IllegalStateException("User credentials do not contain any access token");
        }
    }

    @Override
    public CResponse execute(HttpUriRequest request) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}: {}", (Object)request.getMethod(), (Object)PcsUtils.shortenUrl(request.getURI()));
        }
        if (((OAuth2Credentials)this.userCredentials.getCredentials()).hasExpired()) {
            this.refreshToken();
        }
        try {
            request.removeHeaders(HEADER_AUTHORIZATION);
            request.addHeader(HEADER_AUTHORIZATION, "Bearer " + ((OAuth2Credentials)this.userCredentials.getCredentials()).getAccessToken());
            HttpResponse httpResponse = this.httpClient.execute(request);
            return new CResponse(request, httpResponse);
        }
        catch (IOException ex) {
            throw new CRetriableException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshToken() throws CStorageException {
        if (this.refreshTokenUrl == null) {
            throw new CStorageException("Provider does not support token refresh");
        }
        OAuth2Credentials currentCredentials = (OAuth2Credentials)this.userCredentials.getCredentials();
        Object object = this.refreshLock;
        synchronized (object) {
            HttpResponse response;
            OAuth2Credentials afterLockCredentials = (OAuth2Credentials)this.userCredentials.getCredentials();
            if (afterLockCredentials.getRefreshToken() == null) {
                throw new CStorageException("No refresh token available");
            }
            if (!afterLockCredentials.equals(currentCredentials)) {
                LOGGER.debug("Not refreshed token in this thread, already done");
                return;
            }
            LOGGER.debug("Refreshing token");
            try {
                HttpPost post = new HttpPost(this.accessTokenUrl);
                ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
                parameters.add(new BasicNameValuePair("client_id", this.appInfo.getAppId()));
                parameters.add(new BasicNameValuePair("client_secret", this.appInfo.getAppSecret()));
                parameters.add(new BasicNameValuePair("refresh_token", afterLockCredentials.getRefreshToken()));
                parameters.add(new BasicNameValuePair("scope", this.getScopeForAuthorization()));
                parameters.add(new BasicNameValuePair("grant_type", "refresh_token"));
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters, PcsUtils.UTF8.name()));
                response = this.httpClient.execute((HttpUriRequest)post);
            }
            catch (IOException ex) {
                throw new CStorageException("HTTP request while refreshing token has failed", ex);
            }
            try {
                String data = EntityUtils.toString((HttpEntity)response.getEntity(), (String)PcsUtils.UTF8.name());
                JSONObject json = new JSONObject(data);
                afterLockCredentials.update(json);
            }
            catch (IOException ex) {
                throw new CStorageException("Can't get string from HttpResponse: " + response.toString(), ex);
            }
            catch (JSONException ex) {
                throw new CStorageException("Error parsing the JSON response", ex);
            }
            try {
                this.userCredentialsRepo.save(this.userCredentials);
            }
            catch (IOException ex) {
                throw new CStorageException("Can't save credentials", ex);
            }
        }
    }

    UserCredentials fetchUserCredentials(String code) {
        String json;
        HttpResponse response;
        HttpPost post = new HttpPost(this.accessTokenUrl);
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("client_id", this.appInfo.getAppId()));
        parameters.add(new BasicNameValuePair("client_secret", this.appInfo.getAppSecret()));
        parameters.add(new BasicNameValuePair("code", code));
        parameters.add(new BasicNameValuePair("grant_type", "authorization_code"));
        if (this.appInfo.getRedirectUrl() != null) {
            parameters.add(new BasicNameValuePair("redirect_uri", this.appInfo.getRedirectUrl()));
        }
        try {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters, PcsUtils.UTF8.name()));
        }
        catch (UnsupportedEncodingException ex) {
            throw new CStorageException("Can't encode parameters", ex);
        }
        try {
            response = this.httpClient.execute((HttpUriRequest)post);
        }
        catch (IOException e) {
            throw new CStorageException("HTTP request while fetching token has failed", e);
        }
        try {
            json = EntityUtils.toString((HttpEntity)response.getEntity(), (String)PcsUtils.UTF8.name());
        }
        catch (IOException e) {
            throw new CStorageException("Can't retrieve json string in HTTP response entity", e);
        }
        LOGGER.debug("fetchUserCredentials - json: {}", (Object)json);
        Credentials credentials = Credentials.createFromJson(json);
        this.userCredentials = new UserCredentials<Credentials>(this.appInfo, null, credentials);
        return this.userCredentials;
    }

    String getScopeForAuthorization() {
        if (!this.scopeInAuthorization) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String perm : this.appInfo.getScope()) {
            sb.append(perm).append(this.scopePermsSeparator);
        }
        return new String(sb.deleteCharAt(sb.length() - 1));
    }

    UserCredentialsRepository getUserCredentialsRepository() {
        return this.userCredentialsRepo;
    }

    OAuth2AppInfo getAppInfo() {
        return this.appInfo;
    }

    String getAuthorizeUrl() {
        return this.authorizeUrl;
    }
}

