/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.models;

import net.netheos.pcsapi.bytesio.ByteSink;
import net.netheos.pcsapi.bytesio.ProgressByteSink;
import net.netheos.pcsapi.bytesio.ProgressListener;
import net.netheos.pcsapi.models.CPath;
import net.netheos.pcsapi.request.Headers;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class CDownloadRequest {
    private final CPath path;
    private final ByteSink byteSink;
    private ByteRange byteRange;
    private ProgressListener progressListener;

    public CDownloadRequest(CPath path, ByteSink byteSink) {
        this.path = path;
        this.byteSink = byteSink;
        this.byteRange = null;
    }

    public CPath getPath() {
        return this.path;
    }

    public Headers getHttpHeaders() {
        Headers headers = new Headers();
        if (this.byteRange != null) {
            long start;
            StringBuilder rangeBuilder = new StringBuilder("bytes=");
            if (this.byteRange.offset >= 0L) {
                rangeBuilder.append(this.byteRange.offset);
                start = this.byteRange.offset;
            } else {
                start = 1L;
            }
            rangeBuilder.append("-");
            if (this.byteRange.length > 0L) {
                rangeBuilder.append(start + this.byteRange.length - 1L);
            }
            BasicHeader rangeHeader = new BasicHeader("Range", rangeBuilder.toString());
            headers.addHeader((Header)rangeHeader);
        }
        return headers;
    }

    public CDownloadRequest setRange(long offset, long length) {
        if (length == 0L) {
            length = -1L;
        }
        this.byteRange = offset < 0L && length < 0L ? null : new ByteRange(offset, length);
        return this;
    }

    public CDownloadRequest setProgressListener(ProgressListener pl) {
        this.progressListener = pl;
        return this;
    }

    public ByteSink getByteSink() {
        ByteSink bs = this.byteSink;
        if (this.progressListener != null) {
            bs = new ProgressByteSink(bs, this.progressListener);
        }
        return bs;
    }

    private static class ByteRange {
        private final long offset;
        private final long length;

        public ByteRange(long offset, long length) {
            this.offset = offset;
            this.length = length;
        }
    }
}

