/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.credentials;

import java.util.Date;
import net.netheos.pcsapi.credentials.Credentials;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2Credentials
extends Credentials {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth2Credentials.class);
    private static final String ACCESS_TOKEN = "access_token";
    private static final String EXPIRES_IN = "expires_in";
    private static final String EXPIRES_AT = "expires_at";
    private static final String TOKEN_TYPE = "token_type";
    private String accessToken;
    private Date expiresAt;
    private String refreshToken;
    private String tokenType;

    static OAuth2Credentials fromJson(JSONObject jsonObj) {
        String accessToken = jsonObj.optString(ACCESS_TOKEN, null);
        Date expiresAt = OAuth2Credentials.calculateExpiresAt(jsonObj);
        String refreshToken = jsonObj.optString("refresh_token", null);
        String tokenType = jsonObj.optString(TOKEN_TYPE, null);
        return new OAuth2Credentials(accessToken, expiresAt, refreshToken, tokenType);
    }

    private OAuth2Credentials(String accessToken, Date expiresAt, String refreshToken, String tokenType) {
        this.accessToken = accessToken;
        this.expiresAt = expiresAt;
        this.refreshToken = refreshToken;
        this.tokenType = tokenType;
    }

    public boolean hasExpired() {
        if (this.expiresAt == null) {
            LOGGER.debug("hasExpired - token is not expirable");
            return false;
        }
        long now = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("hasExpired? - now: {} expiredAt: {} ", (Object)new Date(now), (Object)this.expiresAt);
        }
        return now > this.expiresAt.getTime();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void update(JSONObject json) {
        this.accessToken = json.getString(ACCESS_TOKEN);
        this.tokenType = json.getString(TOKEN_TYPE);
        this.expiresAt = OAuth2Credentials.calculateExpiresAt(json);
        if (json.has("refresh_token")) {
            this.refreshToken = json.getString("refresh_token");
        }
    }

    private static Date calculateExpiresAt(JSONObject jsonObj) {
        long expiresAt_s = jsonObj.optLong(EXPIRES_AT, -1L);
        if (expiresAt_s < 0L && jsonObj.has(EXPIRES_IN)) {
            long expiresIn_s = jsonObj.getLong(EXPIRES_IN);
            if (expiresIn_s > 360L) {
                expiresIn_s -= 300L;
            }
            expiresAt_s = System.currentTimeMillis() / 1000L + expiresIn_s;
        }
        if (expiresAt_s < 0L) {
            return null;
        }
        return new Date(expiresAt_s * 1000L);
    }

    @Override
    public String toJson() {
        JSONObject jObj = new JSONObject();
        jObj.put(ACCESS_TOKEN, (Object)this.accessToken);
        if (this.expiresAt != null) {
            jObj.put(EXPIRES_AT, this.expiresAt.getTime() / 1000L);
        }
        if (this.refreshToken != null) {
            jObj.put("refresh_token", (Object)this.refreshToken);
        }
        if (this.tokenType != null) {
            jObj.put(TOKEN_TYPE, (Object)this.tokenType);
        }
        return jObj.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof OAuth2Credentials) {
            OAuth2Credentials creds = (OAuth2Credentials)obj;
            return this.accessToken.equals(creds.accessToken);
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + (this.accessToken != null ? this.accessToken.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "OAuth2Credentials {expiresAt=" + this.expiresAt + ", tokenType='" + this.tokenType + "'}";
    }
}

