/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.credentials;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.netheos.pcsapi.credentials.AppInfo;
import net.netheos.pcsapi.credentials.AppInfoRepository;
import net.netheos.pcsapi.credentials.OAuth2AppInfo;
import net.netheos.pcsapi.credentials.PasswordAppInfo;
import net.netheos.pcsapi.utils.PcsUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class AppInfoFileRepository
implements AppInfoRepository {
    private final File file;
    private final Map<String, AppInfo> appInfoMap = new HashMap<String, AppInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppInfoFileRepository(File file) throws IOException {
        this.file = file;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), PcsUtils.UTF8));
            while ((line = reader.readLine()) != null) {
                AppInfo appInfo;
                if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                String[] appInfoArray = line.split("=", 2);
                String[] appInfoKeyArray = appInfoArray[0].trim().split("\\.");
                String providerName = appInfoKeyArray[0];
                String appName = appInfoKeyArray[1];
                String appInfoValue = appInfoArray[1].trim();
                JSONObject jsonObj = (JSONObject)new JSONTokener(appInfoValue).nextValue();
                String appId = jsonObj.optString("appId", null);
                if (appId != null) {
                    JSONArray jsonScope = jsonObj.optJSONArray("scope");
                    ArrayList<String> scopeList = new ArrayList<String>();
                    for (int i = 0; i < jsonScope.length(); ++i) {
                        scopeList.add(jsonScope.get(i).toString());
                    }
                    String appSecret = jsonObj.getString("appSecret");
                    String redirectUrl = jsonObj.optString("redirectUrl", null);
                    appInfo = new OAuth2AppInfo(providerName, appName, appId, appSecret, scopeList, redirectUrl);
                } else {
                    appInfo = new PasswordAppInfo(providerName, appName);
                }
                this.appInfoMap.put(this.getAppKey(providerName, appName), appInfo);
            }
        }
        catch (Throwable throwable) {
            PcsUtils.closeQuietly(reader);
            throw throwable;
        }
        PcsUtils.closeQuietly(reader);
    }

    private String getAppKey(String providerName, String appName) {
        return providerName + "." + appName;
    }

    @Override
    public AppInfo get(String providerName) {
        return this.get(providerName, null);
    }

    @Override
    public AppInfo get(String providerName, String appName) {
        AppInfo appInfo = null;
        if (appName != null) {
            String key = this.getAppKey(providerName, appName);
            appInfo = this.appInfoMap.get(key);
            if (appInfo == null) {
                throw new IllegalStateException(String.format("No application found for provider '%s' and name '%s'", providerName, appName));
            }
            return appInfo;
        }
        for (String key : this.appInfoMap.keySet()) {
            if (!key.startsWith(providerName + ".")) continue;
            if (appInfo != null) {
                throw new IllegalStateException("Several applications found for provider:" + providerName);
            }
            appInfo = this.appInfoMap.get(key);
        }
        if (appInfo == null) {
            throw new IllegalStateException("No application found for provider: " + providerName);
        }
        return appInfo;
    }

    public String toString() {
        return "AppInfoFileRepo{file='" + this.file + '\'' + ", appInfoMap=" + this.appInfoMap + '}';
    }
}

