/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.bytesio;

import java.io.IOException;
import java.io.InputStream;
import net.netheos.pcsapi.bytesio.ByteSource;
import net.netheos.pcsapi.bytesio.LimitedInputStream;

public class RangeByteSource
implements ByteSource {
    private ByteSource source;
    private long start;
    private long length;

    public RangeByteSource(ByteSource source) {
        this(source, 0L);
    }

    public RangeByteSource(ByteSource source, long startOffset) {
        this(source, startOffset, source.length() - startOffset);
    }

    public RangeByteSource(ByteSource source, long startOffset, long length) {
        long sourceLength = source.length();
        if (startOffset >= sourceLength) {
            throw new IllegalArgumentException(String.format("startOffset (%d) should be smaller than source.length (%d)", startOffset, sourceLength));
        }
        if (length < 0L) {
            throw new IllegalArgumentException(String.format("length (%d) should be bigger than 0", length));
        }
        if (startOffset + length > sourceLength) {
            throw new IllegalArgumentException(String.format("startOffset (%d) + length (%d) should be smaller than source.length (%d)", startOffset, length, sourceLength));
        }
        this.source = source;
        this.start = startOffset;
        this.length = length;
    }

    @Override
    public InputStream openStream() throws IOException {
        InputStream is = this.source.openStream();
        is.skip(this.start);
        LimitedInputStream lis = new LimitedInputStream(is, this.length);
        return lis;
    }

    @Override
    public long length() {
        return this.length;
    }

    public String toString() {
        return "RangeByteSource {source=" + this.source + ", start=" + this.start + ", length=" + this.length + "}";
    }
}

