/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.bytesio;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.netheos.pcsapi.bytesio.ProgressListener;

class ProgressInputStream
extends FilterInputStream {
    private ProgressListener listener;
    private long currentBytes;

    ProgressInputStream(InputStream stream, ProgressListener listener) {
        this(stream, listener, 0L);
    }

    ProgressInputStream(InputStream stream, ProgressListener listener, long currentBytes) {
        super(stream);
        this.listener = listener;
        this.currentBytes = currentBytes;
    }

    public long getCurrentBytes() {
        return this.currentBytes;
    }

    private void addBytes(long n) {
        if (n >= 0L) {
            this.currentBytes += n;
            this.listener.progress(this.currentBytes);
        }
    }

    @Override
    public int read() throws IOException {
        int ret = this.in.read();
        if (ret >= 0) {
            this.addBytes(1L);
        }
        return ret;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int nbBytesRead = this.in.read(b, off, len);
        this.addBytes(nbBytesRead);
        return nbBytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        long nbBytesSkipped = super.skip(n);
        this.addBytes(nbBytesSkipped);
        return nbBytesSkipped;
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

