/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.bytesio;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import net.netheos.pcsapi.bytesio.ByteSinkStream;
import net.netheos.pcsapi.bytesio.FileByteSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileByteSinkStream
extends ByteSinkStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileByteSinkStream.class);
    private final FileByteSink fileByteSink;

    public FileByteSinkStream(FileByteSink fileByteSink, FileOutputStream fos) {
        super(fos);
        this.fileByteSink = fileByteSink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        boolean closedProperly;
        block29: {
            closedProperly = false;
            try {
                super.flush();
                super.close();
                closedProperly = true;
                if (!this.fileByteSink.isAborted()) break block29;
            }
            catch (Throwable throwable) {
                if (this.fileByteSink.isAborted()) {
                    LOGGER.debug("Sink process has been aborted");
                }
                if (this.fileByteSink.isDeleteOnAbort() && !closedProperly) {
                    LOGGER.warn("Sink file not closed properly : will be deleted");
                }
                File file = this.fileByteSink.getActualFile();
                if (this.fileByteSink.isAborted() || !closedProperly) {
                    if (this.fileByteSink.isDeleteOnAbort()) {
                        LOGGER.debug("Will delete sink file: {}", (Object)file);
                        file.delete();
                        boolean success = file.delete();
                        LOGGER.debug("file deletion - success: {}", (Object)success);
                    } else {
                        long actualFileLength = file.length();
                        LOGGER.debug("Actual file length: {}", (Object)actualFileLength);
                        if (this.fileByteSink.getExpectedLength() >= 0L) {
                            if (actualFileLength == this.fileByteSink.getExpectedLength()) {
                                LOGGER.debug("Sink file is complete: {} ({} bytes)", (Object)file, (Object)actualFileLength);
                            } else if (actualFileLength < this.fileByteSink.getExpectedLength()) {
                                LOGGER.debug("Sink file is too short: {} ({} bytes < {} expected)", new Object[]{file, actualFileLength, this.fileByteSink.getExpectedLength()});
                            } else {
                                LOGGER.debug("Sink file is too long: {} ({} bytes > {} expected)", new Object[]{file, actualFileLength, this.fileByteSink.getExpectedLength()});
                            }
                        } else {
                            LOGGER.debug("Sink file may be incomplete: {} ({} bytes)", (Object)file, (Object)actualFileLength);
                        }
                    }
                } else if (this.fileByteSink.isTempName()) {
                    File destFile = this.fileByteSink.getFile();
                    if (destFile.exists()) {
                        destFile.delete();
                    }
                    boolean success = file.renameTo(destFile);
                    LOGGER.debug("file renaming - success: {}", (Object)success);
                }
                throw throwable;
            }
            LOGGER.debug("Sink process has been aborted");
        }
        if (this.fileByteSink.isDeleteOnAbort() && !closedProperly) {
            LOGGER.warn("Sink file not closed properly : will be deleted");
        }
        File file = this.fileByteSink.getActualFile();
        if (this.fileByteSink.isAborted() || !closedProperly) {
            if (this.fileByteSink.isDeleteOnAbort()) {
                LOGGER.debug("Will delete sink file: {}", (Object)file);
                file.delete();
                boolean success = file.delete();
                LOGGER.debug("file deletion - success: {}", (Object)success);
            } else {
                long actualFileLength = file.length();
                LOGGER.debug("Actual file length: {}", (Object)actualFileLength);
                if (this.fileByteSink.getExpectedLength() >= 0L) {
                    if (actualFileLength == this.fileByteSink.getExpectedLength()) {
                        LOGGER.debug("Sink file is complete: {} ({} bytes)", (Object)file, (Object)actualFileLength);
                    } else if (actualFileLength < this.fileByteSink.getExpectedLength()) {
                        LOGGER.debug("Sink file is too short: {} ({} bytes < {} expected)", new Object[]{file, actualFileLength, this.fileByteSink.getExpectedLength()});
                    } else {
                        LOGGER.debug("Sink file is too long: {} ({} bytes > {} expected)", new Object[]{file, actualFileLength, this.fileByteSink.getExpectedLength()});
                    }
                } else {
                    LOGGER.debug("Sink file may be incomplete: {} ({} bytes)", (Object)file, (Object)actualFileLength);
                }
            }
        } else if (this.fileByteSink.isTempName()) {
            File destFile = this.fileByteSink.getFile();
            if (destFile.exists()) {
                destFile.delete();
            }
            boolean success = file.renameTo(destFile);
            LOGGER.debug("file renaming - success: {}", (Object)success);
        }
    }

    @Override
    public void abort() {
        this.fileByteSink.setAborted(true);
    }

    @Override
    public boolean isAborted() {
        return this.fileByteSink.isAborted();
    }
}

