/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.bytesio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import net.netheos.pcsapi.bytesio.ByteSink;
import net.netheos.pcsapi.bytesio.ByteSinkStream;
import net.netheos.pcsapi.bytesio.FileByteSinkStream;

public class FileByteSink
implements ByteSink {
    private final File file;
    private final boolean appended;
    private final boolean tempName;
    private final boolean deleteOnAbort;
    private long expectedLength;
    private boolean aborted;

    public FileByteSink(File file) {
        this(file, false, false, false);
    }

    public FileByteSink(File file, boolean tempName, boolean deleteOnAbort, boolean appended) {
        this.file = file;
        this.appended = appended;
        this.tempName = tempName;
        this.deleteOnAbort = deleteOnAbort;
        this.expectedLength = 0L;
        this.aborted = false;
    }

    File getFile() {
        return this.file;
    }

    boolean isTempName() {
        return this.tempName;
    }

    long getExpectedLength() {
        return this.expectedLength;
    }

    @Override
    public void setExpectedLength(long expectedLength) {
        this.expectedLength = expectedLength;
    }

    boolean isAppended() {
        return this.appended;
    }

    boolean isDeleteOnAbort() {
        return this.deleteOnAbort;
    }

    boolean isAborted() {
        return this.aborted;
    }

    void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    @Override
    public ByteSinkStream openStream() throws FileNotFoundException {
        File actualFile = this.getActualFile();
        FileByteSinkStream bss = new FileByteSinkStream(this, new FileOutputStream(actualFile, this.appended));
        this.aborted = false;
        return bss;
    }

    File getActualFile() {
        if (this.tempName) {
            return new File(this.file + ".part");
        }
        return this.file;
    }

    public String toString() {
        return "FileByteSink {fileName='" + this.file + "'}";
    }
}

