/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.providers.hubic;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import net.netheos.pcsapi.providers.hubic.Swift;
import net.netheos.pcsapi.request.Headers;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class SwiftTest {
    @Test
    public void testParseTimestamp() {
        Headers headers = new Headers();
        Date timestamp = Swift.parseTimestamp((Headers)headers);
        Assert.assertNull((Object)timestamp);
        headers.addHeader("X-Timestamp", "1383925113.43900");
        timestamp = Swift.parseTimestamp((Headers)headers);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(timestamp);
        System.out.println(timestamp);
        Assert.assertEquals((long)2013L, (long)cal.get(1));
        Assert.assertEquals((long)10L, (long)cal.get(2));
        Assert.assertEquals((long)8L, (long)cal.get(5));
        Assert.assertEquals((long)15L, (long)cal.get(11));
        Assert.assertEquals((long)38L, (long)cal.get(12));
        Assert.assertEquals((long)33L, (long)cal.get(13));
        Assert.assertEquals((long)439L, (long)cal.get(14));
        this.checkTimestamp("1383925113.430723", new Date(1383925113430L));
        this.checkTimestamp("1383925113.43900", new Date(1383925113439L));
        this.checkTimestamp("1383925113.439", new Date(1383925113439L));
        this.checkTimestamp("1383925113.43", new Date(1383925113430L));
        this.checkTimestamp("1383925113.4", new Date(1383925113400L));
        this.checkTimestamp("1383925113.", new Date(1383925113000L));
        this.checkTimestamp("1383925113", new Date(1383925113000L));
    }

    private void checkTimestamp(String header_value, Date expected) {
        Headers headers = new Headers();
        headers.addHeader("X-Timestamp", header_value);
        Date parsed = Swift.parseTimestamp((Headers)headers);
        Assert.assertEquals((Object)expected, (Object)parsed);
    }

    @Test
    public void testParseLastModified() {
        JSONObject json = new JSONObject();
        Date timestamp = Swift.parseLastModified((JSONObject)json);
        Assert.assertNull((Object)timestamp);
        json.put("last_modified", (Object)"2014-02-12T16:13:49.346540");
        timestamp = Swift.parseLastModified((JSONObject)json);
        Assert.assertNotNull((Object)timestamp);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(timestamp);
        Assert.assertEquals((long)2014L, (long)cal.get(1));
        Assert.assertEquals((long)1L, (long)cal.get(2));
        Assert.assertEquals((long)12L, (long)cal.get(5));
        Assert.assertEquals((long)16L, (long)cal.get(11));
        Assert.assertEquals((long)13L, (long)cal.get(12));
        Assert.assertEquals((long)49L, (long)cal.get(13));
        Assert.assertEquals((long)346L, (long)cal.get(14));
        this.checkLastModified("2014-02-12T16:13:49.346540", cal.getTime());
        this.checkLastModified("2014-02-12T16:13:49.3460", cal.getTime());
        this.checkLastModified("2014-02-12T16:13:49.346", cal.getTime());
        cal.set(14, 340);
        this.checkLastModified("2014-02-12T16:13:49.34", cal.getTime());
        cal.set(14, 300);
        this.checkLastModified("2014-02-12T16:13:49.3", cal.getTime());
        cal.set(14, 0);
        this.checkLastModified("2014-02-12T16:13:49.", cal.getTime());
        this.checkLastModified("2014-02-12T16:13:49", cal.getTime());
    }

    private void checkLastModified(String last_modified_value, Date expected) {
        JSONObject json = new JSONObject();
        json.put("last_modified", (Object)last_modified_value);
        Date parsed = Swift.parseLastModified((JSONObject)json);
        Assert.assertEquals((Object)expected, (Object)parsed);
    }
}

