/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.providers.googledrive;

import java.util.Collection;
import net.netheos.pcsapi.bytesio.ByteSource;
import net.netheos.pcsapi.bytesio.MemoryByteSource;
import net.netheos.pcsapi.models.CFile;
import net.netheos.pcsapi.models.CFolder;
import net.netheos.pcsapi.models.CFolderContent;
import net.netheos.pcsapi.models.CPath;
import net.netheos.pcsapi.models.CUploadRequest;
import net.netheos.pcsapi.providers.MiscUtils;
import net.netheos.pcsapi.providers.StorageProviderFactory;
import net.netheos.pcsapi.providers.googledrive.GoogleDrive;
import net.netheos.pcsapi.storage.IStorageProvider;
import net.netheos.pcsapi.storage.StorageProvider;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class GoogleDriveTest {
    private IStorageProvider storage;

    @Before
    public void setUp() throws Exception {
        Collection<Object[]> providers = StorageProviderFactory.storageProviderFactory();
        for (Object[] prov : providers) {
            if (!(prov[0] instanceof GoogleDrive)) continue;
            this.storage = (StorageProvider)prov[0];
            break;
        }
        Assume.assumeThat((String)"GoogleDrive provider found", (Object)this.storage, (Matcher)CoreMatchers.notNullValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSharedFiles() throws Exception {
        CPath tempRootPath = null;
        try {
            tempRootPath = MiscUtils.generateTestPath(null);
            CFolderContent content = this.storage.listRootFolder();
            CFolder sharedFolder = null;
            for (CFile file : content) {
                if (!file.getPath().getBaseName().equals("a RW shared folder...")) continue;
                sharedFolder = (CFolder)file;
            }
            Assume.assumeTrue((String)"shared folder found", (sharedFolder != null ? 1 : 0) != 0);
            CPath sharedFilePath = sharedFolder.getPath().add("shared.jpg");
            byte[] data = MiscUtils.generateRandomByteArray(128000, null);
            this.storage.upload(new CUploadRequest(sharedFilePath, (ByteSource)new MemoryByteSource(data)));
            CFile file = this.storage.getFile(sharedFilePath);
            Assert.assertNotNull((Object)file);
            Assert.assertTrue((boolean)this.storage.delete(sharedFilePath));
            file = this.storage.getFile(sharedFilePath);
            Assert.assertNull((Object)file);
        }
        finally {
            if (tempRootPath != null) {
                this.storage.delete(tempRootPath);
            }
        }
    }
}

