/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.netheos.pcsapi.bytesio.ByteSink;
import net.netheos.pcsapi.bytesio.ByteSource;
import net.netheos.pcsapi.bytesio.MemoryByteSink;
import net.netheos.pcsapi.bytesio.MemoryByteSource;
import net.netheos.pcsapi.models.CBlob;
import net.netheos.pcsapi.models.CDownloadRequest;
import net.netheos.pcsapi.models.CFile;
import net.netheos.pcsapi.models.CFolderContent;
import net.netheos.pcsapi.models.CPath;
import net.netheos.pcsapi.models.CUploadRequest;
import net.netheos.pcsapi.providers.MiscUtils;
import net.netheos.pcsapi.providers.StorageProviderFactory;
import net.netheos.pcsapi.storage.IStorageProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class StressTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(StressTest.class);
    private static final long DURATION_ms = 60000L;
    private static final int NB_THREADS = 4;
    private final IStorageProvider storage;

    @Parameterized.Parameters
    public static Collection<Object[]> getTestsParameters() throws Exception {
        return StorageProviderFactory.storageProviderFactory();
    }

    public StressTest(IStorageProvider storage) {
        this.storage = storage;
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testCrud() {
        new CrudRunnable(this.storage).run();
    }

    @Test
    public void testMultiCrud() throws InterruptedException {
        MiscUtils.testInThreads(4, new CrudRunnable(this.storage));
    }

    private static class CrudRunnable
    implements Runnable {
        private final IStorageProvider storage;

        private CrudRunnable(IStorageProvider storage) {
            this.storage = storage;
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            LOGGER.info("Test starting time={}", (Object)start);
            long now = start;
            while (start <= now && now - start < 60000L) {
                LOGGER.info("============= Thread {} : (elapsed={} < {} ms) ================", new Object[]{Thread.currentThread().getName(), now - start, 60000L});
                CPath testRootPath = MiscUtils.generateTestPath(null);
                this.storage.getUserId();
                this.uploadAndCheckRandomFiles(this.storage, testRootPath);
                now = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void uploadAndCheckRandomFiles(IStorageProvider storage, CPath rootPath) {
            try {
                Random rnd = new Random();
                CPath tmpPath = new CPath(rootPath.getPathName());
                for (int i = 0; i < rnd.nextInt(4) + 1; ++i) {
                    CPath path = MiscUtils.generateTestPath(tmpPath);
                    if (rnd.nextInt(2) == 0) {
                        storage.createFolder(path);
                        if (rnd.nextInt(2) != 0) continue;
                        tmpPath = path;
                        continue;
                    }
                    rnd.setSeed(path.hashCode());
                    int fileSize = rnd.nextInt(1000) * rnd.nextInt(1000);
                    byte[] data = MiscUtils.generateRandomByteArray(fileSize, rnd);
                    CUploadRequest ur = new CUploadRequest(path, (ByteSource)new MemoryByteSource(data));
                    storage.upload(ur);
                }
                List<CBlob> allBlobs = this.recursivelyListBlobs(storage, rootPath);
                LOGGER.info("All uploaded blobs = {}", allBlobs);
                for (CBlob blob : allBlobs) {
                    rnd.setSeed(blob.getPath().hashCode());
                    int fileSize = rnd.nextInt(1000) * rnd.nextInt(1000);
                    Assert.assertEquals((long)blob.length(), (long)fileSize);
                    byte[] expectedData = MiscUtils.generateRandomByteArray(fileSize, rnd);
                    MemoryByteSink bsink = new MemoryByteSink();
                    CDownloadRequest dr = new CDownloadRequest(blob.getPath(), (ByteSink)bsink);
                    storage.download(dr);
                    Assert.assertTrue((boolean)Arrays.equals(expectedData, bsink.getData()));
                }
            }
            finally {
                storage.delete(rootPath);
            }
        }

        private List<CBlob> recursivelyListBlobs(IStorageProvider storage, CPath path) {
            ArrayList<CBlob> retList = new ArrayList<CBlob>();
            CFolderContent files = storage.listFolder(path);
            for (CFile file : files) {
                if (file.isBlob()) {
                    retList.add((CBlob)file);
                    continue;
                }
                retList.addAll(this.recursivelyListBlobs(storage, file.getPath()));
            }
            return retList;
        }

        public String toString() {
            return "StressTest runnable for " + this.storage.getProviderName();
        }
    }
}

