/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.providers;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import net.netheos.pcsapi.credentials.AppInfoFileRepository;
import net.netheos.pcsapi.credentials.AppInfoRepository;
import net.netheos.pcsapi.credentials.UserCredentialsFileRepository;
import net.netheos.pcsapi.credentials.UserCredentialsRepository;
import net.netheos.pcsapi.storage.StorageBuilder;
import net.netheos.pcsapi.storage.StorageFacade;
import net.netheos.pcsapi.utils.PcsUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageProviderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageProviderFactory.class);
    private static AppInfoRepository appRepo;
    private static UserCredentialsRepository credRepo;

    public static Collection<Object[]> storageProviderFactory() throws IOException {
        File appRepoFile;
        String path = System.getProperty("pcsapiRepositoryDir");
        if (path == null) {
            path = System.getenv("PCS_API_REPOSITORY_DIR");
        }
        if (path == null) {
            path = "../repositories";
        }
        File repository = new File(path);
        String providers = System.getProperty("pcsapiProviders");
        boolean allProviders = false;
        if (providers == null) {
            allProviders = true;
        }
        if (!(appRepoFile = new File(repository, "app_info_data.txt")).exists()) {
            LOGGER.warn("No app info file found for functional tests: {} Set PCS_API_REPOSITORY_DIR environment variable, or set pcsapiRepositoryDir system property", (Object)appRepoFile);
            LOGGER.warn("No functional test will be run");
            return Collections.EMPTY_LIST;
        }
        appRepo = new AppInfoFileRepository(appRepoFile);
        File credRepoFile = new File(repository, "user_credentials_data.txt");
        credRepo = new UserCredentialsFileRepository(credRepoFile);
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (String providerName : StorageFacade.getRegisteredProviders()) {
            if (!allProviders && !providers.contains(providerName)) continue;
            HttpClient httpClient = StorageProviderFactory.buildDedicatedHttpClient(providerName);
            StorageProviderFactory.addProvider(values, providerName, httpClient);
        }
        return values;
    }

    private static void addProvider(Collection<Object[]> values, String providerName, HttpClient optHttpClient) {
        StorageBuilder builder = StorageFacade.forProvider((String)providerName).setAppInfoRepository(appRepo, appRepo.get(providerName).getAppName()).setUserCredentialsRepository(credRepo, null);
        if (optHttpClient != null) {
            builder.setHttpClient(optHttpClient);
        }
        values.add(new Object[]{builder.build()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpClient buildDedicatedHttpClient(String providerName) throws IOException {
        if (providerName.equals("cloudme") && !PcsUtils.ANDROID) {
            try {
                KeyStore ks = KeyStore.getInstance("JKS");
                InputStream is = null;
                try {
                    is = StorageProviderFactory.class.getResourceAsStream("/cloudme.jks");
                    ks.load(is, "changeit".toCharArray());
                }
                finally {
                    PcsUtils.closeQuietly((Closeable)is);
                }
                SSLContext context = SSLContext.getInstance("TLS");
                TrustManagerFactory caTrustManagerFactory = TrustManagerFactory.getInstance("SunX509");
                caTrustManagerFactory.init(ks);
                context.init(null, caTrustManagerFactory.getTrustManagers(), null);
                SchemeRegistry schemeRegistry = new SchemeRegistry();
                schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)new PlainSocketFactory()));
                schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)new SSLSocketFactory(context)));
                PoolingClientConnectionManager cnxManager = new PoolingClientConnectionManager(schemeRegistry);
                return new DefaultHttpClient((ClientConnectionManager)cnxManager);
            }
            catch (GeneralSecurityException ex) {
                throw new UnsupportedOperationException("Can't configure HttpClient for Cloud Me", ex);
            }
        }
        return null;
    }
}

