/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Random;
import net.netheos.pcsapi.exceptions.CInvalidFileTypeException;
import net.netheos.pcsapi.models.CPath;
import net.netheos.pcsapi.storage.IStorageProvider;
import net.netheos.pcsapi.utils.PcsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiscUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MiscUtils.class);
    private static final long TIME_ALLOWED_DELTA_SEC = 120L;
    private static final String TEST_FOLDER_PREFIX = "/pcs_api_tmptest_";

    private MiscUtils() {
    }

    public static void assertDatetimeIsAlmostNow(Date date) {
        MiscUtils.assertDatetimesAlmostEquals(new Date(), date);
    }

    public static void assertDatetimesAlmostEquals(Date expected, Date actual) {
        long delta = expected.getTime() - actual.getTime();
        long diff = Math.abs(delta / 1000L);
        if (diff > 120L) {
            throw new AssertionError((Object)("Datetimes are very different : exp=" + expected + " actual=" + actual));
        }
    }

    public static void cleanupTestFolders(IStorageProvider storage) throws CInvalidFileTypeException {
        Collection rootContent = storage.listRootFolder().getPaths();
        for (CPath path : rootContent) {
            if (!path.getPathName().startsWith(TEST_FOLDER_PREFIX)) continue;
            LOGGER.info("Deleting old test folder: {}", (Object)path);
            storage.delete(path);
        }
    }

    public static CPath generateTestPath(CPath root) {
        String tempPathname = PcsUtils.randomString((int)6);
        CPath tempPath = root == null || root.isRoot() ? new CPath(TEST_FOLDER_PREFIX + tempPathname) : root.add(tempPathname);
        return tempPath;
    }

    public static byte[] generateRandomByteArray(int size, Random rnd) {
        if (rnd == null) {
            rnd = new Random();
        }
        byte[] data = new byte[size];
        rnd.nextBytes(data);
        return data;
    }

    public static void testInThreads(int nbThreads, Runnable r) throws InterruptedException {
        Thread[] threads = new Thread[nbThreads];
        ThreadExceptionCounter[] counters = new ThreadExceptionCounter[nbThreads];
        for (int i = 0; i < nbThreads; ++i) {
            threads[i] = new Thread(r);
            counters[i] = new ThreadExceptionCounter();
            threads[i].setUncaughtExceptionHandler(counters[i]);
            threads[i].start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
        LOGGER.info("==== threaded test execution summary ====");
        int totalThreadsInError = 0;
        for (int i = 0; i < nbThreads; ++i) {
            ThreadExceptionCounter counter = counters[i];
            if (counter.errors.isEmpty()) continue;
            ++totalThreadsInError;
            LOGGER.error("Errors in thread {} ({}):", (Object)threads[i], (Object)r);
            for (int k = 0; k < counter.errors.size(); ++k) {
                Throwable th = (Throwable)counter.errors.get(k);
                long timestamp = (Long)counter.timestamps.get(k);
                LOGGER.error("{} : {}", (Object)new Date(timestamp), (Object)th.toString());
            }
        }
        if (totalThreadsInError == 0) {
            LOGGER.info("No errors");
        }
        LOGGER.info("==== end threaded test execution ====");
        if (totalThreadsInError > 0) {
            throw new AssertionError((Object)(totalThreadsInError + " thread(s) have failed"));
        }
    }

    private static class ThreadExceptionCounter
    implements Thread.UncaughtExceptionHandler {
        private final List<Throwable> errors = new ArrayList<Throwable>();
        private final List<Long> timestamps = new ArrayList<Long>();

        private ThreadExceptionCounter() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable th) {
            LOGGER.error("Thread " + thread + " failed : " + th.getMessage(), th);
            this.errors.add(th);
            this.timestamps.add(System.currentTimeMillis());
        }
    }
}

