/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi.providers;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import net.netheos.pcsapi.bytesio.ByteSink;
import net.netheos.pcsapi.bytesio.ByteSource;
import net.netheos.pcsapi.bytesio.FileByteSink;
import net.netheos.pcsapi.bytesio.MemoryByteSink;
import net.netheos.pcsapi.bytesio.MemoryByteSource;
import net.netheos.pcsapi.bytesio.ProgressListener;
import net.netheos.pcsapi.bytesio.StdoutProgressListener;
import net.netheos.pcsapi.exceptions.CFileNotFoundException;
import net.netheos.pcsapi.exceptions.CInvalidFileTypeException;
import net.netheos.pcsapi.exceptions.CRetriableException;
import net.netheos.pcsapi.models.CBlob;
import net.netheos.pcsapi.models.CDownloadRequest;
import net.netheos.pcsapi.models.CFile;
import net.netheos.pcsapi.models.CFolder;
import net.netheos.pcsapi.models.CFolderContent;
import net.netheos.pcsapi.models.CMetadata;
import net.netheos.pcsapi.models.CPath;
import net.netheos.pcsapi.models.CQuota;
import net.netheos.pcsapi.models.CUploadRequest;
import net.netheos.pcsapi.oauth.SessionManager;
import net.netheos.pcsapi.oauth.SessionManagerUtil;
import net.netheos.pcsapi.providers.MiscUtils;
import net.netheos.pcsapi.providers.StorageProviderFactory;
import net.netheos.pcsapi.storage.IStorageProvider;
import net.netheos.pcsapi.storage.StorageFacade;
import net.netheos.pcsapi.storage.StorageProvider;
import net.netheos.pcsapi.utils.PcsUtils;
import org.apache.commons.io.FileUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class BasicTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicTest.class);
    private File tmpDir;
    private final IStorageProvider storage;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> getTestsParameters() throws Exception {
        return StorageProviderFactory.storageProviderFactory();
    }

    public BasicTest(IStorageProvider storage) {
        this.storage = storage;
        LOGGER.info("Will run tests with provider : {}", (Object)storage);
    }

    @Before
    public void setUp() throws Exception {
        this.tmpDir = File.createTempFile("pcs_api", ".dir");
        FileUtils.deleteQuietly((File)this.tmpDir);
        this.tmpDir.mkdirs();
    }

    @After
    public void tearDown() {
        FileUtils.deleteQuietly((File)this.tmpDir);
    }

    @Test
    public void testRegisteredProviders() {
        Set providerNames = StorageFacade.getRegisteredProviders();
        LOGGER.info("Registered providers in pcs_api: {}", (Object)providerNames);
        Assert.assertTrue((boolean)providerNames.contains("dropbox"));
        Assert.assertTrue((boolean)providerNames.contains("hubic"));
        Assert.assertTrue((boolean)providerNames.contains("googledrive"));
        Assert.assertTrue((boolean)providerNames.contains("cloudme"));
    }

    @Ignore
    @Test
    public void testCleanupStorageBeforeTests() throws Exception {
        MiscUtils.cleanupTestFolders(this.storage);
    }

    @Test
    public void testGetUserId() throws Exception {
        String userId = this.storage.getUserId();
        LOGGER.info("Retrieved from provider {} : user_id = {}", (Object)this.storage.getProviderName(), (Object)userId);
        SessionManager sm = ((StorageProvider)this.storage).getSessionManager();
        String expectedUserId = SessionManagerUtil.getUserCredentials(sm).getUserId();
        Assert.assertEquals((Object)expectedUserId, (Object)userId);
    }

    @Test
    public void testDisplayQuota() throws Exception {
        CQuota quota = this.storage.getQuota();
        LOGGER.info("Retrieved quota for provider {}: {} ({}% used)", new Object[]{this.storage.getProviderName(), quota, Float.valueOf(quota.getPercentUsed())});
    }

    @Test
    public void testQuotaChangedAfterUpload() throws Exception {
        Assume.assumeThat((String)("quota not updated in real time for provider " + this.storage.getProviderName()), (Object)this.storage.getProviderName(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"hubic")));
        Assume.assumeThat((String)("quota not updated in real time for provider " + this.storage.getProviderName()), (Object)this.storage.getProviderName(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"googledrive")));
        CQuota quotaBefore = this.storage.getQuota();
        LOGGER.info("Quota BEFORE upload ({} provider) : used={} / total={}", new Object[]{this.storage.getProviderName(), quotaBefore.getBytesUsed(), quotaBefore.getBytesAllowed()});
        int fileSize = 500000;
        CPath path = MiscUtils.generateTestPath(null);
        LOGGER.info("Uploading blob with size {} bytes to {}", (Object)fileSize, (Object)path);
        byte[] content = MiscUtils.generateRandomByteArray(fileSize, null);
        CUploadRequest uploadRequest = new CUploadRequest(path, (ByteSource)new MemoryByteSource(content));
        this.storage.upload(uploadRequest);
        CFile cblob = this.storage.getFile(path);
        Assert.assertThat((String)"uploaded file exists", (Object)cblob, (Matcher)CoreMatchers.instanceOf(CBlob.class));
        Assert.assertEquals((long)fileSize, (long)((CBlob)cblob).length());
        LOGGER.info("Checking quota has changed");
        CQuota quotaAfter = this.storage.getQuota();
        this.storage.delete(path);
        LOGGER.info("Quota AFTER upload ({} provider) : used={} / total={}", new Object[]{this.storage.getProviderName(), quotaAfter.getBytesUsed(), quotaAfter.getBytesAllowed()});
        long usedDifference = quotaAfter.getBytesUsed() - quotaBefore.getBytesUsed();
        LOGGER.info("used bytes difference = {} (upload file size was {})", (Object)usedDifference, (Object)fileSize);
        Assert.assertEquals((long)fileSize, (long)usedDifference);
    }

    @Test
    public void testFileOperations() throws Exception {
        CPath tempRootPath = MiscUtils.generateTestPath(null);
        LOGGER.info("Will use test folder : {}", (Object)tempRootPath);
        CPath subPath = tempRootPath.add("sub_folder");
        LOGGER.info("Creating sub_folder : {}", (Object)subPath);
        Assert.assertTrue((boolean)this.storage.createFolder(subPath));
        Assert.assertFalse((boolean)this.storage.createFolder(subPath));
        CFile subFolder = this.storage.getFile(subPath);
        Assert.assertEquals((Object)subPath, (Object)subFolder.getPath());
        Assert.assertTrue((boolean)subFolder.isFolder());
        Assert.assertFalse((boolean)subFolder.isBlob());
        if (subFolder.getModificationDate() != null) {
            MiscUtils.assertDatetimeIsAlmostNow(subFolder.getModificationDate());
        }
        CPath fpath1 = subPath.add("a_test_file1");
        byte[] contentFile1 = "This is binary cont\u20acnt of test file 1...".getBytes(PcsUtils.UTF8);
        LOGGER.info("Uploading blob to : {}", (Object)fpath1);
        CUploadRequest uploadRequest = new CUploadRequest(fpath1, (ByteSource)new MemoryByteSource(contentFile1));
        this.storage.upload(uploadRequest);
        CPath fpath2 = subPath.add("a_test_file2");
        byte[] contentFile2 = MiscUtils.generateRandomByteArray(500000, null);
        LOGGER.info("Uploading blob to : {}", (Object)fpath2);
        uploadRequest = new CUploadRequest(fpath2, (ByteSource)new MemoryByteSource(contentFile2));
        this.storage.upload(uploadRequest);
        CFile cblob = this.storage.getFile(fpath2);
        Assert.assertTrue((boolean)cblob.isBlob());
        Assert.assertFalse((boolean)cblob.isFolder());
        Assert.assertEquals((long)contentFile2.length, (long)((CBlob)cblob).length());
        MiscUtils.assertDatetimeIsAlmostNow(cblob.getModificationDate());
        cblob = this.storage.getFile(fpath1);
        Assert.assertTrue((boolean)cblob.isBlob());
        Assert.assertFalse((boolean)cblob.isFolder());
        Assert.assertEquals((long)contentFile1.length, (long)((CBlob)cblob).length());
        LOGGER.info("Downloading back and checking file : {}", (Object)fpath1);
        MemoryByteSink mbs = new MemoryByteSink();
        CDownloadRequest downloadRequest = new CDownloadRequest(fpath1, (ByteSink)mbs);
        this.storage.download(downloadRequest);
        Assert.assertArrayEquals((byte[])contentFile1, (byte[])mbs.getData());
        LOGGER.info("Downloading back and checking file ranges: {}", (Object)fpath1);
        downloadRequest.setRange(5L, -1L);
        this.storage.download(downloadRequest);
        Assert.assertArrayEquals((byte[])Arrays.copyOfRange(contentFile1, 5, contentFile1.length), (byte[])mbs.getData());
        downloadRequest.setRange(-1L, 5L);
        this.storage.download(downloadRequest);
        Assert.assertArrayEquals((byte[])Arrays.copyOfRange(contentFile1, contentFile1.length - 5, contentFile1.length), (byte[])mbs.getData());
        downloadRequest.setRange(2L, 5L);
        this.storage.download(downloadRequest);
        Assert.assertArrayEquals((byte[])Arrays.copyOfRange(contentFile1, 2, 7), (byte[])mbs.getData());
        LOGGER.info("Downloading back and checking file : {}", (Object)fpath2);
        downloadRequest = new CDownloadRequest(fpath2, (ByteSink)mbs);
        this.storage.download(downloadRequest);
        Assert.assertArrayEquals((byte[])contentFile2, (byte[])mbs.getData());
        LOGGER.info("Checking file overwrite : {}", (Object)fpath2);
        contentFile2 = MiscUtils.generateRandomByteArray(300000, null);
        uploadRequest = new CUploadRequest(fpath2, (ByteSource)new MemoryByteSource(contentFile2));
        this.storage.upload(uploadRequest);
        this.storage.download(downloadRequest);
        Assert.assertArrayEquals((byte[])contentFile2, (byte[])mbs.getData());
        LOGGER.info("Checking file overwrite with empty file: {}", (Object)fpath2);
        contentFile2 = new byte[]{};
        uploadRequest = new CUploadRequest(fpath2, (ByteSource)new MemoryByteSource(contentFile2));
        this.storage.upload(uploadRequest);
        this.storage.download(downloadRequest);
        Assert.assertArrayEquals((byte[])contentFile2, (byte[])mbs.getData());
        CPath subSubPath = subPath.add("a_sub_sub_folder");
        LOGGER.info("Creating sub_sub folder : {}", (Object)subSubPath);
        this.storage.createFolder(subSubPath);
        LOGGER.info("Check uploaded blobs and sub_sub_folder all appear in folder list");
        CFolderContent folderContent = this.storage.listFolder((CFolder)subFolder);
        LOGGER.info("sub_folder contains files : {}", (Object)folderContent);
        Assert.assertEquals((long)3L, (long)folderContent.size());
        Assert.assertTrue((boolean)folderContent.containsPath(fpath1));
        Assert.assertTrue((boolean)folderContent.getFile(fpath1).isBlob());
        Assert.assertFalse((boolean)folderContent.getFile(fpath1).isFolder());
        Assert.assertTrue((boolean)folderContent.containsPath(fpath2));
        Assert.assertTrue((boolean)folderContent.getFile(fpath2).isBlob());
        Assert.assertFalse((boolean)folderContent.getFile(fpath2).isFolder());
        Assert.assertTrue((boolean)folderContent.containsPath(subSubPath));
        Assert.assertFalse((boolean)folderContent.getFile(subSubPath).isBlob());
        Assert.assertTrue((boolean)folderContent.getFile(subSubPath).isFolder());
        LOGGER.info("Check that list of sub_sub folder is empty : {}", (Object)subSubPath);
        Assert.assertTrue((boolean)this.storage.listFolder(subSubPath).isEmpty());
        LOGGER.info("Check that listing content of a blob raises : {}", (Object)fpath1);
        try {
            this.storage.listFolder(fpath1);
            Assert.fail((String)"Listing a blob should raise");
        }
        catch (CInvalidFileTypeException ex) {
            Assert.assertEquals((Object)fpath1, (Object)ex.getPath());
            Assert.assertFalse((boolean)ex.isBlobExpected());
        }
        LOGGER.info("Delete file1 : {}", (Object)fpath1);
        Assert.assertTrue((boolean)this.storage.delete(fpath1));
        Assert.assertFalse((boolean)this.storage.delete(fpath1));
        LOGGER.info("Check file1 does not appear anymore in folder : {}", (Object)subFolder);
        Assert.assertFalse((boolean)this.storage.listFolder((CFolder)subFolder).containsPath(fpath1));
        Assert.assertNull((Object)this.storage.getFile(fpath1));
        LOGGER.info("Delete whole test folder : {}", (Object)tempRootPath);
        boolean ret = this.storage.delete(tempRootPath);
        Assert.assertTrue((boolean)ret);
        LOGGER.info("Deleting again returns False");
        ret = this.storage.delete(tempRootPath);
        Assert.assertFalse((boolean)ret);
        LOGGER.info("Listing a deleted folder returns None : {}", (Object)tempRootPath);
        Assert.assertNull((Object)this.storage.listFolder(tempRootPath));
        Assert.assertNull((Object)this.storage.getFile(tempRootPath));
    }

    @Test
    public void testCreateIntermediateFolders() {
        CPath tempRootPath = MiscUtils.generateTestPath(null);
        LOGGER.info("Will use test folder : {}", (Object)tempRootPath);
        CPath path = tempRootPath.add("sub1/sub2/sub3/sub4/sub5_folder");
        this.storage.createFolder(path);
        while (!path.isRoot()) {
            CFile file = this.storage.getFile(path);
            Assert.assertNotNull((Object)file);
            Assert.assertTrue((boolean)file.isFolder());
            path = path.getParent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlobContentType() throws Exception {
        Assume.assumeThat((String)"Dropbox ignores content type", (Object)this.storage.getProviderName(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"dropbox")));
        Assume.assumeThat((String)"Google Drive ignores content type", (Object)this.storage.getProviderName(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"googledrive")));
        Assume.assumeThat((String)"CloudMe ignores content type", (Object)this.storage.getProviderName(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"cloudme")));
        CPath tempRootPath = MiscUtils.generateTestPath(null);
        try {
            LOGGER.info("Will use test folder :{}", (Object)tempRootPath);
            CPath path = tempRootPath.add("uploaded_blob");
            byte[] data = "some content...".getBytes(PcsUtils.UTF8);
            String contentType = "text/plain; charset=Latin-1";
            CUploadRequest uploadRequest = new CUploadRequest(path, (ByteSource)new MemoryByteSource(data));
            uploadRequest.setContentType(contentType);
            this.storage.upload(uploadRequest);
            CFile file = this.storage.getFile(path);
            Assert.assertEquals((Object)contentType, (Object)((CBlob)file).getContentType());
            data = "some binary content...".getBytes(PcsUtils.UTF8);
            data[4] = 5;
            data[11] = -1;
            contentType = "application/octet-stream";
            uploadRequest = new CUploadRequest(path, (ByteSource)new MemoryByteSource(data));
            uploadRequest.setContentType(contentType);
            this.storage.upload(uploadRequest);
            file = this.storage.getFile(path);
            Assert.assertEquals((Object)contentType, (Object)((CBlob)file).getContentType());
        }
        finally {
            this.deleteQuietly(tempRootPath, this.storage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlobMetadata() throws Exception {
        Assume.assumeThat((String)"Dropbox ignores metadata", (Object)this.storage.getProviderName(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"dropbox")));
        Assume.assumeThat((String)"GoogleDrive ignores metadata", (Object)this.storage.getProviderName(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"googledrive")));
        Assume.assumeThat((String)"CloudMe ignores metadata", (Object)this.storage.getProviderName(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"cloudme")));
        CPath tempRootPath = MiscUtils.generateTestPath(null);
        try {
            LOGGER.info("Will use test folder : {}", (Object)tempRootPath);
            CPath path = tempRootPath.add("uploaded_blob.txt");
            byte[] data = "some content...".getBytes(PcsUtils.UTF8);
            CUploadRequest uploadRequest = new CUploadRequest(path, (ByteSource)new MemoryByteSource(data));
            CMetadata metadata = new CMetadata();
            metadata.put("foo", "this is foo...");
            try {
                metadata.put("bar", "1\u20ac la bi\u00e8re");
                Assert.fail((String)"Illegal character setted in metadata value");
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
            uploadRequest.setMetadata(metadata);
            this.storage.upload(uploadRequest);
            CFile file = this.storage.getFile(path);
            Assert.assertEquals((Object)file.getMetadata(), (Object)metadata);
        }
        finally {
            this.deleteQuietly(tempRootPath, this.storage);
        }
    }

    @Test
    public void testDeleteSingleFolder() throws Exception {
        CPath tempRootPath = MiscUtils.generateTestPath(null);
        LOGGER.info("Will use test folder : {}", (Object)tempRootPath);
        CPath fpatha = tempRootPath.add("a");
        CPath fpathab = tempRootPath.add("ab");
        this.storage.createFolder(fpatha);
        this.storage.createFolder(fpathab);
        Assert.assertTrue((boolean)this.storage.getFile(fpatha).isFolder());
        Assert.assertTrue((boolean)this.storage.getFile(fpathab).isFolder());
        CPath path = fpatha.add("uploaded_blob.txt");
        byte[] data = "some content...".getBytes(PcsUtils.UTF8);
        CUploadRequest uploadRequest = new CUploadRequest(path, (ByteSource)new MemoryByteSource(data));
        this.storage.upload(uploadRequest);
        this.storage.delete(fpatha);
        Assert.assertNull((Object)this.storage.getFile(fpatha));
        Assert.assertNull((Object)this.storage.getFile(path));
        Assert.assertTrue((boolean)this.storage.getFile(fpathab).isFolder());
        this.storage.delete(tempRootPath);
    }

    @Test
    public void testInvalidFileOperation() throws Exception {
        CPath tempRootPath = MiscUtils.generateTestPath(null);
        LOGGER.info("Will use test folder : {}", (Object)tempRootPath);
        CPath fpath1 = tempRootPath.add("a_test_file1");
        byte[] contentFile1 = "This is binary cont\u20acnt of test file 1...".getBytes(PcsUtils.UTF8);
        CUploadRequest uploadRequest = new CUploadRequest(fpath1, (ByteSource)new MemoryByteSource(contentFile1));
        this.storage.upload(uploadRequest);
        LOGGER.info("Created blob : {}", (Object)fpath1);
        CPath subFolder = tempRootPath.add("sub_folder");
        this.storage.createFolder(subFolder);
        LOGGER.info("Check that listing content of a blob raises : {}", (Object)fpath1);
        try {
            this.storage.listFolder(fpath1);
            Assert.fail((String)"Listing a blob should raise");
        }
        catch (CInvalidFileTypeException ex) {
            Assert.assertEquals((Object)fpath1, (Object)ex.getPath());
            Assert.assertFalse((boolean)ex.isBlobExpected());
        }
        LOGGER.info("Check that trying to download a folder raises : {}", (Object)subFolder);
        MemoryByteSink mbs = new MemoryByteSink();
        CDownloadRequest downloadRequest = new CDownloadRequest(subFolder, (ByteSink)mbs);
        try {
            this.storage.download(downloadRequest);
            Assert.fail((String)"Downloading a folder should raise");
        }
        catch (CInvalidFileTypeException ex) {
            Assert.assertEquals((Object)subFolder, (Object)ex.getPath());
            Assert.assertTrue((boolean)ex.isBlobExpected());
        }
        LOGGER.info("Check that we cannot create a folder over a blob : {}", (Object)fpath1);
        try {
            this.storage.createFolder(fpath1);
            Assert.fail((String)"Creating a folder over a blob should raise");
        }
        catch (CInvalidFileTypeException ex) {
            Assert.assertEquals((Object)fpath1, (Object)ex.getPath());
            Assert.assertFalse((boolean)ex.isBlobExpected());
        }
        LOGGER.info("Check we cannot upload over an existing folder : {}", (Object)subFolder);
        try {
            byte[] content = "some data...".getBytes(PcsUtils.UTF8);
            uploadRequest = new CUploadRequest(subFolder, (ByteSource)new MemoryByteSource(content));
            this.storage.upload(uploadRequest);
            Assert.fail((String)"Uploading over a folder should raise");
        }
        catch (CInvalidFileTypeException ex) {
            Assert.assertEquals((Object)subFolder, (Object)ex.getPath());
            Assert.assertTrue((boolean)ex.isBlobExpected());
        }
        LOGGER.info("Check that content of a never existed folder is None");
        CPath path = new CPath("/hope i did never exist (even for tests) !");
        Assert.assertNull((Object)this.storage.listFolder(path));
        LOGGER.info("Check that get_file() returns None is file does not exist");
        Assert.assertNull((Object)this.storage.getFile(path));
        LOGGER.info("Check that downloading a non-existing file raises");
        downloadRequest = new CDownloadRequest(path, (ByteSink)new MemoryByteSink());
        try {
            this.storage.download(downloadRequest);
            Assert.fail((String)"Downlad a non-existing blob should raise");
        }
        catch (CFileNotFoundException ex) {
            LOGGER.debug("Expected exception : {}", (Object)ex.toString());
            Assert.assertEquals((Object)path, (Object)ex.getPath());
        }
        this.storage.delete(tempRootPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateFolderOverBlob() throws Exception {
        CPath tempRootPath = MiscUtils.generateTestPath(null);
        LOGGER.info("Will use test folder : {}", (Object)tempRootPath);
        try {
            CPath fpath1 = tempRootPath.add("a_test_file1");
            byte[] contentFile1 = "This is binary cont\u20acnt of test file 1...".getBytes(PcsUtils.UTF8);
            CUploadRequest uploadRequest = new CUploadRequest(fpath1, (ByteSource)new MemoryByteSource(contentFile1));
            this.storage.upload(uploadRequest);
            LOGGER.info("Created blob : {}", (Object)fpath1);
            try {
                CPath path = fpath1.add("sub_folder1");
                LOGGER.info("Check we cannot create a folder when remote path traverses a blob : {}", (Object)path);
                this.storage.createFolder(path);
                Assume.assumeThat((String)"Creating folder when path contains a blob should raise: not supported by Dropbox", (Object)this.storage.getProviderName(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"dropbox")));
                Assert.fail((String)"Creating folder when path contains a blob should raise");
            }
            catch (CInvalidFileTypeException ex) {
                Assert.assertEquals((Object)fpath1, (Object)ex.getPath());
                Assert.assertFalse((boolean)ex.isBlobExpected());
            }
        }
        finally {
            this.deleteQuietly(tempRootPath, this.storage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImplicitCreateFolderOverBlob() throws Exception {
        CPath tempRootPath = MiscUtils.generateTestPath(null);
        LOGGER.info("Will use test folder : {}", (Object)tempRootPath);
        try {
            CPath fpath1 = tempRootPath.add("a_test_file1");
            byte[] contentFile1 = "This is binary cont\u20acnt of test file 1...".getBytes(PcsUtils.UTF8);
            CUploadRequest uploadRequest = new CUploadRequest(fpath1, (ByteSource)new MemoryByteSource(contentFile1));
            this.storage.upload(uploadRequest);
            LOGGER.info("Created blob : {}", (Object)fpath1);
            try {
                CPath path = fpath1.add("sub_file1");
                LOGGER.info("Check we cannot upload a blob when remote path traverses a blob : {}", (Object)path);
                byte[] content = "some data...".getBytes(PcsUtils.UTF8);
                uploadRequest = new CUploadRequest(path, (ByteSource)new MemoryByteSource(content));
                this.storage.upload(uploadRequest);
                Assume.assumeThat((String)"Uploading when path contains a blob should raise : not supported by Dropbox", (Object)this.storage.getProviderName(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"dropbox")));
                Assert.fail((String)"Uploading when path contains a blob should raise");
            }
            catch (CInvalidFileTypeException ex) {
                Assert.assertEquals((Object)fpath1, (Object)ex.getPath());
                Assert.assertFalse((boolean)ex.isBlobExpected());
            }
        }
        finally {
            this.deleteQuietly(tempRootPath, this.storage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileWithSpecialChars() throws Exception {
        CPath tempRootPath = MiscUtils.generateTestPath(null);
        try {
            CPath folderPath = tempRootPath.add("hum...\u00a0',;.:\u00a0!*%&~#{[|`_\u00e7^@ \u00a3\u20ac");
            Assert.assertTrue((boolean)this.storage.createFolder(folderPath));
            CFile fback = this.storage.getFile(folderPath);
            Assert.assertEquals((Object)folderPath, (Object)fback.getPath());
            Assert.assertTrue((boolean)fback.isFolder());
            Assert.assertFalse((boolean)fback.isBlob());
            CFolderContent rootTestContent = this.storage.listFolder(tempRootPath);
            Assert.assertTrue((boolean)rootTestContent.containsPath(folderPath));
            Assert.assertEquals((Object)folderPath, (Object)rootTestContent.getFile(folderPath).getPath());
            Assert.assertTrue((boolean)rootTestContent.getFile(folderPath).isFolder());
            Assert.assertFalse((boolean)rootTestContent.getFile(folderPath).isBlob());
            StringBuilder nameb = new StringBuilder("b");
            for (int i = 0; i < 30; ++i) {
                nameb.append(this.generateRandomBlobNameChar());
            }
            nameb.append("e");
            for (int nbBlobs = 0; nbBlobs < 10; ++nbBlobs) {
                int index = (int)(Math.random() * (double)(nameb.length() - 2)) + 1;
                nameb.setCharAt(index, this.generateRandomBlobNameChar());
                String blobName = nameb.toString();
                CPath blobPath = folderPath.add(blobName);
                LOGGER.info("Will upload file to path: {}", (Object)blobPath);
                String contentFileStr = "This is cont\u20acnt of test file : '" + blobName + "'";
                byte[] contentFile = contentFileStr.getBytes(PcsUtils.UTF8);
                CUploadRequest uploadRequest = new CUploadRequest(blobPath, (ByteSource)new MemoryByteSource(contentFile));
                uploadRequest.setContentType("text/plain ; charset=UTF-8");
                this.storage.upload(uploadRequest);
                CFile bback = this.storage.getFile(blobPath);
                Assert.assertEquals((Object)blobPath, (Object)bback.getPath());
                Assert.assertTrue((boolean)bback.isBlob());
                Assert.assertFalse((boolean)bback.isFolder());
                MemoryByteSink mbs = new MemoryByteSink();
                CDownloadRequest downloadRequest = new CDownloadRequest(blobPath, (ByteSink)mbs);
                this.storage.download(downloadRequest);
                Assert.assertArrayEquals((byte[])contentFile, (byte[])mbs.getData());
                CFolderContent foderContent = this.storage.listFolder(folderPath);
                Assert.assertTrue((boolean)foderContent.containsPath(blobPath));
                Assert.assertEquals((Object)blobPath, (Object)foderContent.getFile(blobPath).getPath());
                Assert.assertTrue((boolean)foderContent.getFile(blobPath).isBlob());
                Assert.assertFalse((boolean)foderContent.getFile(blobPath).isFolder());
            }
        }
        finally {
            this.deleteQuietly(tempRootPath, this.storage);
        }
    }

    private char generateRandomBlobNameChar() {
        char c;
        do {
            c = (char)(Math.random() * Math.random() * 200.0 + 32.0);
            if (!(Math.random() < 0.01)) continue;
            c = '\u20ac';
        } while (c >= '\u007f' && c < '\u00a0' || c == '/' || c == '\\' || c == '\"' && "cloudme".equals(this.storage.getProviderName()));
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbortDuringDownload() throws Exception {
        int fileSize = 500000;
        CPath path = MiscUtils.generateTestPath(null);
        LOGGER.info("Uploading blob with size {} bytes to {}", (Object)fileSize, (Object)path);
        try {
            LOGGER.info("Will upload a blob for download test ({} bytes) to {}", (Object)fileSize, (Object)path);
            byte[] content = MiscUtils.generateRandomByteArray(fileSize, null);
            CUploadRequest uploadRequest = new CUploadRequest(path, (ByteSource)new MemoryByteSource(content));
            this.storage.upload(uploadRequest);
            LOGGER.info("Will download this blob but fail during download...");
            File tempFile = new File(this.tmpDir, "back_from_provider");
            FileByteSink fbs = new FileByteSink(tempFile, false, true, false);
            TestAbortProgressListener pl = new TestAbortProgressListener(1, fileSize / 2, false);
            CDownloadRequest dr = new CDownloadRequest(path, (ByteSink)fbs).setProgressListener((ProgressListener)pl);
            try {
                this.storage.download(dr);
                Assert.fail((String)"Download should have failed !");
            }
            catch (Exception ex) {
                LOGGER.info("Download has failed (as expected)");
            }
            Assert.assertTrue((boolean)pl.isAborted());
            LOGGER.info("Check destination file does not exist : {}", (Object)tempFile.getPath());
            Assert.assertFalse((boolean)tempFile.exists());
        }
        finally {
            this.deleteQuietly(path, this.storage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbortTwiceDuringUpload() throws Exception {
        int fileSize = 500000;
        CPath path = MiscUtils.generateTestPath(null);
        LOGGER.info("Uploading blob with size {} bytes to {}", (Object)fileSize, (Object)path);
        try {
            LOGGER.info("Will upload a blob for test ({} bytes) to {}, but fail temporarily during first two uploads", (Object)fileSize, (Object)path);
            byte[] content = MiscUtils.generateRandomByteArray(fileSize, null);
            MemoryByteSource bs = new MemoryByteSource(content);
            TestAbortProgressListener pl = new TestAbortProgressListener(2, fileSize / 2, true);
            CUploadRequest uploadRequest = new CUploadRequest(path, (ByteSource)bs).setProgressListener((ProgressListener)pl);
            this.storage.upload(uploadRequest);
            CFile cfile = this.storage.getFile(path);
            Assert.assertThat((Object)cfile, (Matcher)CoreMatchers.instanceOf(CBlob.class));
            Assert.assertEquals((long)fileSize, (long)((CBlob)cfile).length());
        }
        finally {
            this.deleteQuietly(path, this.storage);
        }
    }

    private void deleteQuietly(CPath path, IStorageProvider storage) {
        if (path != null) {
            try {
                storage.delete(path);
            }
            catch (Throwable th) {
                LOGGER.warn("Error deleting file " + path, th);
            }
        }
    }

    private static class TestAbortProgressListener
    extends StdoutProgressListener {
        private final int nbFailsTotal;
        private final int limit;
        private final boolean retriableException;
        private int nbFailsCurrent;

        private TestAbortProgressListener(int nbFails, int offsetLimit, boolean retriableException) {
            this.nbFailsTotal = nbFails;
            this.limit = offsetLimit;
            this.retriableException = retriableException;
        }

        public void progress(long current) {
            super.progress(current);
            if (current >= (long)this.limit && this.nbFailsCurrent < this.nbFailsTotal) {
                ++this.nbFailsCurrent;
                RuntimeException ex = new RuntimeException("Test error to make up/download fail : " + this.nbFailsCurrent + "/" + this.nbFailsTotal);
                if (this.retriableException) {
                    ex = new CRetriableException((Throwable)ex);
                }
                throw ex;
            }
        }
    }
}

