/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import net.netheos.pcsapi.utils.URIBuilder;
import net.netheos.pcsapi.utils.URIUtil;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(UriTest.class);

    @Test
    public void testGetQueryParameter() throws Exception {
        String url = "http://www.host.net/path/test?code=edc&test=1212";
        URI uri = new URI(url);
        Assert.assertEquals((Object)"edc", (Object)URIUtil.getQueryParameter((URI)uri, (String)"code"));
        Assert.assertNull((Object)URIUtil.getQueryParameter((URI)uri, (String)"cod"));
        uri = URI.create("http://www.host.net/path/test?code=edc+1&null&empty=&q=with+an+%26&test=%22foo+bar%E2%82%AC%22");
        Assert.assertEquals((Object)"edc 1", (Object)URIUtil.getQueryParameter((URI)uri, (String)"code"));
        Assert.assertNull((Object)URIUtil.getQueryParameter((URI)uri, (String)"null"));
        Assert.assertEquals((Object)"", (Object)URIUtil.getQueryParameter((URI)uri, (String)"empty"));
        Assert.assertEquals((Object)"\"foo bar\u20ac\"", (Object)URIUtil.getQueryParameter((URI)uri, (String)"test"));
        Assert.assertEquals((Object)"with an &", (Object)URIUtil.getQueryParameter((URI)uri, (String)"q"));
    }

    @Test
    public void testParseQueryParameters() throws Exception {
        URI uri = URI.create("https://localhost/?a&b=&c=%22");
        Map params = URIUtil.parseQueryParameters((String)uri.getRawQuery());
        Assert.assertTrue((boolean)params.containsKey("a"));
        Assert.assertNull(params.get("a"));
        Assert.assertEquals((Object)"", params.get("b"));
        Assert.assertEquals((Object)"\"", params.get("c"));
        params = URIUtil.parseQueryParameters((String)"");
        Assert.assertEquals((long)0L, (long)params.size());
        params = URIUtil.parseQueryParameters(null);
        Assert.assertEquals((long)0L, (long)params.size());
    }

    @Test
    public void testURIBuilder() throws Exception {
        String url = "http://www.host.net/path/test/";
        URI uri = new URI(url);
        URIBuilder builder = new URIBuilder(uri);
        Assert.assertEquals((Object)uri, (Object)builder.build());
        builder.encodedPath("/b/c");
        Assert.assertEquals((Object)new URI("http://www.host.net/path/test/b/c"), (Object)builder.build());
        builder.encodedPath("d");
        Assert.assertEquals((Object)new URI("http://www.host.net/path/test/b/c/d"), (Object)builder.build());
        builder.encodedPath("/e/");
        Assert.assertEquals((Object)new URI("http://www.host.net/path/test/b/c/d/e/"), (Object)builder.build());
        builder.encodedPath("/f");
        Assert.assertEquals((Object)new URI("http://www.host.net/path/test/b/c/d/e/f"), (Object)builder.build());
        builder.encodedPath("/");
        Assert.assertEquals((Object)new URI("http://www.host.net/path/test/b/c/d/e/f/"), (Object)builder.build());
        url = "https://user@www.host.net";
        uri = new URI(url);
        builder = new URIBuilder(uri);
        Assert.assertEquals((Object)uri, (Object)builder.build());
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("param1", "value1");
        params.put("par\u00e0m2", "va lu\u20ac2 ");
        builder.queryParameters(params);
        Assert.assertEquals((Object)new URI("https://user@www.host.net?param1=value1&par%C3%A0m2=va+lu%E2%82%AC2+"), (Object)builder.build());
        builder.encodedPath("");
        Assert.assertEquals((Object)new URI("https://user@www.host.net?param1=value1&par%C3%A0m2=va+lu%E2%82%AC2+"), (Object)builder.build());
        uri = URI.create("http://host?p1&p2=&p3");
        builder = new URIBuilder(uri);
        Assert.assertEquals((Object)uri, (Object)builder.build());
        builder.addParameter("p4", null);
        Assert.assertEquals((Object)uri, (Object)builder.build());
        builder.addParameter("p5", "value");
        Assert.assertEquals((Object)URI.create("http://host?p1&p2=&p3&p5=value"), (Object)builder.build());
        builder.addNullParameter("p6");
        Assert.assertEquals((Object)URI.create("http://host?p1&p2=&p3&p5=value&p6"), (Object)builder.build());
        builder.addParameter("p7", "");
        Assert.assertEquals((Object)URI.create("http://host?p1&p2=&p3&p5=value&p6&p7="), (Object)builder.build());
        builder.queryParameters(params);
        Assert.assertEquals((Object)new URI("http://host?param1=value1&par%C3%A0m2=va+lu%E2%82%AC2+"), (Object)builder.build());
    }
}

