/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.netheos.pcsapi.bytesio.ByteSink;
import net.netheos.pcsapi.bytesio.ByteSinkStream;
import net.netheos.pcsapi.bytesio.ByteSource;
import net.netheos.pcsapi.bytesio.MemoryByteSink;
import net.netheos.pcsapi.bytesio.MemoryByteSource;
import net.netheos.pcsapi.bytesio.ProgressByteSink;
import net.netheos.pcsapi.bytesio.ProgressByteSource;
import net.netheos.pcsapi.bytesio.ProgressListener;
import net.netheos.pcsapi.bytesio.StdoutProgressListener;
import net.netheos.pcsapi.models.CDownloadRequest;
import net.netheos.pcsapi.models.CPath;
import net.netheos.pcsapi.models.CUploadRequest;
import net.netheos.pcsapi.utils.PcsUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelsTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelsTest.class);

    @Test
    public void testCPath() {
        CPath path = new CPath("/foo//bar\u20ac/");
        Assert.assertEquals((Object)"/foo/bar\u20ac", (Object)path.getPathName());
        Assert.assertEquals((Object)"/foo/bar%E2%82%AC", (Object)path.getUrlEncoded());
        Assert.assertEquals((Object)"bar\u20ac", (Object)path.getBaseName());
        Assert.assertEquals((Object)new CPath("/foo"), (Object)path.getParent());
        Assert.assertEquals((Object)path.add("a,file..."), (Object)new CPath("/foo/bar\u20ac/a,file..."));
        Assert.assertEquals((Object)path.add("/a,file..."), (Object)new CPath("/foo/bar\u20ac/a,file..."));
        Assert.assertEquals((Object)path.add("a,file.../"), (Object)new CPath("/foo/bar\u20ac/a,file..."));
        Assert.assertEquals((Object)path.add("/several//folders/he re/"), (Object)new CPath("/foo/bar\u20ac/several/folders/he re"));
        Assert.assertFalse((boolean)path.isRoot());
        Assert.assertFalse((boolean)path.getParent().isRoot());
        CPath root = path.getParent().getParent();
        Assert.assertTrue((boolean)root.isRoot());
        Assert.assertTrue((boolean)root.getParent().isRoot());
        Assert.assertEquals((Object)root, (Object)new CPath("/"));
        Assert.assertEquals((Object)root, (Object)new CPath(""));
        Assert.assertEquals((Object)root.getBaseName(), (Object)"");
        Assert.assertEquals((Object)Collections.EMPTY_LIST, (Object)root.split());
        Assert.assertEquals((Object)Collections.EMPTY_LIST, (Object)new CPath("").split());
        Assert.assertEquals(Collections.singletonList("a"), (Object)new CPath("/a").split());
        LinkedList<String> expected = new LinkedList<String>();
        expected.add("alpha");
        expected.add("\"beta");
        Assert.assertEquals(expected, (Object)new CPath("/alpha/\"beta").split());
    }

    @Test
    public void testCPathAsKey() {
        HashMap<CPath, String> adict = new HashMap<CPath, String>();
        adict.put(new CPath("/a"), "file_a");
        adict.put(new CPath("/a/b"), "file_b");
        Assert.assertTrue((boolean)adict.containsKey(new CPath("/a")));
        Assert.assertEquals((Object)"file_a", adict.get(new CPath("/a")));
        Assert.assertTrue((boolean)adict.containsKey(new CPath("/a/b")));
        Assert.assertEquals((Object)"file_b", adict.get(new CPath("/a/b")));
        Assert.assertFalse((boolean)adict.containsKey(new CPath("/b")));
    }

    @Test
    public void testInvalidCPath() {
        List<String> pathnames = Arrays.asList("\\no anti-slash is allowed", "This is an inv\\u001Flid pathname !", "This is an \t invalid pathname !", "This/ is/an invalid pathname !", "This/is /also an invalid pathname !", " bad", "bad ");
        for (String pathname : pathnames) {
            try {
                LOGGER.info("Checking CPath is invalid : {}", (Object)pathname);
                new CPath(pathname);
                Assert.fail((String)("CPath creation should have failed for pathname='" + pathname + "'"));
            }
            catch (IllegalArgumentException ex) {
                LOGGER.info("CPath validation failed as expected: {}", (Object)ex.getMessage());
            }
        }
    }

    @Test
    public void testCPathUrlEncoded() {
        Assert.assertEquals((Object)"/a%20%2B%25b/c", (Object)new CPath("/a +%b/c").getUrlEncoded());
        Assert.assertEquals((Object)"/a%3Ab", (Object)new CPath("/a:b").getUrlEncoded());
        Assert.assertEquals((Object)"/%E2%82%AC", (Object)new CPath("/\u20ac").getUrlEncoded());
    }

    @Test
    public void testDownloadRequestBytesRange() {
        CDownloadRequest dr = new CDownloadRequest(new CPath("/foo"), (ByteSink)new MemoryByteSink());
        Assert.assertFalse((boolean)dr.getHttpHeaders().contains("Range"));
        dr.setRange(-1L, 100L);
        Assert.assertTrue((boolean)dr.getHttpHeaders().contains("Range"));
        Assert.assertEquals((Object)"bytes=-100", (Object)dr.getHttpHeaders().getHeaderValue("Range"));
        dr.setRange(10L, 100L);
        Assert.assertEquals((Object)"bytes=10-109", (Object)dr.getHttpHeaders().getHeaderValue("Range"));
        dr.setRange(0L, -1L);
        Assert.assertEquals((Object)"bytes=0-", (Object)dr.getHttpHeaders().getHeaderValue("Range"));
        dr.setRange(100L, -1L);
        Assert.assertEquals((Object)"bytes=100-", (Object)dr.getHttpHeaders().getHeaderValue("Range"));
        dr.setRange(-1L, -1L);
        Assert.assertFalse((boolean)dr.getHttpHeaders().contains("Range"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDownloadRequestProgressListener() throws Exception {
        MemoryByteSink mbs = new MemoryByteSink();
        CDownloadRequest dr = new CDownloadRequest(new CPath("/foo"), (ByteSink)mbs);
        Assert.assertSame((Object)mbs, (Object)dr.getByteSink());
        StdoutProgressListener pl = new StdoutProgressListener();
        dr.setProgressListener((ProgressListener)pl);
        ByteSink bs = dr.getByteSink();
        Assert.assertThat((Object)bs, (Matcher)CoreMatchers.instanceOf(ProgressByteSink.class));
        ByteSinkStream os = bs.openStream();
        try {
            os.write(65);
            os.flush();
            Assert.assertEquals((long)1L, (long)pl.getCurrent());
        }
        finally {
            PcsUtils.closeQuietly((Closeable)os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUploadRequestProgressListener() throws Exception {
        byte[] data = "content".getBytes("UTF-8");
        MemoryByteSource mbs = new MemoryByteSource(data);
        CUploadRequest ur = new CUploadRequest(new CPath("/foo"), (ByteSource)mbs);
        Assert.assertSame((Object)mbs, (Object)ur.getByteSource());
        StdoutProgressListener pl = new StdoutProgressListener();
        ur.setProgressListener((ProgressListener)pl);
        ByteSource bs = ur.getByteSource();
        Assert.assertThat((Object)bs, (Matcher)CoreMatchers.instanceOf(ProgressByteSource.class));
        InputStream is = bs.openStream();
        try {
            is.read();
            Assert.assertEquals((long)1L, (long)pl.getCurrent());
        }
        finally {
            PcsUtils.closeQuietly((Closeable)is);
        }
    }
}

