/*
 * Decompiled with CFR 0.152.
 */
package net.netheos.pcsapi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import net.netheos.pcsapi.bytesio.ByteSink;
import net.netheos.pcsapi.bytesio.ByteSinkStream;
import net.netheos.pcsapi.bytesio.ByteSource;
import net.netheos.pcsapi.bytesio.FileByteSink;
import net.netheos.pcsapi.bytesio.FileByteSource;
import net.netheos.pcsapi.bytesio.MemoryByteSink;
import net.netheos.pcsapi.bytesio.MemoryByteSource;
import net.netheos.pcsapi.bytesio.ProgressByteSink;
import net.netheos.pcsapi.bytesio.ProgressByteSource;
import net.netheos.pcsapi.bytesio.ProgressListener;
import net.netheos.pcsapi.bytesio.RangeByteSource;
import net.netheos.pcsapi.bytesio.StdoutProgressListener;
import net.netheos.pcsapi.utils.PcsUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytesIOTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(BytesIOTest.class);
    private File tmpDir;

    @Before
    public void setUp() throws Exception {
        this.tmpDir = File.createTempFile("pcs_api", ".dir");
        this.tmpDir.delete();
        this.tmpDir.mkdirs();
    }

    @After
    public void tearDown() {
        FileUtils.deleteQuietly((File)this.tmpDir);
    }

    @Test
    public void testFileByteSource() throws Exception {
        String strContent = "This 1\u20ac file is the test content of a file byte source... (70 bytes)";
        byte[] byteContent = strContent.getBytes(PcsUtils.UTF8);
        File tmpFile = new File(this.tmpDir, "byte_source.txt");
        FileUtils.writeByteArrayToFile((File)tmpFile, (byte[])byteContent);
        FileByteSource bs = new FileByteSource(tmpFile);
        this.checkByteSource((ByteSource)bs, byteContent);
        bs = new MemoryByteSource(byteContent);
        this.checkByteSource((ByteSource)bs, byteContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkByteSource(ByteSource bs, byte[] expectedContent) throws IOException {
        Assert.assertEquals((long)70L, (long)bs.length());
        InputStream is = bs.openStream();
        byte[] b = IOUtils.toByteArray((InputStream)is);
        Assert.assertTrue((boolean)Arrays.equals(expectedContent, b));
        is.close();
        RangeByteSource rbs = new RangeByteSource(bs, 5L, 25L);
        Assert.assertEquals((long)25L, (long)rbs.length());
        is = rbs.openStream();
        try {
            b = new byte[1];
            is.read(b);
            Assert.assertEquals((Object)"1", (Object)new String(b, PcsUtils.UTF8));
            b = new byte[3];
            is.read(b);
            Assert.assertEquals((Object)"\u20ac", (Object)new String(b, PcsUtils.UTF8));
            b = new byte[100];
            int len = is.read(b);
            Assert.assertEquals((long)21L, (long)len);
            String actual = new String(b, 0, 21, PcsUtils.UTF8);
            Assert.assertEquals((Object)" file is the test con", (Object)actual);
            b = new byte[100];
            len = is.read(b);
            Assert.assertEquals((long)0L, (long)len);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        StdoutProgressListener pl = new StdoutProgressListener();
        ProgressByteSource pbs = new ProgressByteSource((ByteSource)rbs, (ProgressListener)pl);
        Assert.assertEquals((long)rbs.length(), (long)pbs.length());
        is = pbs.openStream();
        try {
            Assert.assertEquals((long)pbs.length(), (long)pl.getTotal());
            Assert.assertEquals((long)0L, (long)pl.getCurrent());
            Assert.assertFalse((boolean)pl.isAborted());
            b = new byte[1];
            is.read(b);
            Assert.assertEquals((long)1L, (long)pl.getCurrent());
            b = new byte[10];
            is.read(b);
            Assert.assertEquals((long)11L, (long)pl.getCurrent());
            b = new byte[500];
            int len = is.read(b);
            Assert.assertEquals((long)14L, (long)len);
            Assert.assertEquals((long)25L, (long)pl.getCurrent());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    @Test
    public void testFileByteSink() throws Exception {
        String strContent = "This 1\u20ac file is the test content of a file byte source... (70 bytes)";
        byte[] byteContent = strContent.getBytes(PcsUtils.UTF8);
        File tmpFile = new File(this.tmpDir, "byte_sink.txt");
        FileUtils.writeByteArrayToFile((File)tmpFile, (byte[])byteContent);
        this.checkFileByteSinkAllFlags(tmpFile, byteContent);
        this.checkMemoryByteSink(byteContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMemoryByteSink(byte[] byteContent) throws IOException {
        MemoryByteSink sink = new MemoryByteSink();
        ByteSinkStream stream = sink.openStream();
        try {
            stream.write(byteContent);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)stream);
        }
        byte[] storedData = sink.getData();
        Assert.assertTrue((boolean)Arrays.equals(storedData, byteContent));
    }

    private void checkFileByteSinkAllFlags(File file, byte[] byteContent) throws IOException {
        List<Boolean> booleans = Arrays.asList(true, false);
        for (boolean abort : booleans) {
            for (boolean tempNameDuringWrites : booleans) {
                for (boolean deleteOnAbort : booleans) {
                    LOGGER.debug("checkFileByteSinkAllFlags - abort: {} - tempName : {} - deleteOnAbort : {} ", new Object[]{abort, tempNameDuringWrites, deleteOnAbort});
                    FileByteSink fbs = new FileByteSink(file, tempNameDuringWrites, deleteOnAbort, false);
                    this.checkFileByteSink(byteContent, abort, (ByteSink)fbs, file, tempNameDuringWrites, deleteOnAbort);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFileByteSink(byte[] dataToWrite, boolean abort, ByteSink fbs, File file, boolean withTempName, boolean deleteOnAbort) throws IOException {
        File actualFile = file;
        if (withTempName) {
            actualFile = new File(file.getPath() + ".part");
        }
        ByteSinkStream stream = fbs.openStream();
        try {
            Assert.assertTrue((boolean)actualFile.exists());
            fbs.setExpectedLength((long)dataToWrite.length);
            stream.write(Arrays.copyOfRange(dataToWrite, 0, 10));
            stream.flush();
            Assert.assertEquals((long)10L, (long)actualFile.length());
            if (abort) {
                LOGGER.info("Aborting stream of byte sink !");
                stream.abort();
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)stream);
        }
        boolean fileStillExists = file.exists();
        boolean tempFileStillExists = actualFile.exists();
        if (!abort) {
            Assert.assertTrue((boolean)fileStillExists);
        } else {
            Assert.assertTrue((tempFileStillExists != deleteOnAbort ? 1 : 0) != 0);
        }
    }

    @Test
    public void testProgressByteSink() throws Exception {
        byte[] byteContent = "hello world !".getBytes(PcsUtils.UTF8);
        File testFile = new File(this.tmpDir, "byte_sink_progress.txt");
        FileByteSink fbs = new FileByteSink(testFile);
        this.checkProgressByteSink((ByteSink)fbs, byteContent);
        MemoryByteSink mbs = new MemoryByteSink();
        this.checkProgressByteSink((ByteSink)mbs, byteContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkProgressByteSink(ByteSink sink, byte[] byteContent) throws IOException {
        StdoutProgressListener pl = new StdoutProgressListener();
        ProgressByteSink pbs = new ProgressByteSink(sink, (ProgressListener)pl);
        ByteSinkStream stream = pbs.openStream();
        try {
            Assert.assertEquals((long)-1L, (long)pl.getTotal());
            Assert.assertEquals((long)0L, (long)pl.getCurrent());
            Assert.assertFalse((boolean)pl.isAborted());
            pbs.setExpectedLength((long)byteContent.length);
            Assert.assertEquals((long)byteContent.length, (long)pl.getTotal());
            stream.write(Arrays.copyOfRange(byteContent, 0, 1));
            Assert.assertEquals((long)1L, (long)pl.getCurrent());
            byte[] remaining = Arrays.copyOfRange(byteContent, 1, byteContent.length);
            stream.write(remaining);
            Assert.assertEquals((long)pl.getTotal(), (long)pl.getCurrent());
            stream.abort();
            Assert.assertTrue((boolean)stream.isAborted());
        }
        finally {
            IOUtils.closeQuietly((OutputStream)stream);
        }
    }
}

