/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fart.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraftforge.fart.internal.OptionalChangeTransformer;
import net.minecraftforge.fart.relocated.org.objectweb.asm.ClassVisitor;
import net.minecraftforge.fart.relocated.org.objectweb.asm.FieldVisitor;
import net.minecraftforge.fart.relocated.org.objectweb.asm.RecordComponentVisitor;

public class RecordFixer
extends OptionalChangeTransformer {
    public static final RecordFixer INSTANCE = new RecordFixer();

    private RecordFixer() {
        super(Fixer::new);
    }

    private static class Fixer
    extends OptionalChangeTransformer.ClassFixer {
        private Map<String, Entry> components;
        private boolean isRecord;
        private boolean hasRecordComponents;

        public Fixer(ClassVisitor parent) {
            super(parent);
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.isRecord = "java/lang/Record".equals(superName);
            if (this.isRecord && (access & 0x10000) == 0) {
                this.madeChange = true;
                access |= 0x10000;
            }
            super.visit(version, access, name, signature, superName, interfaces);
        }

        @Override
        public RecordComponentVisitor visitRecordComponent(String name, String descriptor, String signature) {
            this.hasRecordComponents = true;
            return super.visitRecordComponent(name, descriptor, signature);
        }

        @Override
        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
            if (this.isRecord && (access & 0x18) == 16) {
                int newAccess = access & 0xFFFFFFFA | 2;
                if (newAccess != access) {
                    this.madeChange = true;
                    access = newAccess;
                }
                if (this.components == null) {
                    this.components = new LinkedHashMap<String, Entry>();
                }
                this.components.put(name + descriptor, new Entry(name, descriptor, signature));
            }
            return super.visitField(access, name, descriptor, signature, value);
        }

        @Override
        public void visitEnd() {
            if (this.isRecord && !this.hasRecordComponents && this.components != null) {
                for (Entry entry : this.components.values()) {
                    this.visitRecordComponent(entry.name, entry.descriptor, entry.signature);
                    this.madeChange = true;
                }
            }
        }

        private static class Entry {
            private final String name;
            private final String descriptor;
            private final String signature;

            private Entry(String name, String descriptor, String signature) {
                this.name = name;
                this.descriptor = descriptor;
                this.signature = signature;
            }

            public String toString() {
                return "[Name: " + this.name + ", Desc: " + this.descriptor + ", Sig: " + this.signature + "]";
            }
        }
    }
}

