/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.resources.json.jsr310;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.apache.commons.lang3.StringUtils;

public class JDKLocalDateTimeDeserializer
extends JsonDeserializer<LocalDateTime> {
    public LocalDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String s = (String)jp.readValueAs(String.class);
        if (StringUtils.isNotBlank((CharSequence)s)) {
            try {
                return LocalDateTime.parse(s, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            }
            catch (DateTimeParseException ignored) {
                return LocalDateTime.ofInstant(Instant.parse(s), ZoneOffset.UTC);
            }
        }
        return null;
    }
}

