/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.resources.json.jsr310;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.apache.commons.lang3.StringUtils;

public class JDKLocalDateDeserializer
extends JsonDeserializer<LocalDate> {
    public LocalDate deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String s = (String)jp.readValueAs(String.class);
        return JDKLocalDateDeserializer.parse(s);
    }

    public static LocalDate parse(String s) {
        if (StringUtils.isNotBlank((CharSequence)s)) {
            try {
                return LocalDate.parse(s, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            }
            catch (DateTimeParseException ignored) {
                try {
                    return LocalDateTime.ofInstant(Instant.parse(s), ZoneOffset.UTC).toLocalDate();
                }
                catch (DateTimeParseException ignored2) {
                    return LocalDateTime.parse(s, DateTimeFormatter.ISO_LOCAL_DATE_TIME).toLocalDate();
                }
            }
        }
        return null;
    }
}

