/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Data;
import net.named_data.jndn.Face;
import net.named_data.jndn.ForwardingFlags;
import net.named_data.jndn.Interest;
import net.named_data.jndn.InterestFilter;
import net.named_data.jndn.Name;
import net.named_data.jndn.OnInterestCallback;
import net.named_data.jndn.OnRegisterFailed;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;

public class MemoryContentCache
implements OnInterestCallback {
    private final Face face_;
    private final double cleanupIntervalMilliseconds_;
    private double nextCleanupTime_;
    private final HashMap onDataNotFoundForPrefix_ = new HashMap();
    private final ArrayList registeredPrefixIdList_ = new ArrayList();
    private final ArrayList noStaleTimeCache_ = new ArrayList();
    private final ArrayList staleTimeCache_ = new ArrayList();
    private final Name.Component emptyComponent_ = new Name.Component();
    ArrayList pendingInterestTable_ = new ArrayList();
    OnInterestCallback storePendingInterestCallback_;

    public MemoryContentCache(Face face, double cleanupIntervalMilliseconds) {
        this.face_ = face;
        this.cleanupIntervalMilliseconds_ = cleanupIntervalMilliseconds;
        this.construct();
    }

    public MemoryContentCache(Face face) {
        this.face_ = face;
        this.cleanupIntervalMilliseconds_ = 1000.0;
        this.construct();
    }

    private void construct() {
        this.nextCleanupTime_ = Common.getNowMilliseconds() + this.cleanupIntervalMilliseconds_;
        this.storePendingInterestCallback_ = new OnInterestCallback(){

            @Override
            public void onInterest(Name localPrefix, Interest localInterest, Face localFace, long localInterestFilterId, InterestFilter localFilter) {
                MemoryContentCache.this.storePendingInterest(localInterest, localFace);
            }
        };
    }

    public final void registerPrefix(Name prefix, OnRegisterFailed onRegisterFailed, OnInterestCallback onDataNotFound, ForwardingFlags flags, WireFormat wireFormat) throws IOException, SecurityException {
        if (onDataNotFound != null) {
            this.onDataNotFoundForPrefix_.put(prefix.toUri(), onDataNotFound);
        }
        long registeredPrefixId = this.face_.registerPrefix(prefix, (OnInterestCallback)this, onRegisterFailed, flags, wireFormat);
        this.registeredPrefixIdList_.add(registeredPrefixId);
    }

    public final void registerPrefix(Name prefix, OnRegisterFailed onRegisterFailed, OnInterestCallback onDataNotFound, ForwardingFlags flags) throws IOException, SecurityException {
        this.registerPrefix(prefix, onRegisterFailed, onDataNotFound, flags, WireFormat.getDefaultWireFormat());
    }

    public final void registerPrefix(Name prefix, OnRegisterFailed onRegisterFailed, OnInterestCallback onDataNotFound) throws IOException, SecurityException {
        this.registerPrefix(prefix, onRegisterFailed, onDataNotFound, new ForwardingFlags(), WireFormat.getDefaultWireFormat());
    }

    public final void registerPrefix(Name prefix, OnRegisterFailed onRegisterFailed) throws IOException, SecurityException {
        this.registerPrefix(prefix, onRegisterFailed, null, new ForwardingFlags(), WireFormat.getDefaultWireFormat());
    }

    public final void unregisterAll() {
        for (int i = 0; i < this.registeredPrefixIdList_.size(); ++i) {
            this.face_.removeRegisteredPrefix((Long)this.registeredPrefixIdList_.get(i));
        }
        this.registeredPrefixIdList_.clear();
        this.onDataNotFoundForPrefix_.clear();
    }

    public final void add(Data data) {
        this.doCleanup();
        if (data.getMetaInfo().getFreshnessPeriod() >= 0.0) {
            int i;
            StaleTimeContent content = new StaleTimeContent(data);
            for (i = this.staleTimeCache_.size() - 1; i >= 0 && !(((StaleTimeContent)this.staleTimeCache_.get(i)).getStaleTimeMilliseconds() <= content.getStaleTimeMilliseconds()); --i) {
            }
            this.staleTimeCache_.add(i + 1, content);
        } else {
            this.noStaleTimeCache_.add(new Content(data));
        }
        double nowMilliseconds = Common.getNowMilliseconds();
        for (int i = this.pendingInterestTable_.size() - 1; i >= 0; --i) {
            PendingInterest pendingInterest = (PendingInterest)this.pendingInterestTable_.get(i);
            if (pendingInterest.isTimedOut(nowMilliseconds)) {
                this.pendingInterestTable_.remove(i);
                continue;
            }
            if (!pendingInterest.getInterest().matchesName(data.getName())) continue;
            try {
                pendingInterest.getFace().send(data.wireEncode());
            }
            catch (IOException ex) {
                Logger.getLogger(MemoryContentCache.class.getName()).log(Level.SEVERE, ex.getMessage());
                return;
            }
            this.pendingInterestTable_.remove(i);
        }
    }

    public final void storePendingInterest(Interest interest, Face face) {
        this.pendingInterestTable_.add(new PendingInterest(interest, face));
    }

    public final OnInterestCallback getStorePendingInterest() {
        return this.storePendingInterestCallback_;
    }

    @Override
    public final void onInterest(Name prefix, Interest interest, Face face, long interestFilterId, InterestFilter filter) {
        this.doCleanup();
        Name.Component selectedComponent = null;
        Blob selectedEncoding = null;
        int totalSize = this.staleTimeCache_.size() + this.noStaleTimeCache_.size();
        for (int i = 0; i < totalSize; ++i) {
            Content content = i < this.staleTimeCache_.size() ? (Content)this.staleTimeCache_.get(i) : (Content)this.noStaleTimeCache_.get(i - this.staleTimeCache_.size());
            if (!interest.matchesName(content.getName())) continue;
            if (interest.getChildSelector() < 0) {
                try {
                    face.send(content.getDataEncoding());
                }
                catch (IOException ex) {
                    Logger.getLogger(MemoryContentCache.class.getName()).log(Level.SEVERE, null, ex);
                }
                return;
            }
            Name.Component component = content.getName().size() > interest.getName().size() ? content.getName().get(interest.getName().size()) : this.emptyComponent_;
            boolean gotBetterMatch = false;
            if (selectedEncoding == null) {
                gotBetterMatch = true;
            } else if (interest.getChildSelector() == 0) {
                if (component.compare(selectedComponent) < 0) {
                    gotBetterMatch = true;
                }
            } else if (component.compare(selectedComponent) > 0) {
                gotBetterMatch = true;
            }
            if (!gotBetterMatch) continue;
            selectedComponent = component;
            selectedEncoding = content.getDataEncoding();
        }
        if (selectedEncoding != null) {
            try {
                face.send(selectedEncoding);
            }
            catch (IOException ex) {
                Logger.getLogger(MemoryContentCache.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            Object onDataNotFound = this.onDataNotFoundForPrefix_.get(prefix.toUri());
            if (onDataNotFound != null) {
                ((OnInterestCallback)onDataNotFound).onInterest(prefix, interest, face, interestFilterId, filter);
            }
        }
    }

    private void doCleanup() {
        double now = Common.getNowMilliseconds();
        if (now >= this.nextCleanupTime_) {
            while (this.staleTimeCache_.size() > 0 && ((StaleTimeContent)this.staleTimeCache_.get(0)).isStale(now)) {
                this.staleTimeCache_.remove(0);
            }
            this.nextCleanupTime_ = now + this.cleanupIntervalMilliseconds_;
        }
    }

    private static class PendingInterest {
        private final Interest interest_;
        private final Face face_;
        private final double timeoutTimeMilliseconds_;

        public PendingInterest(Interest interest, Face face) {
            this.interest_ = interest;
            this.face_ = face;
            this.timeoutTimeMilliseconds_ = this.interest_.getInterestLifetimeMilliseconds() >= 0.0 ? Common.getNowMilliseconds() + this.interest_.getInterestLifetimeMilliseconds() : -1.0;
        }

        public final Interest getInterest() {
            return this.interest_;
        }

        public final Face getFace() {
            return this.face_;
        }

        public final boolean isTimedOut(double nowMilliseconds) {
            return this.timeoutTimeMilliseconds_ >= 0.0 && nowMilliseconds >= this.timeoutTimeMilliseconds_;
        }
    }

    private class StaleTimeContent
    extends Content {
        private final double staleTimeMilliseconds_;

        public StaleTimeContent(Data data) {
            super(data);
            this.staleTimeMilliseconds_ = Common.getNowMilliseconds() + data.getMetaInfo().getFreshnessPeriod();
        }

        public final boolean isStale(double nowMilliseconds) {
            return this.staleTimeMilliseconds_ <= nowMilliseconds;
        }

        public final double getStaleTimeMilliseconds() {
            return this.staleTimeMilliseconds_;
        }
    }

    private class Content {
        private final Name name_;
        private final Blob dataEncoding_;

        public Content(Data data) {
            this.name_ = data.getName();
            this.dataEncoding_ = data.wireEncode();
        }

        public final Name getName() {
            return this.name_;
        }

        public final Blob getDataEncoding() {
            return this.dataEncoding_;
        }
    }
}

