/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.identity;

import net.named_data.jndn.Name;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.security.certificate.IdentityCertificate;
import net.named_data.jndn.security.identity.IdentityStorage;
import net.named_data.jndn.util.Blob;

public abstract class Sqlite3IdentityStorageBase
extends IdentityStorage {
    protected static final String SELECT_MASTER_ID_TABLE = "SELECT name FROM sqlite_master WHERE type='table' And name='Identity'";
    protected static final String SELECT_MASTER_KEY_TABLE = "SELECT name FROM sqlite_master WHERE type='table' And name='Key'";
    protected static final String SELECT_MASTER_CERT_TABLE = "SELECT name FROM sqlite_master WHERE type='table' And name='Certificate'";
    protected static final String INIT_ID_TABLE1 = "CREATE TABLE IF NOT EXISTS                                           \n  Identity(                                                          \n      identity_name     BLOB NOT NULL,                               \n      default_identity  INTEGER DEFAULT 0,                           \n                                                                     \n      PRIMARY KEY (identity_name)                                    \n  );                                                                 \n                                                                     \n";
    protected static final String INIT_ID_TABLE2 = "CREATE INDEX identity_index ON Identity(identity_name);              \n";
    protected static final String INIT_KEY_TABLE1 = "CREATE TABLE IF NOT EXISTS                                           \n  Key(                                                               \n      identity_name     BLOB NOT NULL,                               \n      key_identifier    BLOB NOT NULL,                               \n      key_type          INTEGER,                                     \n      public_key        BLOB,                                        \n      default_key       INTEGER DEFAULT 0,                           \n      active            INTEGER DEFAULT 0,                           \n                                                                     \n      PRIMARY KEY (identity_name, key_identifier)                    \n  );                                                                 \n                                                                     \n";
    protected static final String INIT_KEY_TABLE2 = "CREATE INDEX key_index ON Key(identity_name);                        \n";
    protected static final String INIT_CERT_TABLE1 = "CREATE TABLE IF NOT EXISTS                                           \n  Certificate(                                                       \n      cert_name         BLOB NOT NULL,                               \n      cert_issuer       BLOB NOT NULL,                               \n      identity_name     BLOB NOT NULL,                               \n      key_identifier    BLOB NOT NULL,                               \n      not_before        TIMESTAMP,                                   \n      not_after         TIMESTAMP,                                   \n      certificate_data  BLOB NOT NULL,                               \n      valid_flag        INTEGER DEFAULT 1,                           \n      default_cert      INTEGER DEFAULT 0,                           \n                                                                     \n      PRIMARY KEY (cert_name)                                        \n  );                                                                 \n                                                                     \n";
    protected static final String INIT_CERT_TABLE2 = "CREATE INDEX cert_index ON Certificate(cert_name);           \n";
    protected static final String INIT_CERT_TABLE3 = "CREATE INDEX subject ON Certificate(identity_name);          \n";
    protected static final String SELECT_doesIdentityExist = "SELECT count(*) FROM Identity WHERE identity_name=?";
    protected static final String SELECT_doesKeyExist = "SELECT count(*) FROM Key WHERE identity_name=? AND key_identifier=?";
    protected static final String SELECT_getKey = "SELECT public_key FROM Key WHERE identity_name=? AND key_identifier=?";
    protected static final String SELECT_doesCertificateExist = "SELECT count(*) FROM Certificate WHERE cert_name=?";
    protected static final String SELECT_getCertificate = "SELECT certificate_data FROM Certificate WHERE cert_name=?";
    protected static final String SELECT_getDefaultIdentity = "SELECT identity_name FROM Identity WHERE default_identity=1";
    protected static final String SELECT_getDefaultKeyNameForIdentity = "SELECT key_identifier FROM Key WHERE identity_name=? AND default_key=1";
    protected static final String SELECT_getDefaultCertificateNameForKey = "SELECT cert_name FROM Certificate WHERE identity_name=? AND key_identifier=? AND default_cert=1";
    protected static final String SELECT_getAllKeyNamesOfIdentity_default_true = "SELECT key_identifier FROM Key WHERE default_key=1 and identity_name=?";
    protected static final String SELECT_getAllKeyNamesOfIdentity_default_false = "SELECT key_identifier FROM Key WHERE default_key=0 and identity_name=?";
    protected static final String WHERE_updateKeyStatus = "identity_name=? AND key_identifier=?";
    protected static final String WHERE_setDefaultIdentity_reset = "default_identity=1";
    protected static final String WHERE_setDefaultIdentity_set = "identity_name=?";
    protected static final String WHERE_setDefaultKeyNameForIdentity_reset = "default_key=1 and identity_name=?";
    protected static final String WHERE_setDefaultKeyNameForIdentity_set = "identity_name=? AND key_identifier=?";
    protected static final String WHERE_setDefaultCertificateNameForKey_reset = "default_cert=1 AND identity_name=? AND key_identifier=?";
    protected static final String WHERE_setDefaultCertificateNameForKey_set = "identity_name=? AND key_identifier=? AND cert_name=?";
    protected static final String WHERE_deleteCertificateInfo = "cert_name=?";
    protected static final String WHERE_deletePublicKeyInfo = "identity_name=? and key_identifier=?";
    protected static final String WHERE_deleteIdentityInfo = "identity_name=?";

    @Override
    public final void activateKey(Name keyName) throws SecurityException {
        this.updateKeyStatus(keyName, true);
    }

    @Override
    public final void deactivateKey(Name keyName) throws SecurityException {
        this.updateKeyStatus(keyName, false);
    }

    protected abstract void updateKeyStatus(Name var1, boolean var2) throws SecurityException;

    protected void checkAddKey(Name keyName) throws SecurityException {
        if (this.doesKeyExist(keyName)) {
            throw new SecurityException("a key with the same name already exists!");
        }
    }

    protected void checkAddCertificate(IdentityCertificate certificate) throws SecurityException {
        Name certificateName = certificate.getName();
        Name keyName = certificate.getPublicKeyName();
        if (!this.doesKeyExist(keyName)) {
            throw new SecurityException("No corresponding Key record for certificate!" + keyName.toUri() + " " + certificateName.toUri());
        }
        if (this.doesCertificateExist(certificateName)) {
            throw new SecurityException("Certificate has already been installed!");
        }
        Blob keyBlob = this.getKey(keyName);
        if (keyBlob.isNull() || !keyBlob.equals(certificate.getPublicKeyInfo().getKeyDer())) {
            throw new SecurityException("Certificate does not match the public key!");
        }
    }

    protected void checkSetDefaultKeyNameForIdentity(Name keyName, Name identityNameCheck) throws SecurityException {
        Name identityName = keyName.getPrefix(-1);
        if (identityNameCheck.size() > 0 && !identityNameCheck.equals(identityName)) {
            throw new SecurityException("The specified identity name does not match the key name");
        }
    }
}

