/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.identity;

import java.util.ArrayList;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.KeyType;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.security.certificate.IdentityCertificate;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;

public abstract class IdentityStorage {
    private static long lastTimestamp_ = (long)Math.floor(Common.getNowMilliseconds());

    public abstract boolean doesIdentityExist(Name var1) throws SecurityException;

    public abstract void addIdentity(Name var1) throws SecurityException;

    public abstract boolean revokeIdentity() throws SecurityException;

    public final Name getNewKeyName(Name identityName, boolean useKsk) throws SecurityException {
        long timestamp;
        for (timestamp = (long)Math.floor(Common.getNowMilliseconds()); timestamp <= lastTimestamp_; ++timestamp) {
        }
        lastTimestamp_ = timestamp;
        String timeString = "" + timestamp;
        String keyIdStr = useKsk ? "ksk-" + timeString : "dsk-" + timeString;
        Name keyName = new Name(identityName).append(keyIdStr);
        if (this.doesKeyExist(keyName)) {
            throw new SecurityException("Key name already exists");
        }
        return keyName;
    }

    public abstract boolean doesKeyExist(Name var1) throws SecurityException;

    public abstract void addKey(Name var1, KeyType var2, Blob var3) throws SecurityException;

    public abstract Blob getKey(Name var1) throws SecurityException;

    public abstract void activateKey(Name var1) throws SecurityException;

    public abstract void deactivateKey(Name var1) throws SecurityException;

    public abstract boolean doesCertificateExist(Name var1) throws SecurityException;

    public abstract void addCertificate(IdentityCertificate var1) throws SecurityException;

    public abstract IdentityCertificate getCertificate(Name var1, boolean var2) throws SecurityException;

    public final IdentityCertificate getCertificate(Name certificateName) throws SecurityException {
        return this.getCertificate(certificateName, false);
    }

    public abstract Name getDefaultIdentity() throws SecurityException;

    public abstract Name getDefaultKeyNameForIdentity(Name var1) throws SecurityException;

    public final Name getDefaultCertificateNameForIdentity(Name identityName) throws SecurityException {
        Name keyName = this.getDefaultKeyNameForIdentity(identityName);
        return this.getDefaultCertificateNameForKey(keyName);
    }

    public abstract Name getDefaultCertificateNameForKey(Name var1) throws SecurityException;

    public abstract void getAllKeyNamesOfIdentity(Name var1, ArrayList var2, boolean var3) throws SecurityException;

    public abstract void setDefaultIdentity(Name var1) throws SecurityException;

    public abstract void setDefaultKeyNameForIdentity(Name var1, Name var2) throws SecurityException;

    public final void setDefaultKeyNameForIdentity(Name keyName) throws SecurityException {
        this.setDefaultKeyNameForIdentity(keyName, new Name());
    }

    public abstract void setDefaultCertificateNameForKey(Name var1, Name var2) throws SecurityException;

    public final IdentityCertificate getDefaultCertificate() throws SecurityException {
        Name certName;
        try {
            certName = this.getDefaultCertificateNameForIdentity(this.getDefaultIdentity());
        }
        catch (SecurityException ex) {
            return null;
        }
        return this.getCertificate(certName, true);
    }

    public abstract void deleteCertificateInfo(Name var1) throws SecurityException;

    public abstract void deletePublicKeyInfo(Name var1) throws SecurityException;

    public abstract void deleteIdentityInfo(Name var1) throws SecurityException;
}

