/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.certificate;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;
import net.named_data.jndn.encoding.der.DerDecodingException;
import net.named_data.jndn.encoding.der.DerNode;
import net.named_data.jndn.security.DigestAlgorithm;
import net.named_data.jndn.security.KeyType;
import net.named_data.jndn.security.UnrecognizedDigestAlgorithmException;
import net.named_data.jndn.security.UnrecognizedKeyFormatException;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;

public class PublicKey {
    private static String RSA_ENCRYPTION_OID = "1.2.840.113549.1.1.1";
    private static String EC_ENCRYPTION_OID = "1.2.840.10045.2.1";
    private final KeyType keyType_;
    private final Blob keyDer_;

    public PublicKey() {
        this.keyType_ = null;
        this.keyDer_ = new Blob();
    }

    public PublicKey(Blob keyDer) throws UnrecognizedKeyFormatException {
        KeyFactory keyFactory;
        this.keyDer_ = keyDer;
        String oidString = null;
        try {
            DerNode parsedNode = DerNode.parse(keyDer.buf(), 0);
            List rootChildren = parsedNode.getChildren();
            List algorithmIdChildren = DerNode.getSequence(rootChildren, 0).getChildren();
            oidString = "" + ((DerNode)algorithmIdChildren.get(0)).toVal();
        }
        catch (DerDecodingException ex) {
            throw new UnrecognizedKeyFormatException("PublicKey: Error decoding the public key: " + ex.getMessage());
        }
        if (oidString.equals(RSA_ENCRYPTION_OID)) {
            this.keyType_ = KeyType.RSA;
            keyFactory = null;
            try {
                keyFactory = KeyFactory.getInstance("RSA");
            }
            catch (NoSuchAlgorithmException exception) {
                throw new UnrecognizedKeyFormatException("RSA is not supported: " + exception.getMessage());
            }
            try {
                keyFactory.generatePublic(new X509EncodedKeySpec(keyDer.getImmutableArray()));
            }
            catch (InvalidKeySpecException exception) {
                throw new UnrecognizedKeyFormatException("X509EncodedKeySpec is not supported for RSA: " + exception.getMessage());
            }
        }
        if (oidString.equals(EC_ENCRYPTION_OID)) {
            this.keyType_ = KeyType.ECDSA;
            keyFactory = null;
            try {
                keyFactory = KeyFactory.getInstance("EC");
            }
            catch (NoSuchAlgorithmException exception) {
                throw new UnrecognizedKeyFormatException("EC is not supported: " + exception.getMessage());
            }
            try {
                keyFactory.generatePublic(new X509EncodedKeySpec(keyDer.getImmutableArray()));
            }
            catch (InvalidKeySpecException exception) {
                throw new UnrecognizedKeyFormatException("X509EncodedKeySpec is not supported for EC: " + exception.getMessage());
            }
        }
        throw new UnrecognizedKeyFormatException("PublicKey: Unrecognized OID " + oidString);
    }

    public final DerNode toDer() throws DerDecodingException {
        return DerNode.parse(this.keyDer_.buf());
    }

    public KeyType getKeyType() {
        return this.keyType_;
    }

    public final Blob getDigest(DigestAlgorithm digestAlgorithm) throws UnrecognizedDigestAlgorithmException {
        if (digestAlgorithm == DigestAlgorithm.SHA256) {
            return new Blob(Common.digestSha256(this.keyDer_.buf()));
        }
        throw new UnrecognizedDigestAlgorithmException("Wrong format!");
    }

    public final Blob getDigest() {
        try {
            return this.getDigest(DigestAlgorithm.SHA256);
        }
        catch (UnrecognizedDigestAlgorithmException ex) {
            throw new Error("UnrecognizedDigestAlgorithmException " + ex.getMessage());
        }
    }

    public final Blob getKeyDer() {
        return this.keyDer_;
    }
}

