/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encrypt.algo;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import net.named_data.jndn.encoding.der.DerDecodingException;
import net.named_data.jndn.encoding.der.DerNode;
import net.named_data.jndn.encrypt.DecryptKey;
import net.named_data.jndn.encrypt.EncryptKey;
import net.named_data.jndn.encrypt.algo.EncryptAlgorithmType;
import net.named_data.jndn.encrypt.algo.EncryptParams;
import net.named_data.jndn.security.RsaKeyParams;
import net.named_data.jndn.util.Blob;

public class RsaAlgorithm {
    private static final SecureRandom random_;
    private static KeyFactory keyFactory_;

    public static DecryptKey generateKey(RsaKeyParams params) throws NoSuchAlgorithmException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        generator.initialize(params.getKeySize());
        KeyPair pair = generator.generateKeyPair();
        return new DecryptKey(new Blob(pair.getPrivate().getEncoded()));
    }

    public static EncryptKey deriveEncryptKey(Blob keyBits) throws InvalidKeySpecException, DerDecodingException {
        DerNode parsedNode = DerNode.parse(keyBits.buf(), 0);
        List pkcs8Children = parsedNode.getChildren();
        List algorithmIdChildren = DerNode.getSequence(pkcs8Children, 1).getChildren();
        String oidString = ((DerNode.DerOid)algorithmIdChildren.get(0)).toVal().toString();
        Blob rsaPrivateKeyDer = ((DerNode)pkcs8Children.get(2)).getPayload();
        String RSA_ENCRYPTION_OID = "1.2.840.113549.1.1.1";
        if (!oidString.equals("1.2.840.113549.1.1.1")) {
            throw new DerDecodingException("The PKCS #8 private key is not RSA_ENCRYPTION");
        }
        parsedNode = DerNode.parse(rsaPrivateKeyDer.buf(), 0);
        List rsaPrivateKeyChildren = parsedNode.getChildren();
        Blob modulus = ((DerNode)rsaPrivateKeyChildren.get(1)).getPayload();
        Blob publicExponent = ((DerNode)rsaPrivateKeyChildren.get(2)).getPayload();
        PublicKey publicKey = keyFactory_.generatePublic(new RSAPublicKeySpec(new BigInteger(modulus.getImmutableArray()), new BigInteger(publicExponent.getImmutableArray())));
        return new EncryptKey(new Blob(publicKey.getEncoded()));
    }

    public static Blob decrypt(Blob keyBits, Blob encryptedData, EncryptParams params) throws InvalidKeySpecException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        String transformation;
        PrivateKey privateKey = keyFactory_.generatePrivate(new PKCS8EncodedKeySpec(keyBits.getImmutableArray()));
        if (params.getAlgorithmType() == EncryptAlgorithmType.RsaPkcs) {
            transformation = "RSA/ECB/PKCS1Padding";
        } else if (params.getAlgorithmType() == EncryptAlgorithmType.RsaOaep) {
            transformation = "RSA/ECB/OAEPWithSHA-1AndMGF1Padding";
        } else {
            throw new Error("unsupported padding scheme");
        }
        Cipher cipher = Cipher.getInstance(transformation);
        cipher.init(2, privateKey);
        return new Blob(cipher.doFinal(encryptedData.getImmutableArray()));
    }

    public static Blob encrypt(Blob keyBits, Blob plainData, EncryptParams params) throws InvalidKeySpecException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        String transformation;
        PublicKey publicKey = keyFactory_.generatePublic(new X509EncodedKeySpec(keyBits.getImmutableArray()));
        if (params.getAlgorithmType() == EncryptAlgorithmType.RsaPkcs) {
            transformation = "RSA/ECB/PKCS1Padding";
        } else if (params.getAlgorithmType() == EncryptAlgorithmType.RsaOaep) {
            transformation = "RSA/ECB/OAEPWithSHA-1AndMGF1Padding";
        } else {
            throw new Error("unsupported padding scheme");
        }
        Cipher cipher = Cipher.getInstance(transformation);
        cipher.init(1, publicKey);
        return new Blob(cipher.doFinal(plainData.getImmutableArray()));
    }

    static {
        try {
            keyFactory_ = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(RsaAlgorithm.class.getName()).log(Level.SEVERE, null, ex);
        }
        random_ = new SecureRandom();
    }
}

