/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encrypt.algo;

import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.named_data.jndn.encrypt.DecryptKey;
import net.named_data.jndn.encrypt.EncryptKey;
import net.named_data.jndn.encrypt.algo.EncryptAlgorithmType;
import net.named_data.jndn.encrypt.algo.EncryptParams;
import net.named_data.jndn.security.AesKeyParams;
import net.named_data.jndn.util.Blob;

public class AesAlgorithm {
    public static final int BLOCK_SIZE = 16;
    private static final SecureRandom random_ = new SecureRandom();

    public static DecryptKey generateKey(AesKeyParams params) {
        ByteBuffer key = ByteBuffer.allocate(params.getKeySize() / 8);
        random_.nextBytes(key.array());
        DecryptKey decryptKey = new DecryptKey(new Blob(key, false));
        return decryptKey;
    }

    public static EncryptKey deriveEncryptKey(Blob keyBits) {
        return new EncryptKey(keyBits);
    }

    public static Blob decrypt(Blob keyBits, Blob encryptedData, EncryptParams params) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        if (params.getAlgorithmType() == EncryptAlgorithmType.AesEcb) {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5PADDING");
            cipher.init(2, new SecretKeySpec(keyBits.getImmutableArray(), "AES"));
            return new Blob(cipher.doFinal(encryptedData.getImmutableArray()));
        }
        if (params.getAlgorithmType() == EncryptAlgorithmType.AesCbc) {
            if (params.getInitialVector().size() != 16) {
                throw new Error("incorrect initial vector size");
            }
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            cipher.init(2, (Key)new SecretKeySpec(keyBits.getImmutableArray(), "AES"), new IvParameterSpec(params.getInitialVector().getImmutableArray()));
            return new Blob(cipher.doFinal(encryptedData.getImmutableArray()));
        }
        throw new Error("unsupported encryption mode");
    }

    public static Blob encrypt(Blob keyBits, Blob plainData, EncryptParams params) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        if (params.getAlgorithmType() == EncryptAlgorithmType.AesEcb) {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5PADDING");
            cipher.init(1, new SecretKeySpec(keyBits.getImmutableArray(), "AES"));
            return new Blob(cipher.doFinal(plainData.getImmutableArray()));
        }
        if (params.getAlgorithmType() == EncryptAlgorithmType.AesCbc) {
            if (params.getInitialVector().size() != 16) {
                throw new Error("incorrect initial vector size");
            }
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            cipher.init(1, (Key)new SecretKeySpec(keyBits.getImmutableArray(), "AES"), new IvParameterSpec(params.getInitialVector().getImmutableArray()));
            return new Blob(cipher.doFinal(plainData.getImmutableArray()));
        }
        throw new Error("unsupported encryption mode");
    }
}

